/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.diffdeferdata.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EReferenceValuePresence;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;

public class DiffdeferdataResourceHandler
extends BasicResourceHandler {
    public void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
        ArrayList<EReferenceValuePresence> objectsToRemove = new ArrayList<EReferenceValuePresence>();
        ArrayList<EReferenceValuePresence> allRefValuePresences = new ArrayList<EReferenceValuePresence>();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof EReferenceValuePresence)) continue;
            EReferenceValuePresence eRefValuePresence = (EReferenceValuePresence)next;
            if (eRefValuePresence.getValue() == null || eRefValuePresence.getValueMatch() == null) {
                objectsToRemove.add(eRefValuePresence);
                continue;
            }
            allRefValuePresences.add(eRefValuePresence);
        }
        if (!objectsToRemove.isEmpty()) {
            EcoreUtil.deleteAll(objectsToRemove, (boolean)true);
            this.cleanReferenceMap(allRefValuePresences);
        }
    }

    private void cleanReferenceMap(Collection<EReferenceValuePresence> allRefValuePresences) {
        for (EReferenceValuePresence refValuePresence : allRefValuePresences) {
            EMatch elementMatch = refValuePresence.getElementMatch();
            EMap forReference = (EMap)elementMatch.getModifiableReferenceMap().get(refValuePresence.getFeature());
            if (forReference == null || !forReference.values().contains(null)) continue;
            forReference.values().remove(null);
        }
    }
}

