/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.dialogs;

import java.text.DecimalFormat;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.filtering.tools.dialogs.FilteringLabelProvider;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringForMetricsLabelProvider
extends FilteringLabelProvider {
    Double varMetric;

    public FilteringForMetricsLabelProvider(TreeViewer viewer, int foregroundColorForReferencingElements) {
        super(viewer, foregroundColorForReferencingElements);
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        this.varMetric = null;
        if (columnIndex == 0) {
            text = this.getText(element);
        } else if (1 == columnIndex && element instanceof CapellaElement) {
            Double metric;
            this.varMetric = metric = FilteringForMetricsLabelProvider.getFilteringRate((EObject)element);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            text = df.format(metric);
        }
        return text;
    }

    @Override
    public Color getBackground(Object element) {
        if (this.varMetric == null) {
            return null;
        }
        if (this.varMetric == 0.0) {
            return null;
        }
        this.varMetric = this.varMetric + 5.0;
        Math.min(this.varMetric, 100.0);
        Double result = Math.abs(this.varMetric - 100.0);
        Integer greenValue = result.intValue() * 255 / 100;
        return new Color((Device)Display.getCurrent(), greenValue.intValue(), 255, greenValue.intValue());
    }

    public static Double getFilteringRate(EObject element) {
        if (FilteringUtils.hasAssociatedCriteria(element)) {
            return 100.0;
        }
        if (!element.eAllContents().hasNext()) {
            return 0.0;
        }
        double numberOfChilds = 0.0;
        double numberOfOptionalChilds = 0.0;
        TreeIterator i = ((CapellaElement)element).eAllContents();
        while (i.hasNext()) {
            EObject elt = (EObject)i.next();
            if (FilteringUtils.isInstanceOfFilteringExcludedElements(elt)) continue;
            numberOfChilds += 1.0;
            if (!FilteringUtils.hasAssociatedCriteria(elt)) continue;
            numberOfOptionalChilds += 1.0;
        }
        if (numberOfChilds > 0.0) {
            return numberOfOptionalChilds / numberOfChilds * 100.0;
        }
        return 0.0;
    }
}

