/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.view;

import java.util.HashMap;
import java.util.Map;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.tools.view.FilteringResultState;

public class GlobalFiteringCache {
    private static final long serialVersionUID = 4483023425603579476L;
    private Map<Project, FilteringResultState> cache = new HashMap<Project, FilteringResultState>();

    public void setCurrentFilteringResult(Project project, AbstractFilteringResult filteringResult) {
        FilteringResultState filteringResultState = this.cache.get(project);
        if (filteringResultState != null) {
            filteringResultState.setFilteringResult(filteringResult);
        } else {
            this.cache.put(project, new FilteringResultState(true, filteringResult));
        }
    }

    public AbstractFilteringResult getCurrentFilteringResult(Project project) {
        FilteringResultState filteringResultState = this.cache.get(project);
        if (filteringResultState != null) {
            return filteringResultState.getFilteringResult();
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    public FilteringResultState get(Project project) {
        return this.cache.get(project);
    }

    public void remove(Project project) {
        this.cache.remove(project);
    }

    public boolean isEnabled(Project project) {
        if (this.cache.get(project) == null) {
            return false;
        }
        return this.cache.get(project).isEnabled();
    }

    public void enable(Project project) {
        this.setEnabled(project, true);
    }

    public void disable(Project project) {
        this.setEnabled(project, false);
    }

    public void setEnabled(Project project, boolean enabled) {
        FilteringResultState filteringResultState = this.cache.get(project);
        if (filteringResultState != null) {
            filteringResultState.setEnabled(enabled);
        } else {
            this.cache.put(project, new FilteringResultState(enabled, null));
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

