/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.Messages;
import org.polarsys.capella.filtering.tools.actions.ComposedFilteringExtractionJob;
import org.polarsys.capella.filtering.tools.actions.ComposedFilteringProjectWizard;
import org.polarsys.capella.filtering.tools.actions.FilteringExtractionJob;
import org.polarsys.capella.filtering.tools.actions.FilteringProjectWizard;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilteringExtractionAction
implements IActionDelegate {
    private static final IEclipsePreferences PREFS = InstanceScope.INSTANCE.getNode(FilteringToolsPlugin.getDefault().getPluginId());
    private AbstractFilteringResult filteringResult = null;

    public void run(IAction action) {
        IProject project = FilteringUtils.getEclipseProject((EObject)this.filteringResult);
        if (project == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FilteringExtractionAction_0, (String)Messages.FilteringExtractionAction_1);
            return;
        }
        Project domainMelodyProject = CapellaProjectHelper.getProject((EObject)this.filteringResult);
        String domainId = domainMelodyProject.getId();
        if (!PREFS.getBoolean("APPLICATION_PROJECT_WITH_DIFFERENT_ID", false) && !FilteringUtils.getReferencedLibraries(domainMelodyProject).isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FilteringExtractionAction_0, (String)Messages.FilteringExtractionAction_projectHasReferenceToLibrary);
            return;
        }
        try {
            if (FilteringUtils.getSemanticModels(project).isEmpty()) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FilteringExtractionAction_0, (String)Messages.FilteringExtractionAction_melodymodellerFileNotFound);
                return;
            }
        }
        catch (CoreException exception) {
            return;
        }
        this.doAction(this.filteringResult, project, domainId);
    }

    private void doAction(AbstractFilteringResult filteringResult, IProject project, String domainId) {
        if (filteringResult instanceof ComposedFilteringResult) {
            this.doAction((ComposedFilteringResult)filteringResult, project, domainId);
        } else if (filteringResult instanceof FilteringResult) {
            this.doAction((FilteringResult)filteringResult, project, domainId);
        }
    }

    private void doAction(FilteringResult filteringResult, IProject project, String domainId) {
        FilteringProjectWizard wizard = new FilteringProjectWizard(project, (AbstractFilteringResult)filteringResult);
        ((BasicNewResourceWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            List<FilteringCriterion> selectedFeatures = wizard.getSelectedFeatures();
            IProject clonedProject = wizard.getResult();
            if (clonedProject != null) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                try (ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);){
                    try {
                        FilteringExtractionJob job = new FilteringExtractionJob(project, clonedProject, selectedFeatures, (AbstractFilteringResult)filteringResult, domainId);
                        progressMonitorDialog.setBlockOnOpen(false);
                        progressMonitorDialog.setCancelable(true);
                        progressMonitorDialog.open();
                        workspace.run((IWorkspaceRunnable)job, progressMonitorDialog.getProgressMonitor());
                    }
                    catch (CoreException exception) {
                        MessageDialog.openError((Shell)shell, (String)Messages.FilteringExtractionAction_2, (String)Messages.FilteringExtractionAction_3);
                        progressMonitorDialog.close();
                    }
                }
            }
        }
    }

    private void doAction(ComposedFilteringResult filteringResult, IProject project, String domainId) {
        ComposedFilteringProjectWizard wizard = new ComposedFilteringProjectWizard(project, filteringResult);
        ((BasicNewResourceWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            EList selectedFeatures = wizard.getSelectedComposedResult().computeFilteringCriterionSet().getFilteringCriteria();
            IProject clonedProject = wizard.getResult();
            if (clonedProject != null) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                try (ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);){
                    try {
                        ComposedFilteringExtractionJob job = new ComposedFilteringExtractionJob(project, clonedProject, (List<FilteringCriterion>)selectedFeatures, (AbstractFilteringResult)filteringResult, domainId);
                        pmd.setBlockOnOpen(false);
                        pmd.setCancelable(true);
                        pmd.open();
                        workspace.run((IWorkspaceRunnable)job, pmd.getProgressMonitor());
                    }
                    catch (CoreException exception) {
                        MessageDialog.openError((Shell)shell, (String)Messages.FilteringExtractionAction_2, (String)Messages.FilteringExtractionAction_3);
                        pmd.close();
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.filteringResult = (AbstractFilteringResult)((StructuredSelection)selection).getFirstElement();
        }
    }
}

