/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ui.actions.AbstractTigAction;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.dialogs.FilteringCriteriaSelectionDialog;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;

public class FilteringMultipleCriteriaAssigningAction
extends AbstractTigAction
implements IActionDelegate {
    protected FilteringCriteriaSelectionDialog checkedTreeSelectionDialog;

    public void run(IAction action) {
        final Set<EObject> semanticElements = this.resolveSemanticElements(this.getSelectedElements());
        if (semanticElements.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getActiveShell(), (String)"Info", (String)"No valid Capella element was selected !");
            return;
        }
        Collection<FilteringModel> filteringModels = FilteringUtils.getCommonFilteringModels(semanticElements, true);
        if (filteringModels.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getActiveShell(), (String)"Info", (String)"No valid Capella element was selected !");
            return;
        }
        List<FilteringCriterion> availableFeatures = FilteringUtils.getOwnedFilteringCriteria(filteringModels);
        ArrayList<Object> globalFeatures = new ArrayList<Object>();
        ArrayList<Object> checkedFeatures = new ArrayList<Object>();
        HashMap<EObject, Integer> infoFeatures = new HashMap<EObject, Integer>();
        for (EObject eObject : semanticElements) {
            List<FilteringCriterion> elementFeatures = FilteringUtils.getExplicitAssociatedCriteria(eObject);
            for (EObject eObject2 : elementFeatures) {
                if (!infoFeatures.containsKey(eObject2)) {
                    infoFeatures.put(eObject2, 1);
                    if (checkedFeatures.contains(eObject2)) continue;
                    checkedFeatures.add(eObject2);
                    continue;
                }
                infoFeatures.put(eObject2, (Integer)infoFeatures.get(eObject2) + 1);
            }
        }
        for (Object object : availableFeatures) {
            Integer counter = (Integer)infoFeatures.get(object);
            if (counter == null || counter.intValue() != semanticElements.size()) continue;
            globalFeatures.add(object);
        }
        this.setupDialog(filteringModels, globalFeatures, checkedFeatures);
        if (this.checkedTreeSelectionDialog.open() == 0) {
            AbstractReadWriteCommand abstractReadWriteCommand = new AbstractReadWriteCommand(){

                public void run() {
                    HashSet<FilteringCriterion> featuresToAdd = new HashSet<FilteringCriterion>();
                    HashSet<FilteringCriterion> featuresToRemove = new HashSet<FilteringCriterion>();
                    Collection<Object> toCheck = FilteringMultipleCriteriaAssigningAction.this.checkedTreeSelectionDialog.getCheckedElements();
                    Collection<Object> toUnCheck = FilteringMultipleCriteriaAssigningAction.this.checkedTreeSelectionDialog.getUnCheckedElements();
                    Collection<Object> undefined = FilteringMultipleCriteriaAssigningAction.this.checkedTreeSelectionDialog.getUndefinedElements();
                    if (!undefined.isEmpty()) {
                        toCheck.removeAll(undefined);
                        toUnCheck.removeAll(undefined);
                    }
                    for (EObject element : semanticElements) {
                        for (Object unCheckMe : toUnCheck) {
                            if (!FilteringUtils.getExplicitAssociatedCriteria(element).contains(unCheckMe)) continue;
                            featuresToRemove.add((FilteringCriterion)unCheckMe);
                        }
                        for (Object checkMe : toCheck) {
                            if (FilteringUtils.getExplicitAssociatedCriteria(element).contains(checkMe)) continue;
                            featuresToAdd.add((FilteringCriterion)checkMe);
                        }
                        FilteringUtils.addAssociatedCriteria(element, featuresToAdd);
                        FilteringUtils.removeAssociatedCriteria(element, featuresToRemove);
                        featuresToAdd.clear();
                        featuresToRemove.clear();
                    }
                }
            };
            FilteringUtils.executeCommand(abstractReadWriteCommand, semanticElements);
        }
    }

    private Set<EObject> resolveSemanticElements(Collection<ModelElement> selectedElements) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject eObject : selectedElements) {
            EObject semanticObject = CapellaAdapterHelper.resolveSemanticObject((Object)eObject);
            if (semanticObject == null) continue;
            result.add(semanticObject);
        }
        return result;
    }

    private void setupDialog(Collection<FilteringModel> filteringModels, Collection<Object> globalFeatures, List<Object> checkedFeatures) {
        Collection<Project> projects = this.getProjects(filteringModels);
        Session session = SessionManager.INSTANCE.getSession((EObject)projects.iterator().next());
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        this.checkedTreeSelectionDialog = new FilteringCriteriaSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new TransactionalAdapterFactoryLabelProvider(transactionalEditingDomain, ((AdapterFactoryEditingDomain)transactionalEditingDomain).getAdapterFactory()), new CriteriaContentProvider(), projects);
        this.checkedTreeSelectionDialog.setTitle("Assign Filtering Criteria");
        this.checkedTreeSelectionDialog.setMessage("Select the desired Filtering Criteria for the selection");
        this.checkedTreeSelectionDialog.setInput(projects);
        this.checkedTreeSelectionDialog.setInitialElementSelections(checkedFeatures);
        this.checkedTreeSelectionDialog.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)FilteringToolsPlugin.getDefault().getPluginId(), (String)"icons/criteriaAssigning.png").createImage());
        this.checkedTreeSelectionDialog.setComparator(new ViewerComparator());
        HashSet<Object> undefinedElements = new HashSet<Object>();
        for (Object feature : checkedFeatures) {
            if (globalFeatures.contains(feature)) continue;
            undefinedElements.add(feature);
        }
        this.checkedTreeSelectionDialog.setInitialUndefinedElements(undefinedElements);
    }

    private Collection<Project> getProjects(Collection<FilteringModel> filteringModels) {
        HashSet<Project> result = new HashSet<Project>();
        for (FilteringModel fm : filteringModels) {
            Project project = CapellaProjectHelper.getProject((EObject)fm);
            if (project == null) continue;
            result.add(project);
        }
        return result;
    }
}

