/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.massactions;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.DateCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.vp.requirements.model.helpers.TypeHelper;
import org.polarsys.capella.vp.requirements.ui.massactions.EnumerationDisplayConverter;
import org.polarsys.capella.vp.requirements.ui.massactions.Messages;
import org.polarsys.kitalpha.massactions.core.column.AbstractMAColumn;
import org.polarsys.kitalpha.massactions.core.helper.DisplayConverterHelper;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Attribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinitionEnumeration;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeOwner;
import org.polarsys.kitalpha.vp.requirements.Requirements.BooleanValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.DateValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationDataTypeDefinition;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.IntegerValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.RealValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;
import org.polarsys.kitalpha.vp.requirements.Requirements.StringValueAttribute;

public class AttributeDefinitionColumn
extends AbstractMAColumn {
    protected EClass type;
    protected AttributeDefinition definition;

    public AttributeDefinitionColumn(EClass type, AttributeDefinition definition) {
        this.type = type;
        this.definition = definition;
    }

    public EClass getType() {
        return this.type;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.getIdentifier(this.definition));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeDefinitionColumn) {
            AttributeDefinitionColumn clm = (AttributeDefinitionColumn)((Object)obj);
            return this.getIdentifier(this.definition).equals(this.getIdentifier(clm.definition));
        }
        return false;
    }

    public String getName() {
        return EObjectLabelProviderHelper.getText((EObject)this.definition);
    }

    public String getLabel() {
        return EObjectLabelProviderHelper.getText((EObject)this.definition);
    }

    protected IDisplayConverter createDisplayConverter() {
        if (this.definition instanceof AttributeDefinitionEnumeration) {
            return new EnumerationDisplayConverter();
        }
        EDataType dataType = TypeHelper.getDataType((EClass)this.type);
        if (dataType != null) {
            return DisplayConverterHelper.getDisplayConverter((String)dataType.getName());
        }
        return super.createDisplayConverter();
    }

    protected ICellEditor createCellEditor() {
        if (this.definition instanceof AttributeDefinitionEnumeration) {
            List values = ((EnumerationDataTypeDefinition)((AttributeDefinitionEnumeration)this.definition).getDefinitionType()).getSpecifiedValues().stream().map(EnumValue.class::cast).collect(Collectors.toList());
            ComboBoxCellEditor editor = new ComboBoxCellEditor(values);
            editor.setMultiselect(((AttributeDefinitionEnumeration)this.definition).isMultiValued());
            return editor;
        }
        EDataType dataType = TypeHelper.getDataType((EClass)this.type);
        if (EcorePackage.Literals.EDATE == dataType) {
            return new DateCellEditor();
        }
        return super.createCellEditor();
    }

    protected ICellPainter createCellPainter() {
        if (this.definition instanceof AttributeDefinitionEnumeration && this.isEditable()) {
            return new PaddingDecorator((ICellPainter)new ComboBoxPainter(), 0, 5, 0, 5);
        }
        return super.createCellPainter();
    }

    public Object getDataValue(EObject arg0) {
        if (arg0 instanceof AttributeOwner) {
            Optional<Attribute> attr = ((AttributeOwner)arg0).getOwnedAttributes().stream().filter(a -> this.getIdentifier(this.definition).equals(this.getIdentifier(a.getDefinition()))).findFirst();
            if (attr.isPresent()) {
                Attribute a2 = attr.get();
                if (a2 instanceof BooleanValueAttribute) {
                    return ((BooleanValueAttribute)a2).isValue();
                }
                if (a2 instanceof DateValueAttribute) {
                    return ((DateValueAttribute)a2).getValue() == null ? Date.from(Instant.EPOCH) : ((DateValueAttribute)a2).getValue();
                }
                if (a2 instanceof EnumerationValueAttribute) {
                    return ((EnumerationValueAttribute)a2).getValues();
                }
                if (a2 instanceof IntegerValueAttribute) {
                    return ((IntegerValueAttribute)a2).getValue();
                }
                if (a2 instanceof RealValueAttribute) {
                    return ((RealValueAttribute)a2).getValue();
                }
                if (a2 instanceof StringValueAttribute) {
                    return ((StringValueAttribute)a2).getValue();
                }
                return attr.get();
            }
            if (TypeHelper.getCompatibleType((AttributeDefinition)this.definition) == RequirementsPackage.Literals.DATE_VALUE_ATTRIBUTE) {
                return Date.from(Instant.EPOCH);
            }
        }
        return null;
    }

    public void setDataValue(EObject arg0, Object arg1) {
        AttributeOwner req = (AttributeOwner)arg0;
        Attribute attribute = ((AttributeOwner)arg0).getOwnedAttributes().stream().filter(aa -> this.getIdentifier(this.definition).equals(this.getIdentifier(aa.getDefinition()))).findFirst().orElseGet(() -> this.createAttribute(req, this.definition));
        if (attribute instanceof BooleanValueAttribute && arg1 instanceof Boolean) {
            ((BooleanValueAttribute)attribute).setValue(((Boolean)arg1).booleanValue());
        } else if (attribute instanceof DateValueAttribute && arg1 instanceof Date) {
            ((DateValueAttribute)attribute).setValue((Date)arg1);
        } else if (attribute instanceof EnumerationValueAttribute) {
            ((EnumerationValueAttribute)attribute).getValues().clear();
            if (arg1 instanceof EnumValue) {
                ((EnumerationValueAttribute)attribute).getValues().add((Object)((EnumValue)arg1));
            } else if (arg1 instanceof Collection && !((Collection)arg1).isEmpty()) {
                ((EnumerationValueAttribute)attribute).getValues().addAll((Collection)arg1);
            }
        } else if (attribute instanceof IntegerValueAttribute && arg1 instanceof Integer) {
            ((IntegerValueAttribute)attribute).setValue(((Integer)arg1).intValue());
        } else if (attribute instanceof RealValueAttribute && arg1 instanceof Double) {
            ((RealValueAttribute)attribute).setValue(((Double)arg1).doubleValue());
        } else if (attribute instanceof StringValueAttribute) {
            String value = arg1 == null ? "" : arg1.toString();
            ((StringValueAttribute)attribute).setValue(value);
        }
    }

    public void dataChanged(Collection<EObject> arg0) {
    }

    public Attribute createAttribute(AttributeOwner req, AttributeDefinition definition) {
        AttributeDefinition wantedDefinition = definition;
        Attribute attr = null;
        AbstractType type = TypeHelper.getType((AttributeOwner)req);
        if (type != null && (wantedDefinition = type.getOwnedAttributes().stream().filter(a -> this.getIdentifier((AttributeDefinition)a).equals(this.getIdentifier(definition))).findFirst().orElseGet(() -> definition)).eContainer() != type) {
            ReportManagerRegistry.getInstance().subscribe("Model Management").warn((Object)new EmbeddedMessage(NLS.bind((String)Messages.AttributeDefinitionColumn_AttributeOnWrongType, (Object[])new String[]{EObjectLabelProviderHelper.getText((EObject)wantedDefinition), EObjectLabelProviderHelper.getText((EObject)req), EObjectLabelProviderHelper.getText((EObject)((Requirement)req).getRequirementType())}), "Model Management", Arrays.asList(attr, req)));
            return null;
        }
        EClass toCreate = TypeHelper.getCompatibleType((AttributeDefinition)wantedDefinition);
        attr = (Attribute)toCreate.getEPackage().getEFactoryInstance().create(toCreate);
        req.getOwnedAttributes().add((Object)attr);
        attr.setDefinition(wantedDefinition);
        return attr;
    }

    private String getIdentifier(AttributeDefinition definition) {
        if (definition == null) {
            return String.valueOf(definition);
        }
        if (definition.getReqIFLongName() == null) {
            return definition.getId();
        }
        if (definition instanceof AttributeDefinitionEnumeration) {
            return definition.getId();
        }
        if (definition.getDefinitionType() != null) {
            return String.valueOf(definition.getReqIFLongName()) + definition.getDefinitionType().getReqIFLongName();
        }
        return definition.getReqIFLongName();
    }
}

