/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.traceability.config;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ExtendedTraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.traceability.RealizationLinkTraceabilityHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.transition.system2subsystem.handlers.traceability.SIDTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeTargetConfiguration
extends ExtendedTraceabilityConfiguration {
    protected String getExtensionIdentifier(IContext context_p) {
        return "targetTraceabilityConfiguration";
    }

    protected void initHandlers(IContext fContext_p) {
        this.addHandler(fContext_p, (ITraceabilityHandler)new TargetReconciliationTraceabilityHandler(this.getIdentifier(fContext_p)));
        this.addHandler(fContext_p, (ITraceabilityHandler)new TargetSIDTraceabilityHandler(this.getIdentifier(fContext_p)));
    }

    public boolean useHandlerForAttachment(EObject source_p, EObject target_p, ITraceabilityHandler handler_p, IContext context_p) {
        if (handler_p instanceof ReconciliationTraceabilityHandler) {
            return false;
        }
        return super.useHandlerForAttachment(source_p, target_p, handler_p, context_p);
    }

    public boolean useHandlerForTracedElements(EObject source_p, ITraceabilityHandler handler_p, IContext context_p) {
        boolean result = super.useHandlerForTracedElements(source_p, handler_p, context_p);
        if (result && handler_p instanceof SIDTraceabilityHandler) {
            if (source_p instanceof SystemEngineering) {
                result = false;
            }
            if (source_p instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    public boolean useHandlerForSourceElements(EObject source_p, ITraceabilityHandler handler_p, IContext context_p) {
        boolean result = super.useHandlerForSourceElements(source_p, handler_p, context_p);
        if (result && handler_p instanceof RealizationLinkTraceabilityHandler) {
            if (source_p instanceof SystemEngineering) {
                result = false;
            }
            if (source_p instanceof BlockArchitecture) {
                result = false;
            }
        }
        return result;
    }

    protected class TargetReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public TargetReconciliationTraceabilityHandler(String identifier_p) {
            super(identifier_p);
        }

        protected void initializeBlockArchitecture(BlockArchitecture source_p, BlockArchitecture target_p, IContext context_p, LevelBasedTraceabilityHandler.LevelMappingTraceability map_p) {
            super.initializeBlockArchitecture(source_p, target_p, context_p, map_p);
            Component sourceComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)source_p);
            Component targetComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)target_p);
            if (sourceComponent != null && targetComponent != null && !map_p.contains((Object)sourceComponent) && !map_p.contains((Object)targetComponent)) {
                this.addMapping((MappingTraceability)map_p, (EObject)sourceComponent, (EObject)targetComponent, context_p);
            }
            if (sourceComponent != null && sourceComponent.getRepresentingPartitions().size() == 1 && targetComponent != null && targetComponent.getRepresentingPartitions().size() == 1) {
                Partition sourcePartition = (Partition)sourceComponent.getRepresentingPartitions().get(0);
                Partition targetPartition = (Partition)targetComponent.getRepresentingPartitions().get(0);
                this.addMapping((MappingTraceability)map_p, (EObject)sourcePartition, (EObject)targetPartition, context_p);
            }
        }

        protected void initializeRootMappings(IContext context_p) {
            super.initializeRootMappings(context_p);
            EObject source = (EObject)context_p.get((Object)"_TSRo");
            EObject target = (EObject)context_p.get((Object)"_TTRo");
            this.addMappings(source, target, context_p);
        }
    }

    protected class TargetSIDTraceabilityHandler
    extends SIDTraceabilityHandler {
        public TargetSIDTraceabilityHandler(String identifier_p) {
            super(identifier_p);
        }

        protected void initializeRootMappings(IContext context_p) {
            super.initializeRootMappings(context_p);
            EObject source = (EObject)context_p.get((Object)"_TSRo");
            EObject target = (EObject)context_p.get((Object)"_TTRo");
            this.initializeMappings(source, target, context_p);
        }
    }
}

