/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.activities;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.common.merge.scope.IModelScopeFilter;
import org.polarsys.capella.core.transition.common.merge.scope.ReferenceModelScope;
import org.polarsys.capella.core.transition.common.merge.scope.TargetModelScope;
import org.polarsys.capella.core.transition.system.topdown.handlers.merge.RealizationLinkCategoryFilter;
import org.polarsys.capella.transition.system2subsystem.handlers.filter.UpdateOfCategoryFilter;
import org.polarsys.capella.transition.system2subsystem.handlers.traceability.config.MergeSourceConfiguration;
import org.polarsys.capella.transition.system2subsystem.handlers.traceability.config.MergeTargetConfiguration;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeDiffMergeActivity
extends org.polarsys.capella.core.transition.system.activities.InitializeDiffMergeActivity {
    protected IStatus initializeCategoriesHandlers(IContext context, IMergeHandler handler, ActivityParameters activityParams) {
        handler.addCategory((ICategoryItem)new RealizationLinkCategoryFilter(context), context);
        handler.addCategory((ICategoryItem)new UpdateOfCategoryFilter(FaPackage.Literals.FUNCTIONAL_CHAIN, context), context);
        handler.addCategory((ICategoryItem)new UpdateOfCategoryFilter(CsPackage.Literals.PHYSICAL_PATH, context), context);
        handler.addCategory((ICategoryItem)new UpdateOfCategoryFilter(InteractionPackage.Literals.SCENARIO, context), context);
        return super.initializeCategoriesHandlers(context, handler, activityParams);
    }

    protected IHandler createDefaultTraceabilitySourceHandler(IContext context) {
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)new MergeSourceConfiguration());
    }

    protected IHandler createDefaultTraceabilityTargetHandler(IContext context) {
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)new MergeTargetConfiguration());
    }

    protected IStatus initializeReferenceScope(IContext context, ActivityParameters activityParams) {
        super.initializeReferenceScope(context, activityParams);
        ReferenceModelScope sourceScope = (ReferenceModelScope)context.get((Object)"MERGE_SOURCE_SCOPE");
        Set libraries = (Set)context.get((Object)"ROOTS_FOR_LIBRARIES_OF_SOURCE_PROJECT");
        if (libraries != null && !libraries.isEmpty()) {
            for (Object library : libraries) {
                sourceScope.add((EObject)library, true);
            }
        }
        sourceScope.build(this.getReferenceFilter(context));
        return Status.OK_STATUS;
    }

    protected IStatus initializeTargetScope(IContext context, ActivityParameters activityParams) {
        super.initializeTargetScope(context, activityParams);
        TargetModelScope targetScope = (TargetModelScope)context.get((Object)"MERGE_TARGET_SCOPE");
        Set libraries = (Set)context.get((Object)"ROOTS_FOR_LIBRARIES_OF_TARGET_PROJECT");
        if (libraries instanceof Set) {
            for (Object library : libraries) {
                targetScope.add((EObject)library, true);
            }
        }
        targetScope.build(this.getTargetFilter(context));
        return Status.OK_STATUS;
    }

    protected IModelScopeFilter getTargetFilter(final IContext context) {
        return new IModelScopeFilter(){

            public boolean accepts(EObject element) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
                if (architecture == null) {
                    return true;
                }
                EClass targetArchitecture = TransformationHandlerHelper.getInstance((IContext)context).getTargetType((EObject)architecture, context);
                if (targetArchitecture != null && architecture.eClass() == targetArchitecture) {
                    return true;
                }
                Set libraries = (Set)context.get((Object)"ROOTS_FOR_LIBRARIES_OF_TARGET_PROJECT");
                return libraries.stream().anyMatch(lib -> EcoreUtil.isAncestor((EObject)lib, (EObject)element));
            }
        };
    }
}

