/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.validation;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.JustificationLink;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;

public class PreallocationConstraints
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof LogicalFunction) {
            return this.validateLogicalFunctionAllocations(ctx);
        }
        if (ctx.getTarget() instanceof PhysicalComponent) {
            return this.validatePhysicalComponentDeployments(ctx);
        }
        if (ctx.getTarget() instanceof FunctionalExchange) {
            return this.validateFunctionalExchangeAllocations(ctx);
        }
        if (ctx.getTarget() instanceof ComponentExchange) {
            return this.validateComponentExchangeAllocations(ctx);
        }
        throw new IllegalArgumentException();
    }

    private final LogicalFunction getParentFunction(LogicalFunction lf) {
        LogicalFunction parent = lf;
        LogicalFunction rootLogicalFunction = (LogicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)parent));
        if (parent != rootLogicalFunction) {
            while (!((parent = parent.eContainer()) instanceof LogicalFunction)) {
            }
        }
        return parent;
    }

    private final boolean isAllocatedToOrToAChild(LogicalFunction target, LogicalComponent shouldBeAllocatedOn) {
        boolean result = false;
        if (target.getAllocatorLogicalComponents().contains((Object)shouldBeAllocatedOn)) {
            result = true;
        } else {
            for (LogicalComponent lc : shouldBeAllocatedOn.getOwnedLogicalComponents()) {
                result = this.isAllocatedToOrToAChild(target, lc);
                if (result) break;
            }
        }
        return result;
    }

    private final IStatus validateLogicalFunctionAllocations(IValidationContext ctx) {
        LogicalFunction target = (LogicalFunction)ctx.getTarget();
        LogicalFunction rootLogicalFunction = (LogicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
        if (target.getOwnedFunctions().size() == 0) {
            LogicalFunction parentFunction = target;
            EList realisedFunctions = parentFunction.getRealizedSystemFunctions();
            while ((realisedFunctions == null || realisedFunctions.size() == 0) && parentFunction != rootLogicalFunction) {
                parentFunction = this.getParentFunction(parentFunction);
                realisedFunctions = parentFunction.getRealizedSystemFunctions();
            }
            for (SystemFunction sf : realisedFunctions) {
                for (AbstractTrace t : sf.getIncomingTraces()) {
                    LogicalComponent shouldBeAllocatedOn;
                    if (!(t instanceof JustificationLink) || this.isAllocatedToOrToAChild(target, shouldBeAllocatedOn = (LogicalComponent)t.getSourceElement())) continue;
                    return ctx.createFailureStatus(new Object[]{target, shouldBeAllocatedOn});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private final PhysicalComponent getParentPhysicalComponent(PhysicalComponent lf) {
        PhysicalComponent parent = lf;
        PhysicalComponent rootPhysicalComponent = (PhysicalComponent)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)parent));
        if (parent != rootPhysicalComponent) {
            while (!((parent = parent.eContainer()) instanceof PhysicalComponent)) {
            }
        }
        return parent;
    }

    private final boolean hasJustificationLink(TraceableElement te) {
        boolean hasJustificationLink = false;
        for (AbstractTrace t : te.getIncomingTraces()) {
            if (!(t instanceof JustificationLink)) continue;
            hasJustificationLink = true;
            break;
        }
        return hasJustificationLink;
    }

    private final boolean isParentOfPhysicalComponent(PhysicalComponent parentCandidate, PhysicalComponent child) {
        boolean isParentOfPhysicalComponent = false;
        PhysicalComponent rootPhysicalComponent = (PhysicalComponent)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)child));
        PhysicalComponent parent = child;
        while (parent != parentCandidate && parent != rootPhysicalComponent) {
            parent = this.getParentPhysicalComponent(parent);
        }
        if (parent == parentCandidate) {
            isParentOfPhysicalComponent = true;
        }
        return isParentOfPhysicalComponent;
    }

    private final LogicalComponent getParentLogicalComponent(LogicalComponent lf) {
        LogicalComponent parent = lf;
        LogicalComponent rootLogicalComponent = (LogicalComponent)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)parent));
        if (parent != rootLogicalComponent) {
            while (!((parent = parent.eContainer()) instanceof LogicalComponent)) {
            }
        }
        return parent;
    }

    private IStatus validatePhysicalComponentDeployments(IValidationContext ctx) {
        PhysicalComponent target = (PhysicalComponent)ctx.getTarget();
        PhysicalComponent rootPhysicalComponent = (PhysicalComponent)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)target));
        if (target.getNature() == PhysicalComponentNature.BEHAVIOR) {
            PhysicalComponent parentComponent = target;
            EList realisedLogicalComponents = parentComponent.getRealizedLogicalComponents();
            while ((realisedLogicalComponents == null || realisedLogicalComponents.size() == 0) && parentComponent != rootPhysicalComponent) {
                parentComponent = this.getParentPhysicalComponent(parentComponent);
                realisedLogicalComponents = parentComponent.getRealizedLogicalComponents();
            }
            Iterator iterator = realisedLogicalComponents.iterator();
            while (iterator.hasNext()) {
                LogicalComponent realized;
                LogicalComponent realizedParent = realized = (LogicalComponent)iterator.next();
                LogicalComponent rootLogicalComponent = (LogicalComponent)BlockArchitectureExt.getFirstComponent((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)realized));
                while (!this.hasJustificationLink((TraceableElement)realizedParent) && realizedParent != rootLogicalComponent) {
                    realizedParent = this.getParentLogicalComponent(realizedParent);
                }
                for (AbstractTrace t : realizedParent.getIncomingTraces()) {
                    if (!(t instanceof JustificationLink)) continue;
                    PhysicalComponent shouldBeDeployedOn = (PhysicalComponent)t.getSourceElement();
                    if (target.getDeployingPhysicalComponents() != null && target.getDeployingPhysicalComponents().size() > 0) {
                        for (PhysicalComponent deployingPhysicalComponent : target.getDeployingPhysicalComponents()) {
                            if (this.isParentOfPhysicalComponent(shouldBeDeployedOn, deployingPhysicalComponent)) continue;
                            return ctx.createFailureStatus(new Object[]{target, shouldBeDeployedOn});
                        }
                        continue;
                    }
                    return ctx.createFailureStatus(new Object[]{target, shouldBeDeployedOn});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateFunctionalExchangeAllocations(IValidationContext ctx) {
        FunctionalExchange target = (FunctionalExchange)ctx.getTarget();
        for (FunctionalExchange realizedFe : target.getRealizedFunctionalExchanges()) {
            for (AbstractTrace t : realizedFe.getIncomingTraces()) {
                if (!(t instanceof JustificationLink)) continue;
                ComponentExchange shouldBeAllocatedOn = (ComponentExchange)t.getSourceElement();
                if (target.getAllocatingComponentExchanges().contains((Object)shouldBeAllocatedOn)) continue;
                return ctx.createFailureStatus(new Object[]{target, shouldBeAllocatedOn});
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateComponentExchangeAllocations(IValidationContext ctx) {
        ComponentExchange target = (ComponentExchange)ctx.getTarget();
        for (ComponentExchange realizedCe : target.getRealizedComponentExchanges()) {
            for (AbstractTrace at : realizedCe.getIncomingTraces()) {
                if (!(at instanceof JustificationLink)) continue;
                PhysicalLink shouldBeAllocatedOn = (PhysicalLink)at.getSourceElement();
                if (target.getAllocatorPhysicalLinks().contains((Object)shouldBeAllocatedOn)) continue;
                return ctx.createFailureStatus(new Object[]{target, shouldBeAllocatedOn});
            }
        }
        return ctx.createSuccessStatus();
    }
}

