/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.ChainHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CyclePremices
extends System2SubsystemTest
implements System2SubsystemTest.Crossphase {
    public static final String FC1 = "9757b43d-88a6-419c-a530-198dfd11712b";
    public static final String FC2 = "a21fdc36-5f9c-4efa-bede-c29475c2754d";
    public static final String FC3 = "eb337843-955c-4b9a-a301-7af5eb8d940d";
    public static final String LC_1 = "ad104709-761a-44a8-8d17-d96bc90a423b";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE19 = "a6c4786d-0945-4626-bf62-9700273e5812";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF1 = "3617564a-af66-4b6a-ae0e-1b70e6b814fc";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF8 = "d54d04dc-6b83-4d04-a427-3c8dbc9373f6";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE17 = "3b86dfb7-f773-4f0a-909e-7102adb04d20";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF2 = "44b7cce6-fcca-475e-8dda-8e14573a351a";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE2 = "8450df92-b93d-4f51-ab45-a768204681ce";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF3 = "345a31d8-c596-4ec5-8858-d636558881c7";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE4 = "40a75bac-48f6-4e80-8009-1c9a54497531";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF4 = "1c4780ec-32a1-4d94-b331-890be6877fd8";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF6 = "88be76ed-0228-4cd9-9941-9d08904dd4b3";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE6 = "934f192e-ae81-4d85-85bc-36e1becfd416";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_LINK_TO_FE8 = "f0433aee-7d3f-40c9-a5fd-5e2623c5c40a";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF19 = "a31c11d1-1a34-4783-9d72-5a05410df558";
    public static final String FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF17 = "1a5da1fe-b32f-4c1a-8e11-2c3c6ffca2e0";

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("CyclePremices2", "output");
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return Collections.singleton(this.getObject(LC_1));
    }

    @Override
    protected void verify() {
        FunctionalChain fcsource = (FunctionalChain)this.getObject(FC3);
        FunctionalChain fc = (FunctionalChain)this.mustBeTransitioned(FC3);
        CyclePremices.assertTrue((fc.getOwnedFunctionalChainInvolvements().size() == fcsource.getOwnedFunctionalChainInvolvements().size() ? 1 : 0) != 0);
        TransitionContext context = ChainHelper.createBasicContext();
        FunctionalChainAttachmentHelper helper = new FunctionalChainAttachmentHelper(){

            protected Collection<FunctionalChain> getChainsToAnalyse(FunctionalChain element, IContext context_p) {
                BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
                return FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
            }
        };
        helper.setValidElement(this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF2), Boolean.valueOf(false), (IContext)context);
        Collection<String> paths = ChainHelper.pathsToString(helper.getNextPathsTowards((FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF8), (FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF4), (IContext)context));
        CyclePremices.assertTrue((boolean)paths.contains("LF8/FE19/LF1/FE6/LF6/FE8/LF3/FE4/LF4"));
        CyclePremices.assertTrue((boolean)paths.contains("LF8/FE19/LF1/FE17/LF2/FE2/LF3/FE4/LF4"));
        paths = ChainHelper.pathsToString(helper.getPreviousPathsTowards((FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF4), (FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF8), (IContext)context));
        CyclePremices.assertTrue((boolean)paths.contains("LF4/FE4/LF3/FE2/LF2/FE17/LF1/FE19/LF8"));
        CyclePremices.assertTrue((boolean)paths.contains("LF4/FE4/LF3/FE8/LF6/FE6/LF1/FE19/LF8"));
        paths = ChainHelper.pathsToString(helper.getNextPathsTowards((FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF19), (FunctionalChainInvolvement)this.getObject(FUNCTIONAL_CHAIN_INVOLVEMENT_FUNCTION_TO_LF17), (IContext)context));
        CyclePremices.assertTrue((boolean)paths.contains("LF19/FE20/LF14/FE7/LF18/FE9/LF16/FE5/LF17"));
        CyclePremices.assertTrue((boolean)paths.contains("LF19/FE20/LF14/FE18/LF15/FE3/LF16/FE5/LF17"));
    }
}

