/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.expression.ag;

import com.google.common.collect.Ordering;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.ag.ExcelExporter;

public class SituationExpressionExportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DTableEditor editor = (DTableEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ExcelExporter exporter = new ExcelExporter();
        ArrayList<Situation> toExport = new ArrayList<Situation>();
        DTable table = (DTable)editor.getRepresentation();
        for (DColumn c : table.getColumns()) {
            Situation s = (Situation)c.getTarget();
            if (s.getExpression() == null) continue;
            toExport.add(s);
        }
        ArrayList<StateMachine> sm = new ArrayList<StateMachine>();
        TreeIterator it = table.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof DLine) || !(((DLine)next).getTarget() instanceof StateMachine)) continue;
            sm.add((StateMachine)((DLine)next).getTarget());
        }
        Ordering columnOrder = Ordering.explicit(sm);
        Session session = SessionManager.INSTANCE.getSession(table.getTarget());
        URI sessionURI = session.getSessionResource().getURI();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = format.format(new Date());
        String excel = sessionURI.trimSegments(1).appendSegment(String.valueOf(table.getName()) + "_" + ts).appendFileExtension("xlsx").toPlatformString(true);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(excel));
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            exporter.export(toExport, (Comparator<StateMachine>)columnOrder, bytes);
            ByteArrayInputStream inbb = new ByteArrayInputStream(bytes.toByteArray());
            file.create((InputStream)inbb, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | CoreException e) {
            throw new ExecutionException("IOException during export", e);
        }
        return null;
    }
}

