/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.statemachine.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.MsPackage;

public final class StateMachineUtils {
    private StateMachineUtils() {
    }

    public static Region getRegion(AbstractState abstractState) {
        if (abstractState.eContainer() instanceof Region) {
            return (Region)abstractState.eContainer();
        }
        return null;
    }

    public static EList<StateMachine> getAllStateMachines(LogicalComponent logicalComponentRoot) {
        BasicEList allStateMachines = new BasicEList();
        allStateMachines.addAll((Collection)logicalComponentRoot.getOwnedStateMachines());
        if (!logicalComponentRoot.getSubLogicalComponents().isEmpty()) {
            for (LogicalComponent logicalComponent : logicalComponentRoot.getSubLogicalComponents()) {
                allStateMachines.addAll(StateMachineUtils.getAllStateMachines(logicalComponent));
            }
        }
        return allStateMachines;
    }

    public static EList<StateMachine> getAllStateMachines(PhysicalComponent physicalComponentRoot) {
        BasicEList allStateMachines = new BasicEList();
        allStateMachines.addAll((Collection)physicalComponentRoot.getOwnedStateMachines());
        if (!physicalComponentRoot.getSubPhysicalComponents().isEmpty()) {
            for (PhysicalComponent physicalComponent : physicalComponentRoot.getSubPhysicalComponents()) {
                allStateMachines.addAll(StateMachineUtils.getAllStateMachines(physicalComponent));
            }
        }
        return allStateMachines;
    }

    public static EList<State> getAllStates(StateMachine stateMachine) {
        BasicEList result = new BasicEList();
        for (Region subRegion : stateMachine.getOwnedRegions()) {
            result.addAll(StateMachineUtils.getAllStates(subRegion));
        }
        return result;
    }

    public static EList<State> getAllStates(Region region) {
        BasicEList result = new BasicEList();
        for (AbstractState abstractState : region.getOwnedStates()) {
            if (!(abstractState instanceof State)) continue;
            State state = (State)abstractState;
            result.add((Object)state);
            for (Region subRegion : state.getOwnedRegions()) {
                result.addAll(StateMachineUtils.getAllStates(subRegion));
            }
        }
        return result;
    }

    public static EList<Mode> getAllModes(StateMachine stateMachine) {
        BasicEList result = new BasicEList();
        for (Region subRegion : stateMachine.getOwnedRegions()) {
            result.addAll(StateMachineUtils.getAllModes(subRegion));
        }
        return result;
    }

    public static EList<Mode> getAllModes(Region region) {
        BasicEList result = new BasicEList();
        for (AbstractState abstractState : region.getOwnedStates()) {
            if (!(abstractState instanceof Mode)) continue;
            Mode state = (Mode)abstractState;
            result.add((Object)state);
            for (Region subRegion : state.getOwnedRegions()) {
                result.addAll(StateMachineUtils.getAllModes(subRegion));
            }
        }
        return result;
    }

    public static EList<State> getHigherStates(State state) {
        BasicEList result = new BasicEList();
        if (state.eContainer().eContainer() instanceof State) {
            result.add((Object)((State)state.eContainer().eContainer()));
            result.addAll(StateMachineUtils.getHigherStates((State)state.eContainer().eContainer()));
        }
        return result;
    }

    public static StateMachine getStateMachine(State state) {
        if (state.eContainer().eContainer() instanceof StateMachine) {
            return (StateMachine)state.eContainer().eContainer();
        }
        if (state.eContainer().eContainer() instanceof State) {
            return StateMachineUtils.getStateMachine((State)state.eContainer().eContainer());
        }
        return null;
    }

    public static EList<StateMachine> getAllStateMachines(EList<State> states) {
        BasicEList stateMachines = new BasicEList();
        for (State state : states) {
            StateMachine stateMachine = StateMachineUtils.getStateMachine(state);
            if (stateMachines.contains((Object)stateMachine)) continue;
            stateMachines.add((Object)stateMachine);
        }
        return stateMachines;
    }

    public static Component getComponent(StateMachine stateMachine) {
        if (stateMachine.eContainer() instanceof Component) {
            return (Component)stateMachine.eContainer();
        }
        return null;
    }

    public static EList<Component> getSystemComponents(EList<StateMachine> stateMachines) {
        BasicEList systemComponents = new BasicEList();
        for (StateMachine stateMachine : stateMachines) {
            if (!(stateMachine.eContainer() instanceof Component) || systemComponents.contains((Object)stateMachine.eContainer())) continue;
            systemComponents.add((Object)((Component)stateMachine.eContainer()));
        }
        return systemComponents;
    }

    public static boolean isAvailableIn(AbstractFunction function, StateMachine stateMachine) {
        EList<State> stateMachineElements = StateMachineUtils.getAllStates(stateMachine);
        BasicEList availableInStates = new BasicEList();
        for (State state : availableInStates) {
            if (!stateMachineElements.contains((Object)state)) continue;
            return true;
        }
        return false;
    }

    public static int getLevel(State state) {
        int level = 1;
        if (StateMachineUtils.isContainedInState(state)) {
            return level + StateMachineUtils.getLevel((State)state.eContainer().eContainer());
        }
        return level;
    }

    public static boolean isContainedInState(State state) {
        return state.eContainer().eContainer() instanceof State;
    }

    public static EList<StateTransition> getTransitionBetweenStates(AbstractState state1, AbstractState state2) {
        BasicEList transitions = new BasicEList();
        for (StateTransition incomingTransition : state1.getIncoming()) {
            if (!incomingTransition.getSource().equals(state2)) continue;
            transitions.add((Object)incomingTransition);
        }
        for (StateTransition outgoingTransition : state1.getOutgoing()) {
            if (!outgoingTransition.getTarget().equals(state2)) continue;
            transitions.add((Object)outgoingTransition);
        }
        return transitions;
    }

    public static boolean isPathFromState1ToState2(AbstractState state1, AbstractState state2) {
        StateMachineUtils stateMachineUtils = new StateMachineUtils();
        TargetStates targetStates = stateMachineUtils.new TargetStates();
        return targetStates.getAllTargetStates(state1).contains(state2);
    }

    public static EList<CSConfiguration> getCommonConfigurations(EList<Mode> modes) {
        BasicEList configurations = new BasicEList();
        if (!modes.isEmpty()) {
            configurations = new BasicEList(StateMachineUtils.getConfigurations((AbstractState)modes.get(0)));
            for (Mode mode : modes) {
                configurations.retainAll(StateMachineUtils.getConfigurations((AbstractState)mode));
            }
        }
        return configurations;
    }

    public static Collection<CSConfiguration> getConfigurations(AbstractState state) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)state);
        if (domain == null) {
            return Collections.emptyList();
        }
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        for (EStructuralFeature.Setting setting : domain.getCrossReferencer().getInverseReferences((EObject)state, MsPackage.Literals.CS_CONFIGURATION__SUPPORTED_MODES, true)) {
            result.add((CSConfiguration)setting.getEObject());
        }
        return result;
    }

    public class Paths {
        private Set<StateTransition> outgoingStateTransitions = new HashSet<StateTransition>();
        private Set<StateTransition> incomingStateTransitions = new HashSet<StateTransition>();

        public Set<StateTransition> getAllOutgoingStateTransitions(AbstractState state) {
            this.outgoingStateTransitions.clear();
            return this.getAllOutgoingStateTransitionsOperation(state);
        }

        private Set<StateTransition> getAllOutgoingStateTransitionsOperation(AbstractState state) {
            HashSet<StateTransition> directOutgoingStatesTransition = new HashSet<StateTransition>();
            for (StateTransition outgoingTrasition : state.getOutgoing()) {
                if (this.outgoingStateTransitions.contains(outgoingTrasition)) continue;
                directOutgoingStatesTransition.add(outgoingTrasition);
            }
            this.outgoingStateTransitions.addAll(directOutgoingStatesTransition);
            for (StateTransition outgoingTrasition : directOutgoingStatesTransition) {
                this.outgoingStateTransitions.addAll(this.getAllOutgoingStateTransitionsOperation(outgoingTrasition.getTarget()));
            }
            return this.outgoingStateTransitions;
        }

        public Set<StateTransition> getAllIncomingStateTransitions(AbstractState state) {
            this.incomingStateTransitions.clear();
            return this.getAllIncomingStateTransitionsOperation(state);
        }

        private Set<StateTransition> getAllIncomingStateTransitionsOperation(AbstractState state) {
            HashSet<StateTransition> directIncomingStatesTransition = new HashSet<StateTransition>();
            for (StateTransition incomingTrasition : state.getIncoming()) {
                if (this.incomingStateTransitions.contains(incomingTrasition)) continue;
                directIncomingStatesTransition.add(incomingTrasition);
            }
            this.incomingStateTransitions.addAll(directIncomingStatesTransition);
            for (StateTransition incomingTrasition : directIncomingStatesTransition) {
                this.incomingStateTransitions.addAll(this.getAllIncomingStateTransitionsOperation(incomingTrasition.getSource()));
            }
            return this.incomingStateTransitions;
        }

        public Set<StateTransition> getStateTransitionsInPaths(AbstractState beginningState, AbstractState endingState) {
            HashSet<StateTransition> stateTransitions = new HashSet<StateTransition>();
            stateTransitions.addAll(this.getAllOutgoingStateTransitions(beginningState));
            stateTransitions.retainAll(this.getAllIncomingStateTransitions(endingState));
            return stateTransitions;
        }
    }

    public class TargetStates {
        private Set<AbstractState> targetStates = new HashSet<AbstractState>();

        public Set<AbstractState> getAllTargetStates(AbstractState state) {
            this.targetStates.clear();
            return this.getAllTargetStatesOperation(state);
        }

        private Set<AbstractState> getAllTargetStatesOperation(AbstractState state) {
            HashSet<AbstractState> directTargetStates = new HashSet<AbstractState>();
            for (StateTransition outgoingTrasition : state.getOutgoing()) {
                if (this.targetStates.contains(outgoingTrasition.getTarget())) continue;
                directTargetStates.add(outgoingTrasition.getTarget());
            }
            this.targetStates.addAll(directTargetStates);
            for (AbstractState abstractState : directTargetStates) {
                this.targetStates.addAll(this.getAllTargetStatesOperation(abstractState));
            }
            return this.targetStates;
        }
    }
}

