/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaComponentPortHelper {
    public static Map<String, String> getProvidedInterfaces(ComponentPort component, String projectName, String outputFolder) {
        HashMap<String, String> providedInterfaces = new HashMap<String, String>();
        for (Interface modelInterface : component.getProvidedInterfaces()) {
            String interfaceString = CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)modelInterface);
            String interfaceExchangeItems = CapellaComponentPortHelper.getInterfaceExchangeItemsAsList(modelInterface, projectName, outputFolder);
            providedInterfaces.put(interfaceString, interfaceExchangeItems);
        }
        return providedInterfaces;
    }

    public static Map<String, String> getRequiredInterfaces(ComponentPort component, String projectName, String outputFolder) {
        HashMap<String, String> requiredInterfaces = new HashMap<String, String>();
        for (Interface modelInterface : component.getRequiredInterfaces()) {
            String interfaceString = CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)modelInterface);
            String interfaceExchangeItems = CapellaComponentPortHelper.getInterfaceExchangeItemsAsList(modelInterface, projectName, outputFolder);
            requiredInterfaces.put(interfaceString, interfaceExchangeItems);
        }
        return requiredInterfaces;
    }

    private static String getInterfaceExchangeItemsAsList(Interface modelInterface, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        if (modelInterface.getExchangeItems().size() > 0) {
            buffer.append("<ul class=\"generatedList\">");
            for (ExchangeItem exchangeItem : modelInterface.getExchangeItems()) {
                buffer.append("<li>");
                buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)exchangeItem));
                buffer.append("</li>");
            }
            buffer.append("</ul>");
        }
        return buffer.toString();
    }

    public static Collection<ComponentExchange> getComponentPortExchanges(ComponentPort componentPort, String projectName, String outputFolder) {
        return CapellaComponentPortHelper.deleteDelegations((Collection<ComponentExchange>)componentPort.getComponentExchanges());
    }

    public static Collection<ComponentExchange> getComponentPortDelegations(ComponentPort componentPort, String projectName, String outputFolder) {
        return CapellaComponentPortHelper.extractDelegations((Collection<ComponentExchange>)componentPort.getComponentExchanges());
    }

    public static String getComponentPortString(ComponentPort port, String projectName, String outputFolder) {
        return CapellaServices.buildNameWithIcon(projectName, outputFolder, (CapellaElement)port);
    }

    public static String componentExchangeToTableLine(ComponentPort currentComponentPort, ComponentExchange componentExchange, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)componentExchange) + "\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)componentExchange, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getHyperlinkFromElement((EObject)componentExchange));
        buffer.append("</td>");
        ModelElement sourceTargetComponentPort = CapellaComponentPortHelper.getOppositeComponentPort(currentComponentPort, componentExchange);
        if (sourceTargetComponentPort != null) {
            ModelElement sourceTargetComponent = (ModelElement)sourceTargetComponentPort.eContainer();
            buffer.append("<td>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)sourceTargetComponentPort));
            buffer.append("</td>");
            if (sourceTargetComponent != null) {
                buffer.append("<td>");
                buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)sourceTargetComponent));
                buffer.append("</td>");
            }
        }
        buffer.append("<td>");
        buffer.append(CapellaComponentPortHelper.getDescription(componentExchange, projectName, outputFolder));
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }

    private static Collection<ComponentExchange> deleteDelegations(Collection<ComponentExchange> componentExchanges) {
        ArrayList<ComponentExchange> newComponentExchanges = new ArrayList<ComponentExchange>(componentExchanges);
        for (ComponentExchange currentComponentExchange : componentExchanges) {
            if (currentComponentExchange.getKind().getValue() != 1) continue;
            newComponentExchanges.remove(currentComponentExchange);
        }
        return newComponentExchanges;
    }

    private static Collection<ComponentExchange> extractDelegations(Collection<ComponentExchange> componentExchanges) {
        ArrayList<ComponentExchange> newComponentExchanges = new ArrayList<ComponentExchange>(componentExchanges);
        for (ComponentExchange currentComponentExchange : componentExchanges) {
            if (currentComponentExchange.getKind().getValue() == 1) continue;
            newComponentExchanges.remove(currentComponentExchange);
        }
        return newComponentExchanges;
    }

    private static Object getDescription(ComponentExchange componentExchange, String projectName, String outputFolder) {
        if (componentExchange.getDescription() != null) {
            return StringUtil.transformAREFString((EObject)componentExchange, componentExchange.getDescription(), projectName, outputFolder);
        }
        return "";
    }

    private static ModelElement getOppositeComponentPort(ComponentPort currentComponentPort, ComponentExchange componentExchange) {
        if (componentExchange.getSourcePort() != currentComponentPort) {
            return componentExchange.getSourcePort();
        }
        return componentExchange.getTargetPort();
    }
}

