/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaComponentServices {
    private CapellaComponentServices() {
    }

    public static Collection<ComponentExchange> getIncomingComponentExchanges(Component element) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
        for (Feature currentFeature : element.getOwnedFeatures()) {
            if (!(currentFeature instanceof ComponentPort) || ((ComponentPort)currentFeature).getOrientation().getValue() != 1) continue;
            componentExchanges.addAll((Collection<ComponentExchange>)((ComponentPort)currentFeature).getComponentExchanges());
        }
        return CapellaComponentServices.deleteDelegations(componentExchanges);
    }

    public static Collection<ComponentExchange> getOutgoingComponentExchanges(Component element) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
        for (Feature currentFeature : element.getOwnedFeatures()) {
            if (!(currentFeature instanceof ComponentPort) || ((ComponentPort)currentFeature).getOrientation().getValue() != 2) continue;
            componentExchanges.addAll((Collection<ComponentExchange>)((ComponentPort)currentFeature).getComponentExchanges());
        }
        return CapellaComponentServices.deleteDelegations(componentExchanges);
    }

    public static Collection<ComponentExchange> getInOutComponentExchanges(Component element) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
        for (Feature currentFeature : element.getOwnedFeatures()) {
            if (!(currentFeature instanceof ComponentPort) || ((ComponentPort)currentFeature).getOrientation().getValue() != 3) continue;
            componentExchanges.addAll((Collection<ComponentExchange>)((ComponentPort)currentFeature).getComponentExchanges());
        }
        return CapellaComponentServices.deleteDelegations(componentExchanges);
    }

    public static String componentExchangeToTableLine(Component currentComponent, ComponentExchange componentExchange, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<tr>");
        buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)componentExchange) + "\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)componentExchange, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getHyperlinkFromElement((EObject)componentExchange));
        buffer.append("</td>");
        ModelElement sourceTargetComponent = CapellaComponentServices.getOppositeComponent(currentComponent, componentExchange);
        if (sourceTargetComponent != null) {
            buffer.append("<td>");
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)sourceTargetComponent, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)sourceTargetComponent));
            buffer.append("</td>");
        }
        buffer.append("<td>");
        buffer.append(CapellaComponentServices.getDescription(componentExchange, projectName, outputFolder));
        buffer.append("</td>");
        buffer.append("<td>");
        EList functionalExchanges = componentExchange.getAllocatedFunctionalExchanges();
        if (!functionalExchanges.isEmpty()) {
            buffer.append("<ul class=\"generatedList\">");
            for (FunctionalExchange currentItem : functionalExchanges) {
                buffer.append("<li>");
                buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentItem, projectName, outputFolder));
                buffer.append(" ");
                buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentItem));
                buffer.append("</li>");
            }
            buffer.append("</ul>");
        }
        buffer.append("</td>");
        buffer.append("<td>");
        if (!componentExchange.getConvoyedInformations().isEmpty()) {
            buffer.append("<ul class=\"generatedList\">");
            for (FunctionalExchange currentItem : componentExchange.getConvoyedInformations()) {
                buffer.append("<li>");
                buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentItem, projectName, outputFolder));
                buffer.append(" ");
                buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentItem));
                buffer.append("</li>");
            }
            buffer.append("</ul>");
        }
        buffer.append("</td>");
        EList realizedComponentExchanges = componentExchange.getRealizedComponentExchanges();
        buffer.append("<td>");
        buffer.append("<ul class=\"generatedList\">");
        for (ComponentExchange realizedComponentExchange : realizedComponentExchanges) {
            buffer.append("<li>");
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)realizedComponentExchange, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)realizedComponentExchange));
            buffer.append("</li>");
        }
        buffer.append("</ul>");
        buffer.append("</td>");
        buffer.append("<td>");
        EList realizingComponentExchanges = componentExchange.getRealizingComponentExchanges();
        buffer.append("<ul class=\"generatedList\">");
        for (ComponentExchange realizingComponentExchange : realizingComponentExchanges) {
            buffer.append("<li>");
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)realizingComponentExchange, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)realizingComponentExchange));
            buffer.append("</li>");
        }
        buffer.append("</ul>");
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }

    private static Collection<ComponentExchange> deleteDelegations(Collection<ComponentExchange> componentExchanges) {
        ArrayList<ComponentExchange> newComponentExchanges = new ArrayList<ComponentExchange>(componentExchanges);
        for (ComponentExchange currentComponentExchange : componentExchanges) {
            if (currentComponentExchange.getKind().getValue() != 1) continue;
            newComponentExchanges.remove(currentComponentExchange);
        }
        return newComponentExchanges;
    }

    private static ModelElement getOppositeComponent(Component currentComponent, ComponentExchange componentExchange) {
        ModelElement candidate = CapellaComponentServices.resolveInformationExchanger(componentExchange.getSource());
        if (candidate != null && candidate.equals(currentComponent)) {
            candidate = CapellaComponentServices.resolveInformationExchanger(componentExchange.getTarget());
        }
        return candidate;
    }

    private static ModelElement resolveInformationExchanger(InformationsExchanger informationsExchanger) {
        if (informationsExchanger instanceof ComponentPort) {
            EObject portContainer = ((ComponentPort)informationsExchanger).eContainer();
            if (portContainer instanceof ModelElement) {
                return (ModelElement)portContainer;
            }
        } else if (informationsExchanger instanceof ComponentExchangeEnd) {
            Port port = ((ComponentExchangeEnd)informationsExchanger).getPort();
            if (port instanceof InformationsExchanger) {
                return CapellaComponentServices.resolveInformationExchanger((InformationsExchanger)port);
            }
            return port;
        }
        return informationsExchanger;
    }

    private static Object getDescription(ComponentExchange componentExchange, String projectName, String outputFolder) {
        if (componentExchange.getDescription() != null) {
            return StringUtil.transformAREFString((EObject)componentExchange, componentExchange.getDescription(), projectName, outputFolder);
        }
        return "";
    }

    public static Collection<String> getAllocatedFunctionsInformation(Component component, String projectName, String outputFolder) {
        ArrayList<String> functionsString = new ArrayList<String>();
        for (AbstractFunction currentAbstractFunction : component.getAllocatedFunctions()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentAbstractFunction, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentAbstractFunction));
            functionsString.add(buffer.toString());
        }
        return functionsString;
    }

    public static Collection<String> getImplementedInterfaces(Component component, String projectName, String outputFolder) {
        ArrayList<String> implementedInterfaces = new ArrayList<String>();
        for (Interface currenInterface : component.getImplementedInterfaces()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(CapellaComponentServices.interfaceToSingleLineDescription(projectName, outputFolder, currenInterface));
            Set<Component> userAndRequiringComponents = CapellaComponentServices.getUserAndRequiringComponents(currenInterface);
            if (!userAndRequiringComponents.isEmpty()) {
                buffer.append("\n<br />");
                buffer.append("<ul class=\"generatedList\">");
                buffer.append("<li>");
                buffer.append("<strong>For</strong> ");
                buffer.append(CapellaComponentServices.componentsToSingleLineList(projectName, outputFolder, userAndRequiringComponents));
                buffer.append("</li>");
                buffer.append("</ul>");
            }
            implementedInterfaces.add(buffer.toString());
        }
        return implementedInterfaces;
    }

    private static String interfaceToSingleLineDescription(String projectName, String outputFolder, Interface currenInterface) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)currenInterface, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)currenInterface));
        if (currenInterface.getSummary() != null && currenInterface.getSummary().length() > 0) {
            buffer.append(": ");
            buffer.append(currenInterface.getSummary());
        }
        return buffer.toString();
    }

    private static Set<Component> getUserAndRequiringComponents(Interface currenInterface) {
        HashSet<Component> userAndRequiringComponents = new HashSet<Component>();
        userAndRequiringComponents.addAll((Collection<Component>)currenInterface.getUserComponents());
        userAndRequiringComponents.addAll(InterfaceExt.getRequireComponent((Interface)currenInterface));
        return userAndRequiringComponents;
    }

    private static Set<Component> getImplementorAndProviderComponents(Interface currenInterface) {
        HashSet<Component> implementorAndProviderComponents = new HashSet<Component>();
        implementorAndProviderComponents.addAll((Collection<Component>)currenInterface.getImplementorComponents());
        implementorAndProviderComponents.addAll(InterfaceExt.getProviderComponent((Interface)currenInterface));
        return implementorAndProviderComponents;
    }

    private static String componentsToSingleLineList(String projectName, String outputFolder, Collection<Component> userAndRequiringComponents) {
        StringBuilder buffer = new StringBuilder();
        Iterator<Component> userAndRequiringComponentsIterator = userAndRequiringComponents.iterator();
        while (userAndRequiringComponentsIterator.hasNext()) {
            Component currentComponent = userAndRequiringComponentsIterator.next();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentComponent, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentComponent));
            if (!userAndRequiringComponentsIterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public static Collection<String> getProvidedInterfaces(Component component, String projectName, String outputFolder) {
        ArrayList<String> providedInterfaces = new ArrayList<String>();
        for (Interface currentInterface : component.getProvidedInterfaces()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(CapellaComponentServices.interfaceToSingleLineDescription(projectName, outputFolder, currentInterface));
            if (currentInterface instanceof Interface) {
                ComponentPort port;
                Set<Component> userAndRequiringComponents = CapellaComponentServices.getUserAndRequiringComponents(currentInterface);
                buffer.append("<ul class=\"generatedList\">");
                buffer.append("<li>");
                buffer.append("<table style=\"border:0px;\">");
                if (!userAndRequiringComponents.isEmpty()) {
                    buffer.append("<tr>");
                    buffer.append("<td style=\"border:0px\"><strong>For</strong> </td>");
                    buffer.append("<td style=\"max-width:100%; border:0px\">");
                    buffer.append(CapellaComponentServices.componentsToSingleLineList(projectName, outputFolder, userAndRequiringComponents));
                    buffer.append("</td>");
                    buffer.append("</tr>");
                }
                if ((port = CapellaComponentServices.getCorrespondingParentPort(component, InterfaceExt.getProvidedByPorts((Interface)currentInterface))) != null) {
                    buffer.append(CapellaComponentServices.portToSingleLine(projectName, outputFolder, port));
                }
                buffer.append("</table>");
                buffer.append("</li>");
                buffer.append("</ul>");
            }
            providedInterfaces.add(buffer.toString());
        }
        return providedInterfaces;
    }

    public static Collection<String> getUsedInterfaces(Component component, String projectName, String outputFolder) {
        ArrayList<String> usedInterfaces = new ArrayList<String>();
        for (Interface currenInterface : component.getUsedInterfaces()) {
            Set<Component> implementorAndProviderComponents;
            StringBuilder buffer = new StringBuilder();
            buffer.append(CapellaComponentServices.interfaceToSingleLineDescription(projectName, outputFolder, currenInterface));
            if (currenInterface instanceof Interface && !(implementorAndProviderComponents = CapellaComponentServices.getImplementorAndProviderComponents(currenInterface)).isEmpty()) {
                buffer.append("\n<br />");
                buffer.append("<ul class=\"generatedList\">");
                buffer.append("<li>");
                buffer.append("<strong>From</strong> ");
                buffer.append(CapellaComponentServices.componentsToSingleLineList(projectName, outputFolder, implementorAndProviderComponents));
                buffer.append("</li>");
                buffer.append("</ul>");
            }
            usedInterfaces.add(buffer.toString());
        }
        return usedInterfaces;
    }

    public static Collection<String> getRequiredInterfaces(Component component, String projectName, String outputFolder) {
        ArrayList<String> requiredInterfaces = new ArrayList<String>();
        for (Interface currentInterface : component.getRequiredInterfaces()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CapellaComponentServices.interfaceToSingleLineDescription(projectName, outputFolder, currentInterface));
            if (currentInterface instanceof Interface) {
                ComponentPort port;
                Set<Component> implementorAndProviderComponents = CapellaComponentServices.getImplementorAndProviderComponents(currentInterface);
                stringBuilder.append("<ul class=\"generatedList\">");
                stringBuilder.append("<li>");
                stringBuilder.append("<table style=\"border:0px;\">");
                if (!implementorAndProviderComponents.isEmpty()) {
                    stringBuilder.append("<tr>");
                    stringBuilder.append("<td style=\"border:0px\"><strong>From</strong> </td>");
                    stringBuilder.append("<td style=\"max-width:100%; border:0px\">");
                    stringBuilder.append(CapellaComponentServices.componentsToSingleLineList(projectName, outputFolder, implementorAndProviderComponents));
                    stringBuilder.append("</td>");
                    stringBuilder.append("</tr>");
                }
                if ((port = CapellaComponentServices.getCorrespondingParentPort(component, InterfaceExt.getRequiredByPorts((Interface)currentInterface))) != null) {
                    stringBuilder.append(CapellaComponentServices.portToSingleLine(projectName, outputFolder, port));
                }
                stringBuilder.append("</table>");
                stringBuilder.append("</li>");
                stringBuilder.append("</ul>");
            }
            requiredInterfaces.add(stringBuilder.toString());
        }
        return requiredInterfaces;
    }

    private static String portToSingleLine(String projectName, String outputFolder, ComponentPort port) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td style=\"border:0px\"><strong>Through</strong> </td>");
        stringBuilder.append("<td style=\"max-width:100%; border:0px\">");
        stringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)port, projectName, outputFolder));
        stringBuilder.append(" ");
        stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)port));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        return stringBuilder.toString();
    }

    private static ComponentPort getCorrespondingParentPort(Component component, List<ComponentPort> requiredByPorts) {
        for (ComponentPort currentComponentPort : requiredByPorts) {
            if (!currentComponentPort.eContainer().equals(component)) continue;
            return currentComponentPort;
        }
        return null;
    }

    public static Collection<String> getPorts(Component component, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Port port : ComponentExt.getOwnedPort((Component)component)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)port, projectName, outputFolder));
            stringBuilder.append(" ");
            stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)port));
            ret.add(stringBuilder.toString());
        }
        return ret;
    }

    public static Collection<String> getFeatures(Component component) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("<b>Is Actor\t:\t</b>" + component.isActor());
        ret.add("<b>Is Human\t:\t</b>" + component.isHuman());
        ret.add("<b>Is Abstract\t:\t</b>" + component.isAbstract());
        return ret;
    }
}

