/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.internal.statements;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.eobjects.IEObjectSource;
import org.eclipse.emf.query.internal.EMFQueryPlugin;
import org.eclipse.emf.query.internal.l10n.QueryMessages;
import org.eclipse.emf.query.internal.statements.QueryResultSet;
import org.eclipse.emf.query.statements.IQueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryStatement
implements IEObjectSource {
    public static final int WORK_UNIT = 1;
    private static final String EXECUTING_QUERY = QueryMessages.QueryStatement_Executing_Query____1_INFO_;
    private QueryResultSet resultSet = new QueryResultSet();
    private boolean cancellable;
    private IProgressMonitor progressMonitor;

    public QueryStatement(boolean cancellable, IProgressMonitor progressMonitor) {
        this.cancellable = cancellable;
        this.progressMonitor = progressMonitor;
    }

    protected void handleException(Exception exception, String functionName) {
        EMFQueryPlugin.catching(this.getClass(), functionName, exception);
        EMFQueryPlugin.log(10, exception.getMessage(), exception);
        this.resultSet.clear();
        this.resultSet.setException(exception);
    }

    public IQueryResult execute() {
        try {
            this.getProgressMonitor().beginTask(EXECUTING_QUERY, -1);
            this.doExecute();
        }
        catch (Exception exception) {
            this.handleException(exception, "execute");
        }
        this.getProgressMonitor().done();
        return this.getResultSet();
    }

    public IQueryResult resume(IProgressMonitor progressMon) {
        this.progressMonitor = progressMon;
        try {
            if (!this.canBeResumed()) {
                IllegalStateException ex = new IllegalStateException("Cannot to resume a query");
                EMFQueryPlugin.throwing(this.getClass(), "resume", ex);
                throw ex;
            }
            this.getProgressMonitor().beginTask(EXECUTING_QUERY, -1);
            this.doResume();
        }
        catch (Exception exception) {
            this.handleException(exception, "resume");
        }
        this.getProgressMonitor().done();
        return this.getResultSet();
    }

    public abstract boolean canBeResumed();

    protected abstract void doExecute();

    protected abstract void doResume();

    protected final IQueryResult getResultSet() {
        return this.resultSet;
    }

    @Override
    public Set<? extends EObject> getEObjects() {
        return this.execute().getEObjects();
    }

    protected void setResultSet(QueryResultSet set) {
        this.resultSet = set;
    }

    protected boolean isCancellable() {
        return this.cancellable;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

