/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ftask.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.TypePatternList;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.ftask.tasks.AbstractPatternTask;
import org.eclipse.egf.pattern.utils.SubstitutionHelper;
import org.eclipse.emf.ecore.EObject;

public class PatternTask
extends AbstractPatternTask {
    private final List<Pattern> patterns = new ArrayList<Pattern>();

    public void doExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        try {
            PatternContext ctx = this.createPatternContext(context);
            this.readContext(context, ctx);
            Node.Container currentNode = ((InternalPatternContext)ctx).getNode();
            TypePatternList patternList = (TypePatternList)context.getInputValue((Object)"pattern.id", TypePatternList.class);
            PatternCollector.INSTANCE.collect((EObject[])patternList.getElements().toArray((Object[])new PatternElement[patternList.getElements().size()]), this.patterns);
            TypePatternSubstitution substitutions = (TypePatternSubstitution)ctx.getValue("pattern.substitutions");
            SubstitutionHelper.apply(this.patterns, (TypePatternSubstitution)substitutions);
            for (Pattern pattern : this.patterns) {
                PatternExtension extension = ExtensionHelper.getExtension((PatternNature)pattern.getNature());
                String reason = extension.canExecute(pattern);
                if (reason == null) {
                    PatternEngine engine = extension.createEngine(pattern);
                    if (currentNode != null) {
                        Node.Container localNode = new Node.Container(currentNode, engine.getUnderlyingClassname());
                        ((InternalPatternContext)ctx).setNode(localNode);
                    }
                    engine.execute(ctx);
                    continue;
                }
                throw new InvocationException(reason);
            }
            this.writeContext(context, ctx);
            ((InternalPatternContext)ctx).setNode(currentNode);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new InvocationException((Throwable)e);
        }
        catch (PatternException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        super.postExecute(context, monitor);
        this.patterns.clear();
    }
}

