/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.commandline;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.MissingExtensionException;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.DefaultCommandLine;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.docgen.configuration.commandline.Messages;
import org.polarsys.capella.docgen.configuration.ui.utils.ConfigurationUtils;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeElementStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;

public class HTMLConfigurationCommandLine
extends DefaultCommandLine {
    private static final String FCORE_URI = "/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA";
    private static final URI CAPELLA_LAUNCHER_URI = URI.createURI((String)"platform:/plugin/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA");
    private String configurationFile;
    public static final String CONFIGURATION = "-configurationfile";

    public void printHelp() {
        System.out.println("*** Capella HTML with Configuration Command Line");
        super.printHelp();
        System.out.println("-configurationfile value : defines the workspace or absolute path to the configuration file");
    }

    public void checkArgs(IApplicationContext context_p) throws CommandLineException {
        super.checkArgs(context_p);
        String[] args = CommandLineArgumentHelper.parseContext((IApplicationContext)context_p);
        int i = 0;
        while (i < args.length) {
            String arg = args[i].toLowerCase();
            if (CONFIGURATION.equals(arg)) {
                this.configurationFile = args[++i];
            }
            ++i;
        }
        if (this.isEmtyOrNull(this.configurationFile)) {
            this.logErrorAndThrowException(Messages.configuration_mandatory);
        }
    }

    public boolean execute(IApplicationContext context_p) {
        HTMLConfigurationCommandLine.startFakeWorkbench();
        List airdFilesFromInput = this.getAirdFilesFromInput();
        boolean status = true;
        if (!airdFilesFromInput.isEmpty()) {
            URI uri = EcoreUtil2.getURI((IFile)((IFile)airdFilesFromInput.get(0)));
            if (uri.lastSegment().endsWith(".aird")) {
                DiagramSessionHelper.setAirdUri((URI)uri);
                Session session = DiagramSessionHelper.initSession();
                session.open((IProgressMonitor)new NullProgressMonitor());
                boolean init = this.initializeScope(session);
                if (!init) {
                    return true;
                }
                status = this.executeGeneration(session);
            } else {
                status = false;
                this.logError(Messages.filepath_point_to_aird);
            }
        }
        return status;
    }

    private boolean executeGeneration(Session session) {
        boolean status;
        Activity htmlGenerator = InvokeActivityHelper.getActivity((URI)CAPELLA_LAUNCHER_URI);
        Project rootSemanticElement = SessionHelper.getCapellaProject((Session)session);
        if (rootSemanticElement != null) {
            Resource semanticResource = rootSemanticElement.eResource();
            URI semanticResourceURI = semanticResource.getURI();
            try {
                String outputFolderString = this.getOrCreateOutputFolder().getFullPath().toString();
                status = this.executeEGFActivity(htmlGenerator, outputFolderString, semanticResourceURI);
                if (status) {
                    this.logInfo(String.valueOf(Messages.generation_done) + outputFolderString);
                }
            }
            catch (CommandLineException e) {
                status = false;
                this.logError(e.getMessage());
            }
        } else {
            status = false;
            this.logError(Messages.no_root_semantic_element);
        }
        return status;
    }

    private boolean initializeScope(Session session_p) {
        GenerationGlobalScope.getInstance().cleanScope();
        GenerationGlobalScope.getInstance().setReferencesStrategy(ScopeReferencesStrategy.DONT_EXPORT);
        ReflectionHelper.setFieldValueWithoutException((Object)GenerationGlobalScope.getInstance(), (String)"elementStrategy", (Object)ScopeElementStrategy.ELEMENT);
        List selectedModelElements = ConfigurationUtils.getInstance().getElementsFromConfigurationFile(this.configurationFile, session_p, (IProgressMonitor)new NullProgressMonitor());
        if (selectedModelElements.isEmpty() && ConfigurationUtils.getInstance().getMessage() != null && ConfigurationUtils.getInstance().getMessage() != "") {
            this.logError(ConfigurationUtils.getInstance().getMessage());
            return false;
        }
        for (EObject eObject : selectedModelElements) {
            try {
                GenerationGlobalScope.getInstance().addToScope(eObject);
            }
            catch (ScopeException e) {
                this.logError(e.getMessage());
            }
        }
        return true;
    }

    public void prepare(IApplicationContext context_p) throws CommandLineException {
        super.prepare(context_p);
    }

    public static void startFakeWorkbench() {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public boolean openWindows() {
                return false;
            }

            public String getInitialWindowPerspectiveId() {
                return null;
            }
        });
    }

    private boolean executeEGFActivity(Activity capellaLauncher, String outputFolder, URI uri) {
        boolean success = true;
        String prefix = Messages.exec_pb;
        Path path = new Path(outputFolder);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path.append("output"));
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                success = false;
            }
        }
        if (success && capellaLauncher instanceof FactoryComponent) {
            String relativeFilePath = HTMLConfigurationCommandLine.getRelativeFilePath((String)outputFolder);
            String projectName = HTMLConfigurationCommandLine.getProjectName((String)outputFolder);
            FactoryComponent factoryComponent = (FactoryComponent)capellaLauncher;
            this.setContract(factoryComponent, "projectName", projectName);
            this.setContract(factoryComponent, "outputFolder", String.valueOf(relativeFilePath) + "/output");
            this.setDomain(factoryComponent, uri);
            try {
                InvokeActivityHelper.invokeOutOfUIThread((Activity)factoryComponent);
                success = true;
            }
            catch (MissingExtensionException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                success = false;
            }
            catch (InvocationException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                success = false;
            }
            catch (CoreException e) {
                StringBuilder message = new StringBuilder(prefix).append(e.getMessage());
                this.logError(message.toString());
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    private void setDomain(FactoryComponent factoryComponent, URI uri) {
        DomainViewpoint domainViewpoint;
        Domain domain;
        Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
        if (viewpoint instanceof DomainViewpoint && (domain = (Domain)(domainViewpoint = (DomainViewpoint)viewpoint).getDomains().get(0)) instanceof EMFDomain) {
            EMFDomain domainURI = (EMFDomain)domain;
            domainURI.setUri(uri);
        }
    }

    private void setContract(FactoryComponent factoryComponent, String contractName, String value) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypeString) {
            TypeString typeString = (TypeString)type;
            typeString.setValue(value);
        }
    }
}

