/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ListBuilderDialog<E, S>
extends Dialog {
    protected final IBaseLabelProvider labelProvider;
    protected final IStructuredContentProvider contentProvider;
    protected String displayName;
    protected EList<E> result;
    protected boolean multiLine;
    private List<S> possibleValues;
    private final List<E> currentValues = new ArrayList();
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private TreeViewer initialTreeViewer;
    private TreeViewer currentTreeViewer;

    public ListBuilderDialog(Shell parent, IStructuredContentProvider contentProvider, IBaseLabelProvider labelProvider, List<S> possibleValues, List<E> initialValues) {
        super(parent);
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (possibleValues == null) {
            throw new IllegalArgumentException();
        }
        if (labelProvider == null) {
            throw new IllegalArgumentException();
        }
        if (contentProvider == null) {
            throw new IllegalArgumentException();
        }
        if (initialValues == null) {
            throw new IllegalArgumentException();
        }
        this.currentValues.addAll(initialValues);
        this.possibleValues = possibleValues;
    }

    protected void refreshButtons() {
        IStructuredSelection initialSelection = (IStructuredSelection)this.initialTreeViewer.getSelection();
        IStructuredSelection currentSelection = (IStructuredSelection)this.currentTreeViewer.getSelection();
        this.addButton.setEnabled(!initialSelection.isEmpty());
        this.removeButton.setEnabled(!currentSelection.isEmpty());
        if (currentSelection.isEmpty()) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            int min = this.currentValues.size();
            int max = 0;
            Object[] objectArray = currentSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                min = Math.min(min, this.currentValues.indexOf(value));
                max = Math.max(max, this.currentValues.indexOf(value));
                ++n2;
            }
            this.upButton.setEnabled(min > 0);
            this.downButton.setEnabled(max < this.currentValues.size() - 1);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Text patternText = null;
        Group filterGroupComposite = new Group(contents, 0);
        filterGroupComposite.setLayout((Layout)new GridLayout(2, false));
        filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        Label label = new Label((Composite)filterGroupComposite, 0);
        label.setText(Messages.ListBuilderDialog_searchPatternValue_label);
        patternText = new Text((Composite)filterGroupComposite, 2048);
        patternText.setLayoutData((Object)new GridData(768));
        Composite initialComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        initialComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        initialComposite.setLayout((Layout)layout);
        Label initialLabel = new Label(initialComposite, 0);
        initialLabel.setText(Messages.ListBuilderDialog_initialvalue_label);
        GridData initialLabelGridData = new GridData();
        initialLabelGridData.verticalAlignment = 4;
        initialLabelGridData.horizontalAlignment = 4;
        initialLabel.setLayoutData((Object)initialLabelGridData);
        Tree initialTree = new Tree(initialComposite, 2050);
        GridData initialTreeGridData = new GridData();
        initialTreeGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        initialTreeGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        initialTreeGridData.verticalAlignment = 4;
        initialTreeGridData.horizontalAlignment = 4;
        initialTreeGridData.grabExcessHorizontalSpace = true;
        initialTreeGridData.grabExcessVerticalSpace = true;
        initialTree.setLayoutData((Object)initialTreeGridData);
        this.initialTreeViewer = new TreeViewer(initialTree);
        this.initialTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.initialTreeViewer.setLabelProvider(this.labelProvider);
        final PatternFilter filter = new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
            }
        };
        this.initialTreeViewer.addFilter((ViewerFilter)filter);
        this.initialTreeViewer.setSorter(new ViewerSorter());
        patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(((Text)e.widget).getText());
                ListBuilderDialog.this.initialTreeViewer.refresh();
            }
        });
        this.initialTreeViewer.setInput(this.possibleValues);
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        this.addButton = new Button(controlButtons, 8);
        this.addButton.setToolTipText(Messages.SpecificationPage_button_add);
        this.addButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        GridData addButtonGridData = new GridData();
        addButtonGridData.widthHint = 65;
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.removeButton = new Button(controlButtons, 8);
        this.removeButton.setToolTipText(Messages.SpecificationPage_button_remove);
        this.removeButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.widthHint = 65;
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        this.upButton = new Button(controlButtons, 8);
        this.upButton.setToolTipText(Messages.SpecificationPage_button_up);
        this.upButton.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        GridData upButtonGridData = new GridData();
        upButtonGridData.widthHint = 65;
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(controlButtons, 8);
        this.downButton.setToolTipText(Messages.SpecificationPage_button_down);
        this.downButton.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        GridData downButtonGridData = new GridData();
        downButtonGridData.widthHint = 65;
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
        Composite currentComposite = new Composite(contents, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        currentComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        currentComposite.setLayout((Layout)layout2);
        Label currentLabel = new Label(currentComposite, 0);
        currentLabel.setText(Messages.ListBuilderDialog_currentValue_label);
        GridData currentLabelGridData = new GridData();
        currentLabelGridData.horizontalSpan = 2;
        currentLabelGridData.horizontalAlignment = 4;
        currentLabelGridData.verticalAlignment = 4;
        currentLabel.setLayoutData((Object)currentLabelGridData);
        Tree currentTree = new Tree(currentComposite, 2050);
        GridData currentTableGridData = new GridData();
        currentTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        currentTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        currentTableGridData.verticalAlignment = 4;
        currentTableGridData.horizontalAlignment = 4;
        currentTableGridData.grabExcessHorizontalSpace = true;
        currentTableGridData.grabExcessVerticalSpace = true;
        currentTree.setLayoutData((Object)currentTableGridData);
        this.currentTreeViewer = new TreeViewer(currentTree);
        this.currentTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.currentTreeViewer.setLabelProvider(this.labelProvider);
        this.currentTreeViewer.setInput(this.currentValues);
        if (!this.currentValues.isEmpty()) {
            this.currentTreeViewer.setSelection((ISelection)new StructuredSelection(this.currentValues.get(0)));
        }
        ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListBuilderDialog.this.refreshButtons();
            }
        };
        this.initialTreeViewer.addPostSelectionChangedListener(selectionListener);
        this.initialTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ListBuilderDialog.this.addButton.isEnabled()) {
                    ListBuilderDialog.this.addButton.notifyListeners(13, null);
                }
            }
        });
        this.currentTreeViewer.addPostSelectionChangedListener(selectionListener);
        this.currentTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ListBuilderDialog.this.removeButton.isEnabled()) {
                    ListBuilderDialog.this.removeButton.notifyListeners(13, null);
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ListBuilderDialog.this.currentTreeViewer.getSelection();
                for (Object value : selection) {
                    int index = ListBuilderDialog.this.currentValues.indexOf(value);
                    ListBuilderDialog.this.currentValues.remove(index);
                    ListBuilderDialog.this.currentValues.add(Math.max(index - 1, 0), value);
                }
                ListBuilderDialog.this.currentTreeViewer.refresh();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ListBuilderDialog.this.currentTreeViewer.getSelection();
                int maxIndex = ListBuilderDialog.this.currentValues.size() - 1;
                for (Object value : selection) {
                    int index = ListBuilderDialog.this.currentValues.indexOf(value);
                    ListBuilderDialog.this.currentValues.remove(index);
                    ListBuilderDialog.this.currentValues.add(Math.min(index + 1, maxIndex), value);
                }
                ListBuilderDialog.this.currentTreeViewer.refresh();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ListBuilderDialog.this.initialTreeViewer.getSelection();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    ListBuilderDialog.this.currentValues.add(i.next());
                }
                ListBuilderDialog.this.currentTreeViewer.setSelection((ISelection)selection);
                ListBuilderDialog.this.currentTreeViewer.refresh();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ListBuilderDialog.this.currentTreeViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    ListBuilderDialog.this.currentValues.remove(value);
                }
                if (!ListBuilderDialog.this.currentValues.isEmpty()) {
                    ListBuilderDialog.this.currentTreeViewer.setSelection((ISelection)new StructuredSelection(ListBuilderDialog.this.currentValues.get(0)));
                }
                ListBuilderDialog.this.initialTreeViewer.setSelection((ISelection)selection);
                ListBuilderDialog.this.currentTreeViewer.refresh();
            }
        });
        this.refreshButtons();
        return contents;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public boolean close() {
        this.contentProvider.dispose();
        return super.close();
    }

    public List<E> getResult() {
        return this.currentValues;
    }
}

