/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.xmlpivot.exporter.XMLPivotExport;

public class ExportHandler
extends AbstractHandler
implements IHandler {
    static final String PARAM_DYNAMIC_EXPORT = "org.polarsys.capella.xmlpivot.ui.dynamicExport";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final List selectedObjects = ((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).toList();
        final AtomicReference skippedElements = new AtomicReference();
        final boolean dynamic = "true".equals(event.getParameter(PARAM_DYNAMIC_EXPORT));
        final URI destination = this.getExportDestination(selectedObjects, dynamic, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (destination == null) {
            return null;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                XMLPivotExport export = new XMLPivotExport((Collection)selectedObjects, destination, event.getCommand().getId(), dynamic);
                try {
                    export.run(monitor_p);
                }
                catch (IOException exception_p) {
                    throw new InvocationTargetException(exception_p);
                }
                catch (CoreException exception_p) {
                    throw new InvocationTargetException(exception_p);
                }
                skippedElements.set(export.getSkippedElements());
            }
        };
        try {
            new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)).run(true, true, runnable);
        }
        catch (InvocationTargetException exception_p) {
            throw new ExecutionException(exception_p.getMessage(), exception_p.getCause());
        }
        catch (InterruptedException exception_p) {
            throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
        }
        this.logSkippedElements(event, (Collection)skippedElements.get());
        URIEditorInput editorInput = new URIEditorInput(destination);
        boolean alreadyOpen = false;
        try {
            IEditorReference[] iEditorReferenceArray = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                if (ref.getEditorInput().equals(editorInput)) {
                    alreadyOpen = true;
                    break;
                }
                ++n2;
            }
        }
        catch (PartInitException exception_p) {
            throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
        }
        if (!alreadyOpen && MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Export successful", (String)"Do you want to open the result in an editor?")) {
            try {
                String editorID = dynamic ? "org.polarsys.capella.xmlpivot.ui.editor.dynamic" : "org.polarsys.capella.xmlpivot.ui.editor";
                HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().openEditor((IEditorInput)editorInput, editorID);
            }
            catch (PartInitException exception_p) {
                throw new ExecutionException(exception_p.getMessage(), (Throwable)exception_p);
            }
        }
        return null;
    }

    protected void logSkippedElements(ExecutionEvent event, final Collection<? extends EObject> skipped) {
        if (skipped.size() > 0) {
            Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
            for (EObject eObject : skipped) {
                logger.info((Object)new EmbeddedMessage(String.valueOf(EObjectLabelProviderHelper.getText((EObject)eObject)) + " was not exported", "Default", (Object)eObject));
            }
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)skipped.iterator().next());
            AdapterFactory factory = CapellaAdapterFactoryProvider.getInstance().getAdapterFactory();
            DataLabelProvider labelProvider = new DataLabelProvider(domain, factory){

                protected Color getValidElementColor() {
                    return Display.getDefault().getSystemColor(3);
                }
            };
            final ArrayList<EObject> skippedNoTraces = new ArrayList<EObject>();
            for (EObject eObject : skipped) {
                if (eObject instanceof AbstractTrace || eObject.eContainer() instanceof TransfoLink) continue;
                skippedNoTraces.add(eObject);
            }
            SelectElementsDialog selectElementsDialog = new SelectElementsDialog(shell, labelProvider, "Skipped Elements Report", "Elements in Red are not part of the exported XML file because they do not belong to the Capella simplified Metamodel", skippedNoTraces, false, null, -1){

                protected void doCreateDialogArea(Composite parent_p) {
                    this.createTreeViewerPart(parent_p);
                    final Button check = new Button(parent_p, 32);
                    check.setText("Show abstract trace elements");
                    check.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (check.getSelection()) {
                                this.getViewer().setInput(skipped, null);
                            } else {
                                this.getViewer().setInput(skippedNoTraces, null);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    GridData data = new GridData(4, 1, true, false);
                    data.horizontalIndent = 5;
                    check.setLayoutData((Object)data);
                    this.configureInitialDisplay();
                }

                protected void configureShell(Shell newShell_p) {
                    super.configureShell(newShell_p);
                    newShell_p.setText("XML Pivot Export");
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 1, "OK", false);
                }
            };
            selectElementsDialog.open();
        }
    }

    private URI getExportDestination(Collection<? extends EObject> selectedObjects, boolean dynamic, Shell shell) {
        String result;
        String name;
        String fileName;
        String string = fileName = dynamic ? "export.xml" : "export_static.xml";
        if (selectedObjects.iterator().next() instanceof NamedElement && (name = ((NamedElement)selectedObjects.iterator().next()).getName()) != null && !name.isEmpty()) {
            fileName = String.valueOf(name) + (dynamic ? ".xml" : "_static.xml");
        }
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFileName(fileName);
        URI selectionURI = selectedObjects.iterator().next().eResource().getURI();
        if (selectionURI.isPlatformResource()) {
            String segment = URI.decode((String)selectionURI.segment(1));
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(segment);
            dialog.setFilterPath(project.getLocation().toOSString());
        }
        if ((result = dialog.open()) == null) {
            return null;
        }
        if (new File(result).exists() && !MessageDialog.openConfirm((Shell)shell, (String)"Overwrite existing file?", (String)"The destination file already exists and will be overwritten.")) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(result));
        if (file != null) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        }
        return URI.createFileURI((String)result);
    }
}

