/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.test;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.common.predicates.EMFPredicates;
import org.polarsys.capella.xmlpivot.exporter.AbstractIncrementalExporter;
import org.polarsys.capella.xmlpivot.exporter.DefaultIncrementor;
import org.polarsys.capella.xmlpivot.exporter.ExportEngine;
import org.polarsys.capella.xmlpivot.importer.ImportEngine;

public class XMLPivotTest
extends TestCase {
    protected Collection<EObject> exporter(Collection<? extends EObject> technicalModel) throws Exception {
        ExportEngine engine = new ExportEngine(XMLPivotActivator.getDefault().getDynamicConceptualMapping());
        DefaultIncrementor incrementor = new DefaultIncrementor(technicalModel);
        AbstractIncrementalExporter exporter = new AbstractIncrementalExporter(engine, (Function)incrementor);
        return exporter.export(technicalModel, null);
    }

    protected Collection<EObject> importer(Collection<? extends EObject> simplifiedModel) {
        ImportEngine engine = new ImportEngine(XMLPivotActivator.getDefault().getDynamicConceptualMapping());
        engine.copyAll(simplifiedModel);
        engine.copyReferences();
        engine.repair();
        return Collections2.filter((Collection)engine.values(), (Predicate)EMFPredicates.isRootContainer());
    }

    protected Collection<EObject> roundTrip(Collection<? extends EObject> technicalModel) throws Exception {
        return this.importer(this.exporter(technicalModel));
    }
}

