/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.PriorityHandler;
import org.eclipse.capra.core.listeners.ITraceCreationListener;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionPointHelper {
    private static final String TRACE_ID = "org.eclipse.capra.configuration.traceabilityInformationModel";
    private static final String TRACE_CONFIG = "class";
    private static final String PERSISTENCE_ID = "org.eclipse.capra.configuration.persistenceHandler";
    private static final String PERSISTENCE_CONFIG = "class";
    private static final String ARTIFACT_ID = "org.eclipse.capra.configuration.artifactMetaModel";
    private static final String ARTIFACT_CONFIG = "class";
    private static final String ARTIFACT_HANDLER_ID = "org.eclipse.capra.configuration.artifactHandlers";
    private static final String ARTIFACT_HANDLER_CONFIG = "class";
    private static final String PRIORITY_HANDLER_ID = "org.eclipse.capra.configuration.priorityHandlers";
    private static final String PRIORITY_HANDLER_CONFIG = "class";
    private static final String META_DATA_ID = "org.eclipse.capra.configuration.traceMetadata";
    private static final String META_DATA_CONFIG = "class";
    private static final String TRACE_CREATION_LISTENERS_ID = "org.eclipse.capra.configuration.traceCreationListeners";
    private static final String TRACE_CREATION_LISTENERS_CONFIG = "class";

    private ExtensionPointHelper() {
    }

    public static List<Object> getExtensions(String id, String attributeName) {
        try {
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(id);
            ArrayList<Object> extensions = new ArrayList<Object>();
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                extensions.add(config.createExecutableExtension(attributeName));
                ++n2;
            }
            return extensions;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static Optional<IArtifactHandler<?>> getExtension(String extensionId, String extensionPointId, String propertyName) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtension extension = registry.getExtension(extensionPointId, extensionId);
            IConfigurationElement[] elements = extension.getConfigurationElements();
            return Optional.of((IArtifactHandler)elements[0].createExecutableExtension(propertyName));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<ITraceabilityInformationModelAdapter> getTraceabilityInformationModelAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(TRACE_ID, "class").get(0);
            return Optional.of((ITraceabilityInformationModelAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<IPersistenceAdapter> getPersistenceAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(PERSISTENCE_ID, "class").get(0);
            return Optional.of((IPersistenceAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<IArtifactMetaModelAdapter> getArtifactMetaModelAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(ARTIFACT_ID, "class").get(0);
            return Optional.of((IArtifactMetaModelAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Collection<IArtifactHandler<?>> getArtifactHandlers() {
        List<Object> extensions = ExtensionPointHelper.getExtensions(ARTIFACT_HANDLER_ID, "class");
        List illegalClasses = extensions.stream().filter(c -> !(c instanceof IArtifactHandler)).collect(Collectors.toList());
        if (!illegalClasses.isEmpty()) {
            throw new IllegalStateException("Illegal classes at org.eclipse.capra.configuration.artifactHandlers: " + illegalClasses);
        }
        return extensions.stream().map(IArtifactHandler.class::cast).collect(Collectors.toList());
    }

    public static Optional<IArtifactHandler<?>> getArtifactHandler(String id) {
        return ExtensionPointHelper.getExtension(id, ARTIFACT_HANDLER_ID, "class");
    }

    public static Optional<PriorityHandler> getPriorityHandler() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(PRIORITY_HANDLER_ID, "class").get(0);
            return Optional.of((PriorityHandler)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<IMetadataAdapter> getTraceMetadataAdapter() {
        try {
            Object extension = ExtensionPointHelper.getExtensions(META_DATA_ID, "class").get(0);
            return Optional.of((IMetadataAdapter)extension);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Collection<ITraceCreationListener> getTraceCreationListeners() {
        List<Object> extensions = ExtensionPointHelper.getExtensions(TRACE_CREATION_LISTENERS_ID, "class");
        List illegalClasses = extensions.stream().filter(c -> !(c instanceof ITraceCreationListener)).collect(Collectors.toList());
        if (!illegalClasses.isEmpty()) {
            throw new IllegalStateException("Illegal classes at org.eclipse.capra.configuration.traceCreationListeners: " + illegalClasses);
        }
        return extensions.stream().map(ITraceCreationListener.class::cast).collect(Collectors.toList());
    }
}

