/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.asciidoc;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorContentOutlinePage;
import de.jcup.asciidoctoreditor.outline.Item;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.capra.ui.asciidoc.AsciiDocArtifact;
import org.eclipse.capra.ui.selections.ISelectionSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocSelectionSupport
implements ISelectionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AsciiDocSelectionSupport.class);

    public boolean supportsWorkbenchPart(IWorkbenchPart workbenchPart) {
        return workbenchPart instanceof AsciiDoctorEditor || workbenchPart instanceof ContentOutline;
    }

    public List<Object> extractSelectedElements(ISelection selection, IWorkbenchPart workbenchPart) {
        ContentOutline contentOutline;
        IPage currentPage;
        AsciiDoctorEditor editor = null;
        Item selectedElement = null;
        if (workbenchPart instanceof AsciiDoctorEditor) {
            editor = (AsciiDoctorEditor)workbenchPart;
        } else if (workbenchPart instanceof ContentOutline && (currentPage = (contentOutline = (ContentOutline)workbenchPart).getCurrentPage()) instanceof AsciiDoctorContentOutlinePage) {
            IContributedContentsView contributedView = (IContributedContentsView)contentOutline.getAdapter(IContributedContentsView.class);
            editor = (AsciiDoctorEditor)contributedView.getContributingPart();
        }
        if (editor == null) {
            return Collections.emptyList();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textselection = (ITextSelection)selection;
            selectedElement = editor.getItemAt(textselection.getOffset());
        } else if (selection instanceof TreeSelection) {
            selectedElement = (Item)((TreeSelection)selection).getFirstElement();
        }
        if (selectedElement == null) {
            return Collections.emptyList();
        }
        File editorFile = editor.getEditorFileOrNull();
        if (editorFile != null) {
            Path path = new Path(editorFile.getAbsolutePath());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation((IPath)path);
            try {
                URI uri = file != null ? new URIBuilder().setScheme("platform").setPath("/resource" + file.getFullPath()).setFragment(Integer.toString(selectedElement.getOffset())).build() : new URIBuilder().setScheme("file").setPath(editorFile.getAbsolutePath()).setFragment(Integer.toString(selectedElement.getOffset())).build();
                AsciiDocArtifact artifact = new AsciiDocArtifact(uri.toString(), selectedElement);
                return Collections.singletonList(artifact);
            }
            catch (URISyntaxException e) {
                LOG.error("Could not build URI for ", (Object)editorFile.getPath());
            }
        }
        return Collections.emptyList();
    }

    public ResourceSet getResourceSet(IWorkbenchPart workbenchPart) {
        return null;
    }
}

