/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.common.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Set;

public enum MessageDigestAlgorithm {
    DEFAULT("JVM-Default-Message-Digest-Algorithm", new String[0]),
    MD2("MD2", new String[0]),
    MD5("MD5", new String[0]),
    SHA_1("SHA-1", new String[0]),
    SHA1("SHA1", new String[0]),
    SHA_224("SHA-224", new String[0]),
    SHA_256("SHA-256", new String[0]),
    SHA_384("SHA-384", new String[0]),
    SHA_512("SHA-512", new String[0]);

    private final String standardName;
    private final Set<String> aliases;

    private MessageDigestAlgorithm(String standardName, String ... alias) {
        this.standardName = standardName;
        this.aliases = ImmutableSet.copyOf(alias);
    }

    public String standardName() {
        return this.standardName;
    }

    public static MessageDigestAlgorithm fromStandardName(String digestAlgorithmName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(digestAlgorithmName));
        Optional<MessageDigestAlgorithm> ret = Iterables.tryFind(EnumSet.allOf(MessageDigestAlgorithm.class), d -> digestAlgorithmName.equals(d.standardName) || d.aliases.contains(digestAlgorithmName));
        if (!ret.isPresent()) {
            throw new IllegalArgumentException("Unknow digest algorithm '" + digestAlgorithmName + "'");
        }
        return ret.get();
    }
}

