/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.quickfix;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TargetPlatformQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="DEPRECATE__STRINGS_ON_IU_VERSION")
    public void removeQuotes(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            Integer _offset = issue.getOffset();
            Integer _length = issue.getLength();
            int _plus = _offset + _length;
            int _minus = _plus - 1;
            xtextDocument.replace(_minus, 1, "");
            xtextDocument.replace(issue.getOffset().intValue(), 1, "");
        };
        acceptor.accept(issue, "Remove quotes.", "Remove quotes.", null, _function);
    }

    @Fix(value="CHECK__OPTIONS_EQUALS_ALL_LOCATIONS")
    public void equalizeOptions(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            Location location = (Location)element;
            Consumer<Location> _function_1 = l -> {
                Location elemLoc = (Location)element;
                EList locOptions = elemLoc.getOptions();
                if (!Objects.equal((Object)l, (Object)element) && !Sets.symmetricDifference((Set)IterableExtensions.toSet((Iterable)locOptions), (Set)IterableExtensions.toSet((Iterable)l.getOptions())).isEmpty()) {
                    l.getOptions().clear();
                    l.getOptions().addAll((Collection)locOptions);
                }
            };
            location.getTargetPlatform().getLocations().forEach(_function_1);
        };
        acceptor.accept(issue, "Set all options equals to this one.", "Set all options equals to this one.", null, _function);
    }

    @Fix(value="CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED")
    public void removeRemoveRequirements(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            if (element instanceof TargetPlatform) {
                ((TargetPlatform)element).getOptions().remove((Object)Option.INCLUDE_REQUIRED);
            } else if (element instanceof Location) {
                ((Location)element).getOptions().remove((Object)Option.INCLUDE_REQUIRED);
            }
        };
        acceptor.accept(issue, "Remove 'with requirements' option.", "Remove 'with requirements' option.", null, _function);
    }

    @Fix(value="CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED")
    public void removeRemoveAllEnvironment(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            if (element instanceof TargetPlatform) {
                ((TargetPlatform)element).getOptions().remove((Object)Option.INCLUDE_ALL_ENVIRONMENTS);
            } else if (element instanceof Location) {
                ((Location)element).getOptions().remove((Object)Option.INCLUDE_ALL_ENVIRONMENTS);
            }
        };
        acceptor.accept(issue, "Remove 'with allEnvironments' option.", "Remove 'with allEnvironments' option.", null, _function);
    }

    @Fix(value="DEPRECATE__OPTIONS_ON_LOCATIONS")
    public void moveOptionsToTargetLevel(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            Location location = (Location)element;
            location.getTargetPlatform().getOptions().clear();
            Consumer<Option> _function_1 = it -> location.getTargetPlatform().getOptions().add(it);
            ((Location)element).getOptions().forEach(_function_1);
            Consumer<Location> _function_2 = it -> it.getOptions().clear();
            location.getTargetPlatform().getLocations().forEach(_function_2);
            context.getXtextDocument();
        };
        acceptor.accept(issue, "Move options to the target level and remove all location specific options.", "Move options to the target level and remove all location specific options.", null, _function);
    }

    @Fix(value="CHECK__NO_OPTIONS_ON_LOCATIONS_IF_GLOBAL_OPTIONS")
    public void removeAllLocationSpecificOptions(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            Location location = (Location)element;
            Consumer<Location> _function_1 = it -> it.getOptions().clear();
            location.getTargetPlatform().getLocations().forEach(_function_1);
        };
        acceptor.accept(issue, "Remove all location specific options.", "Remove all location specific options.", null, _function);
    }

    @Fix(value="CHECK__LOCATION_CONFLICTUAL_ID")
    public void setOtherLocationWithSameURIToTheSameID(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            String id = ((Location)element).getID();
            String uri = ((Location)element).getUri();
            if (uri != null) {
                Location location = (Location)element;
                Functions.Function1 _function_1 = it -> uri != null && uri.equals(it.getUri());
                Consumer<Location> _function_2 = it -> it.setID(id);
                IterableExtensions.filter((Iterable)location.getTargetPlatform().getLocations(), (Functions.Function1)_function_1).forEach(_function_2);
            }
        };
        acceptor.accept(issue, "Set other locations with the same URI to the same ID.", "Set other locations with the same URI to the same ID.", null, _function);
    }

    @Fix(value="CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID")
    public void setIDSameValueAsIncludedLocation(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            String id = issue.getData()[0];
            String uri = issue.getData()[1];
            Location location = (Location)element;
            Functions.Function1 _function_1 = it -> uri != null && uri.equals(it.getUri());
            Consumer<Location> _function_2 = it -> it.setID(id);
            IterableExtensions.filter((Iterable)location.getTargetPlatform().getLocations(), (Functions.Function1)_function_1).forEach(_function_2);
        };
        acceptor.accept(issue, "Set the IDs of all locations with the same URI to the same value as included location.", "Set the IDs of all locations with the same URI to the same value as included location.", null, _function);
    }

    @Fix(value="CHECK__VERSION_KEYWORDS")
    public void removeVersionKeywords(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
        };
        acceptor.accept(issue, "Remove deprecated keywords.", "Remove deprecated keywords.", null, _function);
    }

    @Fix(value=" CHECK__ESCAPE_CHAR_IU_ID")
    public void removeEscapeCharInIUID(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            String fullId = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
            String replaceID = fullId.replaceAll("\\^", "");
            xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replaceID);
        };
        acceptor.accept(issue, "Remove deprecated escape character.", "Remove deprecated escape character.", null, _function);
    }
}

