/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.client.CFCloudCredentials;
import org.eclipse.core.runtime.CoreException;

public class V1CloudCredentials
implements CFCloudCredentials {
    private final CloudCredentials v1Credentials;

    public V1CloudCredentials(CloudCredentials v1Credentials) {
        this.v1Credentials = v1Credentials;
    }

    @Override
    public String getUser() {
        return this.v1Credentials.getEmail();
    }

    @Override
    public String getPassword() {
        return this.v1Credentials.getPassword();
    }

    @Override
    public String getAuthTokenAsJson() throws CoreException {
        try {
            return CloudUtil.getTokenAsJson(this.v1Credentials.getToken());
        }
        catch (JsonProcessingException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
    }

    @Override
    public String getClientId() {
        return this.v1Credentials.getClientId();
    }

    @Override
    public String getClientSecret() {
        return this.v1Credentials.getClientSecret();
    }

    @Override
    public String getProxyUser() {
        return this.v1Credentials.getProxyUser();
    }

    @Override
    public boolean isProxyUserSet() {
        return this.v1Credentials.isProxyUserSet();
    }

    @Override
    public boolean isRefreshable() {
        return this.v1Credentials.isRefreshable();
    }

    @Override
    public String getPasscode() {
        return this.v1Credentials.getPasscode();
    }

    @Override
    public boolean isPasscodeSet() {
        return this.v1Credentials.isPasscodeSet();
    }
}

