/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.util.List;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.console.ApplicationLogConsoleStream;
import org.eclipse.cft.server.ui.internal.console.CloudFoundryConsole;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.StandardLogContentType;
import org.eclipse.core.runtime.CoreException;

class ApplicationLogConsole
extends CloudFoundryConsole {
    public ApplicationLogConsole(ConsoleConfig config) {
        super(config);
    }

    public synchronized void writeApplicationLogs(List<ApplicationLog> logs) {
        if (logs != null) {
            for (ApplicationLog log : logs) {
                this.writeApplicationLog(log);
            }
        }
    }

    protected synchronized void writeApplicationLog(ApplicationLog log) {
        if (log == null) {
            return;
        }
        try {
            ConsoleStream stream = this.getStream(StandardLogContentType.APPLICATION_LOG);
            if (stream instanceof ApplicationLogConsoleStream) {
                ((ApplicationLogConsoleStream)stream).write(log);
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
    }
}

