/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.List;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.ManageCloudDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CloudUrlWidget {
    private Combo urlCombo;
    private final String serverTypeId;
    private final CloudFoundryServer cfServer;
    private int comboIndex;

    public CloudUrlWidget(CloudFoundryServer cfServer) {
        this.cfServer = cfServer;
        this.serverTypeId = cfServer.getServer().getServerType().getId();
    }

    public void createControls(Composite parent) throws CoreException {
        this.createControls(parent, null);
    }

    public String getURLSelection() {
        if (this.urlCombo != null) {
            int index = this.urlCombo.getSelectionIndex();
            return index < 0 ? null : this.urlCombo.getItem(index);
        }
        return null;
    }

    protected String getComboURLDisplay(AbstractCloudFoundryUrl url) {
        return String.valueOf(url.getName()) + " - " + url.getUrl();
    }

    protected void updateUrlCombo(AbstractCloudFoundryUrl lastAddedEditedUrl, IRunnableContext runnableContext) throws CoreException {
        String newSelection = null;
        String oldSelection = null;
        if (this.urlCombo.getSelectionIndex() >= 0) {
            oldSelection = this.urlCombo.getItem(this.urlCombo.getSelectionIndex());
        } else if (this.cfServer != null && this.cfServer.getUrl() != null) {
            oldSelection = this.cfServer.getUrl();
        }
        List<AbstractCloudFoundryUrl> cloudUrls = CloudServerUIUtil.getAllUrls(this.serverTypeId, runnableContext);
        String[] updatedUrls = new String[cloudUrls.size()];
        if (lastAddedEditedUrl != null) {
            newSelection = this.getComboURLDisplay(lastAddedEditedUrl);
        }
        int selectionIndex = -1;
        int i = 0;
        while (i < cloudUrls.size()) {
            updatedUrls[i] = this.getComboURLDisplay(cloudUrls.get(i));
            if (newSelection != null && updatedUrls[i].equals(newSelection)) {
                selectionIndex = i;
            }
            ++i;
        }
        if ((newSelection == null || selectionIndex < 0) && oldSelection != null) {
            i = 0;
            while (i < updatedUrls.length) {
                if (updatedUrls[i].contains(oldSelection)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (selectionIndex < 0 && cloudUrls.size() > 0) {
            selectionIndex = 0;
        }
        this.urlCombo.setItems(updatedUrls);
        if (selectionIndex < 0) {
            this.urlCombo.deselectAll();
        } else {
            this.urlCombo.select(selectionIndex);
        }
        this.comboIndex = selectionIndex;
    }

    protected void updateUrlCombo(AbstractCloudFoundryUrl lastAddedEditedUrl) throws CoreException {
        this.updateUrlCombo(lastAddedEditedUrl, null);
    }

    protected void setUpdatedSelectionInServer() {
        String url = this.getURLSelection();
        if (url != null) {
            url = CloudUiUtil.getUrlFromDisplayText(url);
            this.cfServer.setUrl(url);
        }
    }

    public void createControls(final Composite parent, final IRunnableContext runnableContext) throws CoreException {
        Label urlLabel = new Label(parent, 0);
        urlLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        urlLabel.setText(Messages.COMMONTXT_URL);
        Composite urlComposite = new Composite(parent, 0);
        urlComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout urlCompositelayout = new GridLayout(2, false);
        urlCompositelayout.marginHeight = 0;
        urlCompositelayout.marginWidth = 0;
        urlComposite.setLayout((Layout)urlCompositelayout);
        this.urlCombo = new Combo(urlComposite, 2056);
        this.urlCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.updateUrlCombo(null, runnableContext);
        this.urlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block6: {
                    int index = CloudUrlWidget.this.urlCombo.getSelectionIndex();
                    if (index >= 0 && index != CloudUrlWidget.this.comboIndex) {
                        try {
                            List<AbstractCloudFoundryUrl> allUrls = CloudServerUIUtil.getAllUrls(CloudUrlWidget.this.serverTypeId, runnableContext);
                            AbstractCloudFoundryUrl cloudUrl = allUrls.get(index);
                            if (!cloudUrl.getUrl().contains("{")) break block6;
                            AbstractCloudFoundryUrl newUrl = CloudServerUIUtil.getWildcardUrl(cloudUrl, allUrls, parent.getShell());
                            if (newUrl != null) {
                                List<AbstractCloudFoundryUrl> userDefinedUrls = CloudServerUIUtil.getUserDefinedUrls(CloudUrlWidget.this.serverTypeId);
                                userDefinedUrls.add(newUrl);
                                CloudServerUIUtil.storeUserDefinedUrls(CloudUrlWidget.this.serverTypeId, userDefinedUrls);
                                String newUrlName = newUrl.getName();
                                CloudUrlWidget.this.updateUrlCombo(null, runnableContext);
                                int i = 0;
                                while (i < CloudUrlWidget.this.urlCombo.getItemCount()) {
                                    if (CloudUrlWidget.this.urlCombo.getItem(i).startsWith(String.valueOf(newUrlName) + " - ")) {
                                        CloudUrlWidget.this.urlCombo.select(i);
                                        CloudUrlWidget.this.comboIndex = i;
                                        break block6;
                                    }
                                    ++i;
                                }
                                break block6;
                            }
                            CloudUrlWidget.this.urlCombo.select(CloudUrlWidget.this.comboIndex);
                        }
                        catch (CoreException ex) {
                            CloudFoundryServerUiPlugin.logError(ex);
                        }
                    }
                }
                CloudUrlWidget.this.setUpdatedSelectionInServer();
            }
        });
        final Button manageUrlButton = new Button(urlComposite, 8);
        manageUrlButton.setText(Messages.CloudUrlWidget_TEXT_MANAGE_CLOUD);
        manageUrlButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        manageUrlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageCloudDialog dialog = new ManageCloudDialog(manageUrlButton.getShell(), CloudUrlWidget.this.serverTypeId, runnableContext);
                if (dialog.open() == 0) {
                    AbstractCloudFoundryUrl lastAddedEditedURL = dialog.getLastAddedOrEditedCloudFoundryUrl();
                    try {
                        CloudUrlWidget.this.updateUrlCombo(lastAddedEditedURL, runnableContext);
                    }
                    catch (CoreException ex) {
                        CloudFoundryServerUiPlugin.logError(ex);
                    }
                    CloudUrlWidget.this.setUpdatedSelectionInServer();
                }
            }
        });
    }
}

