/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.startcommand;

import java.util.ArrayList;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.JavaStartCommandPart;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.JavaTypeResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class JavaTypeUIAdapter {
    private final IJavaProject javaProject;
    private final String title;
    private JavaTypeCompletionProcessor processor;
    private final JavaStartCommandPart javaStartCommandPart;

    public JavaTypeUIAdapter(JavaStartCommandPart javaStartCommandPart, IJavaProject javaProject, String title) {
        this.javaProject = javaProject;
        this.title = title;
        this.javaStartCommandPart = javaStartCommandPart;
    }

    public JavaTypeUIAdapter(JavaStartCommandPart javaStartCommandPart, IJavaProject javaProject) {
        this(javaStartCommandPart, javaProject, "Browse Type with main method");
    }

    public void apply() {
        Button browseButton = this.javaStartCommandPart.getBrowseButton();
        if (browseButton != null) {
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JavaTypeUIAdapter.this.handleTypeBrowsing();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    JavaTypeUIAdapter.this.handleTypeBrowsing();
                }
            });
        }
        this.applyContentAssist();
    }

    protected void applyContentAssist() {
        Text text = this.javaStartCommandPart.getTypeText();
        if (text == null) {
            return;
        }
        this.processor = this.createContentAssistProcessor();
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.processor);
        final JavaTypeResolver helper = new JavaTypeResolver(this.javaProject, null);
        final IPackageFragment defaultPackageFragment = this.getDefaultPackageFragment(this.javaProject);
        if (defaultPackageFragment != null) {
            this.processor.setCompletionContextRequestor(new CompletionContextRequestor(){

                public StubTypeContext getStubTypeContext() {
                    return TypeContextChecker.createSuperClassStubTypeContext((String)"$$__$$", null, (IPackageFragment)defaultPackageFragment);
                }
            });
        }
        UIJob job = new UIJob(Messages.JavaTypeUIAdapter_JOB_JAVA_ASSIST){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IType type = helper.getMainTypesFromSource(monitor);
                String qualifiedTypeName = type != null ? type.getFullyQualifiedName() : null;
                Text text = JavaTypeUIAdapter.this.javaStartCommandPart.getTypeText();
                if (qualifiedTypeName != null && text != null) {
                    text.setText(qualifiedTypeName);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    protected Shell getShell() {
        Text control = this.javaStartCommandPart.getTypeText();
        Shell shell = control != null ? control.getShell() : (this.javaStartCommandPart.getBrowseButton() != null ? this.javaStartCommandPart.getBrowseButton().getShell() : null);
        return shell;
    }

    public void handleTypeBrowsing() {
        String qualifiedName;
        IType type;
        Text textControl = this.javaStartCommandPart.getTypeText();
        if (textControl == null) {
            return;
        }
        String pattern = textControl.getText();
        Shell shell = this.getShell();
        int javaSearchType = 5;
        IJavaElement[] elements = new IJavaElement[]{this.javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(shell, false, null, scope, javaSearchType);
        dialog.setTitle(this.title);
        dialog.setInitialPattern(pattern);
        if (dialog.open() == 0 && (type = (IType)dialog.getFirstResult()) != null && (qualifiedName = type.getFullyQualifiedName()) != null) {
            textControl.setText(qualifiedName);
        }
        this.javaStartCommandPart.updateStartCommand();
    }

    protected JavaTypeCompletionProcessor createContentAssistProcessor() {
        return new JavaTypeCompletionProcessor(false, false, true);
    }

    public IPackageFragment getDefaultPackageFragment(IJavaProject javaProject) {
        if (javaProject == null) {
            return null;
        }
        ArrayList<IPackageFragmentRoot> packFragRoots = new ArrayList<IPackageFragmentRoot>();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot[] roots;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (roots = javaProject.findPackageFragmentRoots(entry)) != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot rt = iPackageFragmentRootArray[n4];
                        if (!packFragRoots.contains(rt)) {
                            packFragRoots.add(rt);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            CloudFoundryPlugin.log((CoreException)e);
        }
        IPackageFragment fragment = null;
        for (IPackageFragmentRoot root : packFragRoots) {
            try {
                IJavaElement[] members = root.getChildren();
                if (members != null) {
                    IJavaElement[] iJavaElementArray = members;
                    int n = members.length;
                    int n5 = 0;
                    while (n5 < n) {
                        IPackageFragment frag;
                        IJavaElement element = iJavaElementArray[n5];
                        if (element instanceof IPackageFragment && (frag = (IPackageFragment)element).isDefaultPackage()) {
                            fragment = frag;
                            break;
                        }
                        ++n5;
                    }
                }
                if (fragment == null) continue;
                break;
            }
            catch (JavaModelException e) {
                CloudFoundryPlugin.log((CoreException)e);
            }
        }
        return fragment;
    }
}

