/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.ui.internal.CloudFoundryBrandingUIExtensionPoint;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CloudFoundryImages {
    private static final URL baseURL = CloudFoundryServerUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static final String OBJ = "obj16/";
    public static final ImageDescriptor EDIT = CloudFoundryImages.create("obj16/", "edit.gif");
    public static final ImageDescriptor TUNNEL_EXTERNAL_TOOLS = CloudFoundryImages.create("obj16/", "external_tools.gif");
    public static final ImageDescriptor JDBC_DATA_TOOLS = CloudFoundryImages.create("obj16/", "jdbc_16.gif");
    public static final ImageDescriptor DISCONNECT = CloudFoundryImages.create("obj16/", "disconnect.png");
    public static final ImageDescriptor CONNECT = CloudFoundryImages.create("obj16/", "connect.png");
    public static final ImageDescriptor CLOSE_CONSOLE = CloudFoundryImages.create("obj16/", "close_console.gif");
    public static final ImageDescriptor NEW_SERVICE = CloudFoundryImages.create("obj16/", "service_new.png");
    public static final ImageDescriptor OBJ_APPLICATION = CloudFoundryImages.create("obj16/", "application.png");
    public static final ImageDescriptor OBJ_MULTI = CloudFoundryImages.create("obj16/", "multi.png");
    public static final ImageDescriptor OBJ_PUBLISH = CloudFoundryImages.create("obj16/", "publish.png");
    public static final ImageDescriptor OBJ_SERVICE = CloudFoundryImages.create("obj16/", "service.png");
    public static final ImageDescriptor OBJ_SINGLE = CloudFoundryImages.create("obj16/", "single.png");
    public static final ImageDescriptor OBJ_SPRINGSOURCE = CloudFoundryImages.create("obj16/", "springsource_obj.png");
    public static final ImageDescriptor OVERLAY_REFRESH = CloudFoundryImages.create("obj16/", "refresh_overlay.png");
    public static final ImageDescriptor REFRESH = CloudFoundryImages.create("obj16/", "refresh.gif");
    public static final ImageDescriptor REMOVE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    public static final ImageDescriptor OVERLAY_ERROR = CloudFoundryImages.create("obj16/", "error_overlay.png");
    public static final ImageDescriptor OVERLAY_WARNING = CloudFoundryImages.create("obj16/", "warning_overlay.gif");
    public static final ImageDescriptor RESTART_DEBUG_MODE = CloudFoundryImages.create("obj16/", "restart_debug.png");
    public static final ImageDescriptor RESTART = CloudFoundryImages.create("obj16/", "restart.png");
    public static final ImageDescriptor PUSH = CloudFoundryImages.create("obj16/", "push.gif");
    public static final ImageDescriptor MENU_VIEW_ENABLED = CloudFoundryImages.create("obj16/", "view_menu_elcl.gif");
    public static final ImageDescriptor MENU_VIEW_DISABLED = CloudFoundryImages.create("obj16/", "view_menu_dlcl.gif");
    public static final ImageDescriptor DEBUG = CloudFoundryImages.create("obj16/", "debug_exc.gif");
    public static final ImageDescriptor DEFAULT_WIZARD_BANNER = CloudFoundryImages.create("obj16/", "default_wizard_banner.png");
    private static ImageRegistry imageRegistry;

    public static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CloudFoundryImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = CloudFoundryImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    public static ImageDescriptor getWizardBanner(String serverTypeId) {
        IConfigurationElement config = CloudFoundryBrandingExtensionPoint.getConfigurationElement((String)serverTypeId);
        String wizBanner = CloudFoundryBrandingUIExtensionPoint.getWizardBannerPath(serverTypeId);
        if (config != null && wizBanner != null && wizBanner.trim().length() > 0) {
            String bundle = config.getContributor().getName();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle, (String)wizBanner);
        }
        return null;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("full");
        buffer.append('/');
        buffer.append(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

