/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.log;

import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.RestLogCallback;
import org.cloudfoundry.client.lib.RestLogEntry;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.log.CloudTracer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class HttpTracer {
    private static HttpTracer currentTracer;
    public static final String PREFERENCE_TRACE = "org.eclipse.cft.server.core.http.tracing";
    private RestLogCallback activeListener = null;
    private static boolean isEnabled;

    public static synchronized HttpTracer getCurrent() {
        if (currentTracer == null) {
            currentTracer = new HttpTracer();
            isEnabled = currentTracer.loadTracePreference();
        }
        return currentTracer;
    }

    public synchronized void trace(CloudFoundryOperations client) {
        if (client == null) {
            return;
        }
        if (this.activeListener != null) {
            client.unRegisterRestLogListener(this.activeListener);
        }
        if (this.isEnabled()) {
            if (this.activeListener == null) {
                this.activeListener = new PrintingApplicationLogListener();
            }
            client.registerRestLogListener(this.activeListener);
        }
    }

    public synchronized void enableTracing(boolean enable) {
        isEnabled = enable;
        IEclipsePreferences prefs = CloudFoundryPlugin.getDefault().getPreferences();
        prefs.putBoolean(PREFERENCE_TRACE, isEnabled);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        if (isEnabled) {
            CloudFoundryPlugin.getCallback().showTraceView(isEnabled);
        }
    }

    public synchronized boolean isEnabled() {
        return isEnabled;
    }

    public synchronized boolean loadTracePreference() {
        isEnabled = CloudFoundryPlugin.getDefault().getPreferences().getBoolean(PREFERENCE_TRACE, false);
        if (isEnabled) {
            CloudFoundryPlugin.getCallback().showTraceView(isEnabled);
        }
        return isEnabled;
    }

    public static class PrintingApplicationLogListener
    implements RestLogCallback {
        public void onNewLogEntry(RestLogEntry restLogEntry) {
            CloudTracer.getCurrentCloudTracer().traceNewLogEntry(restLogEntry);
        }
    }
}

