/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.application;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cft.server.core.internal.CFConsoleHandler;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.standalone.core.internal.application.DeploymentErrorHandler;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.application.JavaPackageFragmentRootHandler;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.Repackager;

class JarArchivingUIHandler {
    private CloudFoundryApplicationModule appModule;
    private CloudFoundryServer cloudServer;
    private CFConsoleHandler consoleHandler;
    private DeploymentErrorHandler errorHandler;

    public JarArchivingUIHandler(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer, CFConsoleHandler consoleHandler, DeploymentErrorHandler errorHandler) {
        this.appModule = appModule;
        this.cloudServer = cloudServer;
        this.consoleHandler = consoleHandler;
        this.errorHandler = errorHandler;
    }

    protected String getTempJarPath(IModule module) throws CoreException {
        try {
            File tempFolder = File.createTempFile("tempFolderForJavaAppJar", null);
            tempFolder.delete();
            tempFolder.mkdirs();
            if (!tempFolder.exists()) {
                throw CloudErrorUtil.toCoreException((String)NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_CREATE_TEMP_DIR, (Object)tempFolder.getPath()));
            }
            File targetFile = new File(tempFolder, String.valueOf(module.getName()) + ".jar");
            targetFile.deleteOnExit();
            String path = new Path(targetFile.getAbsolutePath()).toString();
            return path;
        }
        catch (IOException io) {
            CloudErrorUtil.toCoreException((Throwable)io);
            return null;
        }
    }

    protected IJarBuilder getDefaultLibJarBuilder() {
        return new FatJarRsrcUrlBuilder(){

            public void writeRsrcUrlClasses() throws IOException {
            }
        };
    }

    protected JavaPackageFragmentRootHandler getPackageFragmentRootHandler(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        return new JavaPackageFragmentRootHandler(javaProject, this.cloudServer);
    }

    protected void bootRepackage(final IPackageFragmentRoot[] roots, File packagedFile) throws CoreException {
        Repackager bootRepackager = new Repackager(packagedFile);
        try {
            bootRepackager.repackage(new Libraries(){

                public void doWithLibraries(LibraryCallback callBack) throws IOException {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File rootFile;
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.isArchive() && (rootFile = new File(root.getPath().toOSString())).exists()) {
                            callBack.library(new Library(rootFile, LibraryScope.COMPILE));
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (IOException e) {
            this.errorHandler.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_REPACKAGE_SPRING, (Object)e.getMessage()));
        }
    }

    protected JarPackageData getJarPackageData(IPackageFragmentRoot[] roots, IType mainType, IProgressMonitor monitor) throws CoreException {
        String filePath = this.getTempJarPath(this.appModule.getLocalModule());
        if (filePath == null) {
            this.errorHandler.handleApplicationDeploymentFailure("Failed to create temporary JAR file");
        }
        Path location = new Path(filePath);
        JarPackageData packageData = new JarPackageData();
        packageData.setJarLocation((IPath)location);
        packageData.setGenerateManifest(false);
        packageData.setSaveManifest(false);
        packageData.setManifestMainClass(mainType);
        packageData.setElements((Object[])roots);
        return packageData;
    }

    protected File packageApplication(final JarPackageData packageData, IProgressMonitor monitor) throws CoreException {
        int progressWork = 10;
        final SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)progressWork);
        final File[] createdFile = new File[1];
        final CoreException[] error = new CoreException[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Shell shell = CFUiUtil.getShell();
                    IJarExportRunnable runnable = packageData.createJarExportRunnable(shell);
                    try {
                        try {
                            runnable.run((IProgressMonitor)subProgress);
                            File file = new File(packageData.getJarLocation().toString());
                            if (!file.exists()) {
                                JarArchivingUIHandler.this.errorHandler.handleApplicationDeploymentFailure();
                            } else {
                                createdFile[0] = file;
                            }
                        }
                        catch (InvocationTargetException e) {
                            throw CloudErrorUtil.toCoreException((Throwable)e);
                        }
                        catch (InterruptedException ie) {
                            throw CloudErrorUtil.toCoreException((Throwable)ie);
                        }
                    }
                    finally {
                        subProgress.done();
                    }
                }
                catch (CoreException e) {
                    error[0] = e;
                }
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
        return createdFile[0];
    }
}

