/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.ApplicationInstanceRunningTracker;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CachingApplicationArchive;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryLoginHandler;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ModuleResourceDeltaWrapper;
import org.eclipse.cft.server.core.internal.RefreshModulesHandler;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.ClientRequest;
import org.eclipse.cft.server.core.internal.client.ClientRequestFactory;
import org.eclipse.cft.server.core.internal.client.CloudBehaviourOperations;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.core.internal.client.FileRequest;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.jrebel.CloudRebelAppHandler;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.core.internal.spaces.CloudOrgsAndSpaces;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.springframework.web.client.RestClientException;

public class CloudFoundryServerBehaviour
extends ServerBehaviourDelegate {
    private CloudFoundryOperations client;
    private RefreshModulesHandler refreshHandler;
    private ApplicationUrlLookupService applicationUrlLookup;
    private CloudBehaviourOperations cloudBehaviourOperations;
    private ClientRequestFactory requestFactory;
    private IServerListener serverListener = new IServerListener(){

        public void serverChanged(ServerEvent event) {
            if (event.getKind() == 16) {
                CloudFoundryServerBehaviour.this.internalResetClient();
            }
        }
    };

    ClientRequestFactory getRequestFactory() throws CoreException {
        if (this.requestFactory == null) {
            this.requestFactory = this.getCloudFoundryServer().getTarget().getRequestFactory(this);
        }
        return this.requestFactory;
    }

    public boolean canControlModule(IModule[] module) {
        return module.length == 1;
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        this.getRequestFactory().connect().run(monitor);
        Server server = (Server)cloudServer.getServerOriginal();
        server.setServerState(2);
        server.setServerPublishState(1);
        this.getApplicationUrlLookup().refreshDomains(monitor);
        this.getRefreshHandler().scheduleRefreshAll();
        ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 403));
    }

    public CloudBehaviourOperations operations() {
        if (this.cloudBehaviourOperations == null) {
            this.cloudBehaviourOperations = new CloudBehaviourOperations(this);
        }
        return this.cloudBehaviourOperations;
    }

    public RefreshModulesHandler getRefreshHandler() {
        if (this.refreshHandler == null) {
            CloudFoundryServer server = null;
            try {
                server = this.getCloudFoundryServer();
            }
            catch (CoreException ce) {
                CloudFoundryPlugin.logError(ce);
            }
            this.refreshHandler = new RefreshModulesHandler(server);
        }
        return this.refreshHandler;
    }

    public ApplicationDebugLauncher getDebugLauncher() {
        try {
            return CloudFoundryPlugin.getCallback().getDebugLauncher(this.getCloudFoundryServer());
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return ApplicationDebugLauncher.NO_DEBUG;
        }
    }

    public void createService(CloudService[] services, IProgressMonitor monitor) throws CoreException {
        this.operations().createServices(services).run(monitor);
    }

    public synchronized List<CloudDomain> getDomainsFromOrgs(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getDomainsFromOrgs().run(monitor);
    }

    public synchronized List<CloudDomain> getDomainsForSpace(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getDomainsForSpace().run(monitor);
    }

    public void deleteModules(IModule[] modules, boolean deleteServices, IProgressMonitor monitor) throws CoreException {
        this.operations().deleteModules(modules, deleteServices).run(monitor);
    }

    public void deleteApplication(String appName, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().deleteApplication(appName).run(monitor);
    }

    public ICloudFoundryOperation getDeleteServicesOperation(List<String> services) throws CoreException {
        return this.operations().deleteServices(services);
    }

    public ApplicationUrlLookupService getApplicationUrlLookup() {
        if (this.applicationUrlLookup == null) {
            try {
                this.applicationUrlLookup = new ApplicationUrlLookupService(this.getCloudFoundryServer());
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError("Failed to create the Cloud Foundry Application URL lookup service due to {" + e.getMessage(), e);
            }
        }
        return this.applicationUrlLookup;
    }

    protected List<IModuleResource> getChangedResources(IModuleResourceDelta[] deltas) {
        ArrayList<IModuleResource> changed = new ArrayList<IModuleResource>();
        if (deltas != null) {
            this.findNonChangedResources(deltas, changed);
        }
        return changed;
    }

    protected void findNonChangedResources(IModuleResourceDelta[] deltas, List<IModuleResource> changed) {
        if (deltas == null || deltas.length == 0) {
            return;
        }
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            IModuleResource resource = delta.getModuleResource();
            if (resource instanceof IModuleFile && delta.getKind() != 0) {
                changed.add(new ModuleResourceDeltaWrapper(delta));
            }
            this.findNonChangedResources(delta.getAffectedChildren(), changed);
            ++n2;
        }
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        CloudFoundryPlugin.getCallback().disconnecting(this.getCloudFoundryServer());
        Server server = (Server)this.getServer();
        server.setServerState(3);
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        Collection<CloudFoundryApplicationModule> cloudModules = cloudServer.getExistingCloudModules();
        for (CloudFoundryApplicationModule appModule : cloudModules) {
            CloudFoundryPlugin.getCallback().stopApplicationConsole(appModule, cloudServer);
        }
        HashSet<CloudFoundryApplicationModule> deletedModules = new HashSet<CloudFoundryApplicationModule>(cloudModules);
        cloudServer.clearApplications();
        server.setExternalModules(new IModule[0]);
        for (CloudFoundryApplicationModule module : deletedModules) {
            server.setModuleState(new IModule[]{module.getLocalModule()}, 0);
        }
        server.setServerState(4);
        server.setServerPublishState(1);
        ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 406));
    }

    public void reconnect(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(NLS.bind((String)Messages.CloudFoundryServerBehaviour_RECONNECTING_SERVER, (Object)this.getCloudFoundryServer().getServer().getId()));
        this.disconnect((IProgressMonitor)subMonitor.newChild(40));
        try {
            this.resetClient((IProgressMonitor)subMonitor.newChild(20));
        }
        catch (CloudFoundryException cfe) {
            throw CloudErrorUtil.toCoreException(cfe);
        }
        this.connect((IProgressMonitor)subMonitor.newChild(40));
    }

    public void dispose() {
        super.dispose();
        this.getServer().removeServerListener(this.serverListener);
    }

    public CloudFoundryServer getCloudFoundryServer() throws CoreException {
        Server server = (Server)this.getServer();
        CloudFoundryServer cloudFoundryServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
        if (cloudFoundryServer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Fail to load server"));
        }
        return cloudFoundryServer;
    }

    public CloudApplication getApplication(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getCloudApplication(appName, monitor);
    }

    public CloudApplication getCloudApplication(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getCloudApplication(appName).run(monitor);
    }

    public CloudFoundryApplicationModule updateCloudModuleWithInstances(IModule module, IProgressMonitor monitor) throws CoreException {
        String name;
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(module);
        String string = name = appModule != null ? appModule.getDeployedApplicationName() : null;
        if (name != null) {
            return this.updateCloudModuleWithInstances(name, monitor);
        }
        return null;
    }

    public CloudFoundryApplicationModule updateCloudModule(IModule module, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(module);
        String name = appModule != null ? appModule.getDeployedApplicationName() : module.getName();
        return this.updateCloudModule(name, monitor);
    }

    public CloudFoundryApplicationModule updateCloudModule(String appName, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor;
        CloudApplication updatedApp;
        block2: {
            updatedApp = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)Messages.CloudFoundryServer_UPDATING_MODULE, (Object)appName, (Object)this.getServer().getId()));
            try {
                updatedApp = this.getCloudApplication(appName, (IProgressMonitor)subMonitor.newChild(50));
            }
            catch (CoreException e) {
                if (CloudErrorUtil.isNotFoundException(e)) break block2;
                throw e;
            }
        }
        return this.getCloudFoundryServer().updateModule(updatedApp, appName, (IProgressMonitor)subMonitor.newChild(50));
    }

    public CloudFoundryApplicationModule updateCloudModuleWithInstances(String appName, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CloudFoundryApplicationModule appModule = this.updateCloudModule(appName, (IProgressMonitor)subMonitor.newChild(50));
        this.updateInstancesAndStats(appModule, (IProgressMonitor)subMonitor.newChild(50));
        return appModule;
    }

    public void cleanModuleStates(IModule[] modules, IProgressMonitor monitor) {
        IServer iServer = this.getServer();
        if (iServer != null && iServer instanceof Server) {
            Server server = (Server)iServer;
            final ServerPublishInfo info = server.getServerPublishInfo();
            info.startCaching();
            info.clearCache();
            info.fill(modules);
            final ArrayList modules2 = new ArrayList();
            server.visit(new IModuleVisitor(){

                public boolean visit(IModule[] module) {
                    info.fill(module);
                    modules2.add(module);
                    return true;
                }
            }, monitor);
            info.removeDeletedModulePublishInfo(server, modules2);
            info.save();
            super.setModulePublishState(modules, 1);
        }
    }

    private void updateInstancesAndStats(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        block3: {
            if (appModule == null) {
                return;
            }
            try {
                ApplicationStats stats = this.getApplicationStats(appModule.getDeployedApplicationName(), monitor);
                InstancesInfo info = this.getInstancesInfo(appModule.getDeployedApplicationName(), monitor);
                appModule.setApplicationStats(stats);
                appModule.setInstancesInfo(info);
            }
            catch (CoreException e) {
                if (CloudErrorUtil.isNotFoundException(e)) break block3;
                throw e;
            }
        }
    }

    public List<CloudApplication> getApplications(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getApplications().run(monitor);
    }

    public ApplicationStats getApplicationStats(String applicationId, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getApplicationStats(applicationId).run(monitor);
    }

    public InstancesInfo getInstancesInfo(String applicationId, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getInstancesInfo(applicationId).run(monitor);
    }

    public String getFile(final String applicationId, final int instanceIndex, final String path, IProgressMonitor monitor) throws CoreException {
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_FETCHING_FILE, (Object)path, (Object)applicationId);
        return (String)new FileRequest<String>(label, this){

            @Override
            protected String doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getFile(applicationId, instanceIndex, path);
            }
        }.run(monitor);
    }

    public String getFile(final String applicationId, final int instanceIndex, final String filePath, final int startPosition, IProgressMonitor monitor) throws CoreException {
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_FETCHING_FILE, (Object)filePath, (Object)applicationId);
        return (String)new FileRequest<String>(label, this){

            @Override
            protected String doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getFile(applicationId, instanceIndex, filePath, startPosition);
            }
        }.run(monitor);
    }

    public List<CloudServiceOffering> getServiceOfferings(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getServiceOfferings().run(monitor);
    }

    public void deleteAllApplications(IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().deleteAllApplications().run(monitor);
    }

    public List<CloudService> getServices(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getServices().run(monitor);
    }

    public void refreshModules(IProgressMonitor monitor) {
        this.getRefreshHandler().scheduleRefreshAll();
    }

    public CloudFoundryOperations resetClient(IProgressMonitor monitor) throws CoreException {
        return this.resetClient(null, monitor);
    }

    public CloudFoundryOperations resetClient(CloudCredentials credentials, IProgressMonitor monitor) throws CoreException {
        this.internalResetClient();
        return this.getClient(credentials, monitor);
    }

    protected void internalResetClient() {
        this.client = null;
        this.applicationUrlLookup = null;
        this.cloudBehaviourOperations = null;
        this.refreshHandler = null;
    }

    public void startModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.RESTART).run(monitor);
    }

    public void stop(boolean force) {
        this.setServerState(4);
        try {
            ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 406));
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public void stopModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.STOP).run(monitor);
    }

    public ICloudFoundryOperation getStopAppOperation(IModule[] modules) {
        try {
            return this.operations().applicationDeployment(modules, ApplicationAction.STOP);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return null;
        }
    }

    public StreamingLogToken addApplicationLogListener(final String appName, final ApplicationLogListener listener) {
        if (appName != null && listener != null) {
            try {
                return (StreamingLogToken)new BehaviourRequest<StreamingLogToken>("Adding application log listener", this){

                    @Override
                    protected StreamingLogToken doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                        return client.streamLogs(appName, listener);
                    }
                }.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(NLS.bind((String)Messages.ERROR_APPLICATION_LOG_LISTENER, (Object)appName, (Object)e.getMessage()), e);
            }
        }
        return null;
    }

    public List<ApplicationLog> getRecentApplicationLogs(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getRecentApplicationLogs(appName).run(monitor);
    }

    public void restartModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.RESTART).run(monitor);
    }

    public ICloudFoundryOperation getUpdateRestartOperation(IModule[] modules) throws CoreException {
        return this.operations().applicationDeployment(modules, ApplicationAction.UPDATE_RESTART);
    }

    public ICloudFoundryOperation getRestartOperation(IModule[] modules) throws CoreException {
        return this.operations().applicationDeployment(modules, ApplicationAction.RESTART);
    }

    public void updateApplicationInstances(CloudFoundryApplicationModule module, int instanceCount, IProgressMonitor monitor) throws CoreException {
        this.operations().instancesUpdate(module, instanceCount).run(monitor);
    }

    void updateApplicationInstances(String appName, int instanceCount, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().updateApplicationInstances(appName, instanceCount).run(monitor);
    }

    public void updatePassword(String newPassword, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().updatePassword(newPassword).run(monitor);
    }

    public void updateApplicationMemory(CloudFoundryApplicationModule module, int memory, IProgressMonitor monitor) throws CoreException {
        this.operations().memoryUpdate(module, memory).run(monitor);
    }

    public void updateApplicationUrls(String appName, List<String> uris, IProgressMonitor monitor) throws CoreException {
        this.operations().mappedUrlsUpdate(appName, uris).run(monitor);
    }

    public void updateServices(String appName, List<String> services, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(appName);
        this.operations().bindServices(appModule, services);
    }

    public void refreshApplicationBoundServices(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        List<CloudService> allServices;
        DeploymentInfoWorkingCopy copy = appModule.resolveDeploymentInfoWorkingCopy(monitor);
        List<CloudService> boundServices = copy.getServices();
        if (boundServices != null && !boundServices.isEmpty() && (allServices = this.getServices(monitor)) != null) {
            HashMap<String, CloudService> existingAsMap = new HashMap<String, CloudService>();
            for (CloudService existingServices : allServices) {
                existingAsMap.put(existingServices.getName(), existingServices);
            }
            ArrayList<CloudService> updatedServices = new ArrayList<CloudService>();
            for (CloudService boundService : boundServices) {
                CloudService updatedService = (CloudService)existingAsMap.get(boundService.getName());
                if (updatedService != null) {
                    updatedServices.add(updatedService);
                    continue;
                }
                updatedServices.add(boundService);
            }
            copy.setServices(updatedServices);
            copy.save();
        }
    }

    public void register(String email, String password, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().register(email, password).run(monitor);
    }

    protected synchronized CloudFoundryOperations getClient(CloudCredentials credentials, IProgressMonitor monitor) throws CoreException {
        if (this.client == null) {
            CloudFoundryServer cloudServer = this.getCloudFoundryServer();
            String url = cloudServer.getUrl();
            if (!cloudServer.hasCloudSpace()) {
                throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_CLIENT_CREATION_NO_SPACE, (Object)cloudServer.getServerId()));
            }
            CloudFoundrySpace cloudFoundrySpace = cloudServer.getCloudFoundrySpace();
            if (credentials != null) {
                this.client = CloudFoundryServerBehaviour.createClient(url, credentials, cloudFoundrySpace, cloudServer.getSelfSignedCertificate());
            } else {
                String userName = this.getCloudFoundryServer().getUsername();
                String password = this.getCloudFoundryServer().getPassword();
                this.client = CloudFoundryServerBehaviour.createClient(url, userName, password, cloudFoundrySpace, cloudServer.getSelfSignedCertificate());
            }
        }
        return this.client;
    }

    public synchronized CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
        return this.getClient(null, monitor);
    }

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        CloudRebelAppHandler appHandler = CloudFoundryPlugin.getCallback().getJRebelHandler();
        if (appHandler != null) {
            appHandler.register();
        }
        this.getServer().addServerListener(this.serverListener, 16);
        try {
            this.getApplicationUrlLookup().refreshDomains(monitor);
            this.getRefreshHandler().scheduleRefreshAll();
            ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 403));
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public IStatus publishAdd(String moduleName, IProgressMonitor monitor) {
        List allModules = this.getAllModules();
        try {
            for (IModule[] module : allModules) {
                if (!module[0].getName().equals(moduleName)) continue;
                this.operations().applicationDeployment(module, ApplicationAction.PUSH).run(monitor);
                return Status.OK_STATUS;
            }
        }
        catch (CoreException ce) {
            this.handlePublishError(ce);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public boolean existCloudApplicationModule(String moduleName) {
        List allModules = this.getAllModules();
        for (IModule[] modules : allModules) {
            if (!(modules[0] instanceof CloudFoundryApplicationModule) || !modules[0].getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    protected void handlePublishError(CoreException e) {
        IStatus errorStatus = CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ERROR_FAILED_TO_PUSH_APP, (Object)e.getMessage()));
        CloudFoundryPlugin.log(errorStatus);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        if (modules != null && deltaKind2 != null) {
            ArrayList<IModule[]> filteredModules = new ArrayList<IModule[]>(modules.size());
            ArrayList<Integer> filteredDeltaKinds = new ArrayList<Integer>(deltaKind2.size());
            int i = 0;
            while (i < modules.size() && i < deltaKind2.size()) {
                int knd;
                IModule m;
                if (monitor.isCanceled()) {
                    return;
                }
                IModule[] module = (IModule[])modules.get(i);
                if (!(module.length == 0 || this.shouldIgnorePublishRequest(m = module[module.length - 1]) || 1 != (knd = ((Integer)deltaKind2.get(i)).intValue()) && 3 != knd)) {
                    filteredModules.add(module);
                    filteredDeltaKinds.add(knd);
                }
                ++i;
            }
            if (!filteredModules.isEmpty()) {
                modules = filteredModules;
                deltaKind2 = filteredDeltaKinds;
            }
        }
        super.publishModules(kind, (List)modules, (List)deltaKind2, multi, monitor);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        super.publishModule(kind, deltaKind, module, monitor);
        try {
            if (deltaKind == 3) {
                CloudFoundryServer cloudServer = this.getCloudFoundryServer();
                CloudFoundryApplicationModule cloudModule = cloudServer.getCloudModule(module[0]);
                if (cloudModule.getApplication() != null) {
                    this.getRequestFactory().deleteApplication(cloudModule.getDeployedApplicationName()).run(monitor);
                }
            } else if (!module[0].isExternal()) {
                int publishState = this.getServer().getModulePublishState(module);
                ICloudFoundryOperation op = null;
                if (deltaKind == 1 || publishState == 0) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.PUSH);
                } else if (deltaKind == 2) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.UPDATE_RESTART);
                } else if (this.isChildModuleChanged(module, monitor)) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.UPDATE_RESTART);
                }
                if (op != null) {
                    op.run(monitor);
                }
            }
        }
        catch (CoreException e) {
            this.handlePublishError(e);
            throw e;
        }
    }

    private boolean isChildModuleChanged(IModule[] module, IProgressMonitor monitor) {
        if (module == null || module.length == 0) {
            return false;
        }
        IServer myserver = this.getServer();
        IModule[] childModules = myserver.getChildModules(module, monitor);
        if (childModules != null && childModules.length > 0) {
            IModule[] currentChild = new IModule[module.length + 1];
            int i = 0;
            while (i < module.length) {
                currentChild[i] = module[i];
                ++i;
            }
            IModule[] iModuleArray = childModules;
            int n = childModules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule child;
                currentChild[module.length] = child = iModuleArray[n2];
                if (myserver.getModulePublishState(currentChild) != 1 || this.isChildModuleChanged(currentChild, monitor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public CloudOrgsAndSpaces getCloudSpaces(IProgressMonitor monitor) throws CoreException {
        return (CloudOrgsAndSpaces)new BehaviourRequest<CloudOrgsAndSpaces>("Getting orgs and spaces", this){

            @Override
            protected CloudOrgsAndSpaces doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return CloudFoundryServerBehaviour.internalGetCloudSpaces(client);
            }
        }.run(monitor);
    }

    public List<CloudRoute> getRoutes(String domainName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getRoutes(domainName).run(monitor);
    }

    public void deleteRoute(List<CloudRoute> routes, IProgressMonitor monitor) throws CoreException {
        BaseClientRequest<?> request = this.getRequestFactory().deleteRoute(routes);
        if (request != null) {
            request.run(monitor);
        }
    }

    public static CloudOrgsAndSpaces getCloudSpacesExternalClient(CloudCredentials credentials, String url, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        final CloudFoundryOperations operations = CloudFoundryServerBehaviour.createExternalClientLogin(url, credentials.getEmail(), credentials.getPassword(), selfSigned, monitor);
        return (CloudOrgsAndSpaces)new ClientRequest<CloudOrgsAndSpaces>("Getting orgs and spaces"){

            @Override
            protected CloudOrgsAndSpaces doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return CloudFoundryServerBehaviour.internalGetCloudSpaces(client);
            }

            @Override
            protected CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
                return operations;
            }
        }.run(monitor);
    }

    private static CloudOrgsAndSpaces internalGetCloudSpaces(CloudFoundryOperations client) {
        List foundSpaces = client.getSpaces();
        if (foundSpaces != null && !foundSpaces.isEmpty()) {
            ArrayList<CloudSpace> actualSpaces = new ArrayList<CloudSpace>(foundSpaces);
            CloudOrgsAndSpaces orgsAndSpaces = new CloudOrgsAndSpaces(actualSpaces);
            return orgsAndSpaces;
        }
        return null;
    }

    public static void validate(String location, String userName, String password, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServerBehaviour.createExternalClientLogin(location, userName, password, selfSigned, monitor);
    }

    public static CloudFoundryOperations createExternalClientLogin(String location, String userName, String password, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask("Connecting", -1);
        try {
            final CloudFoundryOperations client = CloudFoundryServerBehaviour.createClient(location, userName, password, selfSigned);
            new ClientRequest<Void>(Messages.VALIDATING_CREDENTIALS){

                @Override
                protected Void doRun(CloudFoundryOperations client2, SubMonitor progress) throws CoreException {
                    CloudFoundryLoginHandler operationsHandler = new CloudFoundryLoginHandler(client2);
                    int attempts = 5;
                    operationsHandler.login((IProgressMonitor)progress, attempts, 2000L);
                    return null;
                }

                @Override
                protected CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
                    return client;
                }
            }.run(monitor);
            CloudFoundryOperations cloudFoundryOperations = client;
            return cloudFoundryOperations;
        }
        catch (RuntimeException t) {
            throw CloudErrorUtil.checkServerCommunicationError(t);
        }
        finally {
            progress.done();
        }
    }

    public static void register(String location, String userName, String password, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask("Connecting", -1);
        try {
            try {
                CloudFoundryOperations client = CloudFoundryServerBehaviour.createClient(location, userName, password, selfSigned);
                client.register(userName, password);
            }
            catch (RestClientException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (RuntimeException e) {
                throw CloudErrorUtil.checkServerCommunicationError(e);
            }
        }
        finally {
            progress.done();
        }
    }

    void resetPublishState(IModule[] modules) {
        this.setModulePublishState(modules, 1);
    }

    static CloudFoundryOperations createClient(String location, String userName, String password, boolean selfSigned) throws CoreException {
        return CloudFoundryServerBehaviour.createClient(location, userName, password, null, selfSigned);
    }

    private static CloudFoundryOperations createClient(String serverURL, String userName, String password, CloudFoundrySpace cloudSpace, boolean selfSigned) throws CoreException {
        if (password == null) {
            password = "";
        }
        return CloudFoundryServerBehaviour.createClient(serverURL, new CloudCredentials(userName, password), cloudSpace, selfSigned);
    }

    private static CloudFoundryOperations createClient(String serverURL, CloudCredentials credentials, CloudFoundrySpace cloudSpace, boolean selfSigned) throws CoreException {
        try {
            URL url = new URL(serverURL);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            return cloudSpace != null ? CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(credentials, url, cloudSpace.getOrgName(), cloudSpace.getSpaceName(), selfSigned) : CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(credentials, url, selfSigned);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "The server url " + serverURL + " is invalid: " + e.getMessage(), (Throwable)e));
        }
    }

    protected boolean hasChildModules(IModule[] modules) {
        IWebModule webModule = CloudUtil.getWebModule(modules);
        return webModule != null && webModule.getModules() != null && webModule.getModules().length > 0;
    }

    protected ApplicationArchive generateApplicationArchiveFile(ApplicationDeploymentInfo deploymentInfo, CloudFoundryApplicationModule cloudModule, IModule[] modules, Server server, boolean incrementalPublish, IProgressMonitor monitor) throws CoreException {
        AbstractApplicationDelegate delegate = ApplicationRegistry.getApplicationDelegate(cloudModule.getLocalModule());
        ApplicationArchive archive = null;
        if (delegate != null && delegate.providesApplicationArchive(cloudModule.getLocalModule())) {
            IModuleResource[] resources = this.getResources(modules);
            archive = this.getApplicationArchive(cloudModule, monitor, delegate, resources);
        }
        if (archive == null && incrementalPublish && !this.hasChildModules(modules)) {
            archive = this.getIncrementalPublishArchive(deploymentInfo, modules);
        }
        return archive;
    }

    private ApplicationArchive getApplicationArchive(CloudFoundryApplicationModule cloudModule, IProgressMonitor monitor, AbstractApplicationDelegate delegate, IModuleResource[] resources) throws CoreException {
        return delegate.getApplicationArchive(cloudModule, this.getCloudFoundryServer(), resources, monitor);
    }

    protected void clearAndPrintlnConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = String.valueOf(message) + '\n';
        this.printToConsole(appModule, message, true, false);
    }

    protected void printlnToConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = String.valueOf(message) + '\n';
        this.printToConsole(appModule, message, false, false);
    }

    protected void printErrorlnToConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = NLS.bind((String)(String.valueOf(Messages.CONSOLE_ERROR_MESSAGE) + '\n'), (Object)message);
        this.printToConsole(appModule, message, false, true);
    }

    protected void printToConsole(CloudFoundryApplicationModule appModule, String message, boolean clearConsole, boolean isError) throws CoreException {
        CloudFoundryPlugin.getCallback().printToConsole(this.getCloudFoundryServer(), appModule, message, clearConsole, isError);
    }

    protected ApplicationArchive getIncrementalPublishArchive(ApplicationDeploymentInfo deploymentInfo, IModule[] modules) {
        IModuleResource[] allResources = this.getResources(modules);
        IModuleResourceDelta[] deltas = this.getPublishedResourceDelta(modules);
        List<IModuleResource> changedResources = this.getChangedResources(deltas);
        CachingApplicationArchive moduleArchive = new CachingApplicationArchive(Arrays.asList(allResources), changedResources, modules[0], deploymentInfo.getDeploymentName());
        return moduleArchive;
    }

    public boolean canRestartModule(IModule[] modules) {
        IServer server;
        block4: {
            CloudFoundryServer cloudServer = this.getCloudFoundryServer();
            server = cloudServer.getServerOriginal();
            int moduleState = server.getModuleState(modules);
            if (moduleState != 2) break block4;
            return true;
        }
        try {
            int publishState = server.getModulePublishState(modules);
            if (publishState == 0) {
                return false;
            }
        }
        catch (CoreException ce) {
            CloudFoundryPlugin.logError(ce);
        }
        return super.canRestartModule(modules);
    }

    public ApplicationInstanceRunningTracker getApplicationInstanceRunningTracker(CloudFoundryApplicationModule appModule) throws CoreException {
        return new ApplicationInstanceRunningTracker(appModule, this.getCloudFoundryServer());
    }

    protected static enum DebugSupportCheck {
        UNCHECKED,
        SUPPORTED,
        UNSUPPORTED;

    }

    static class PublishJobMonitor
    extends JobChangeAdapter {
        private List<Job> jobLst = new ArrayList<Job>();

        PublishJobMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            super.done(event);
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.remove(event.getJob());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void monitorJob(Job curJob) {
            curJob.addJobChangeListener((IJobChangeListener)this);
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.add(curJob);
            }
        }

        boolean isAllJobCompleted() {
            return this.jobLst.size() == 0;
        }

        void waitForJobCompletion(IProgressMonitor monitor) {
            while (!(monitor != null && monitor.isCanceled() || this.jobLst.size() <= 0)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

