/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.BaseCommandHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class DisconnectCommand
extends BaseCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.initializeSelection(event);
        final CloudFoundryServer cloudServer = (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null);
        Job disconnectJob = new Job(Messages.DisconnectCommand_JOB_DISCONN_SERVER){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    cloudServer.getBehaviour().disconnect(monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.cft.server.ui", NLS.bind((String)"Failed to disconnect from server: {0}", (Object)e.getMessage()));
                }
                return Status.OK_STATUS;
            }
        };
        disconnectJob.schedule();
        return null;
    }
}

