/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.TableResizeHelper;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class EnvironmentVariablesPart
extends UIPart
implements Observer {
    protected ApplicationDeploymentInfo deploymentInfo;
    private List<EnvironmentVariable> variables;
    private TableViewer envVariablesViewer;
    private Button editEnvVarButton;
    private Button removeEnvVarButton;

    public EnvironmentVariablesPart() {
    }

    public EnvironmentVariablesPart(ApplicationDeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        if (deploymentInfo != null) {
            deploymentInfo.addObserver((Observer)this);
        }
    }

    public void setInput(List<EnvironmentVariable> variables) {
        ArrayList arrayList = this.variables = variables != null ? variables : new ArrayList();
        if (this.envVariablesViewer != null) {
            this.envVariablesViewer.setInput(variables);
        }
    }

    public List<EnvironmentVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<EnvironmentVariable> variables) {
        this.variables = variables;
        this.setInput(variables);
    }

    @Override
    public Control createPart(Composite parent) {
        Composite commonArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(commonArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commonArea);
        Composite tableParent = new Composite(commonArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableParent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableParent);
        Table table = new Table(tableParent, 2050);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.envVariablesViewer = new TableViewer(table);
        Listener actionEnabler = new Listener(){

            public void handleEvent(Event event) {
                EnvironmentVariablesPart.this.setEnabledDisabled();
            }
        };
        table.addListener(13, actionEnabler);
        table.addListener(16, actionEnabler);
        this.envVariablesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray(new Object[0]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.envVariablesViewer.setLabelProvider((IBaseLabelProvider)new EnvVarLabelProvider(this.envVariablesViewer));
        table.setHeaderVisible(true);
        new TableResizeHelper(this.envVariablesViewer).enableResizing();
        int columnIndex = 0;
        ViewColumn[] columns = ViewColumn.values();
        String[] columnProperties = new String[columns.length];
        ViewColumn[] viewColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ViewColumn column = viewColumnArray[n2];
            columnProperties[columnIndex] = column.name();
            TableColumn tableColumn = new TableColumn(table, 0, columnIndex++);
            tableColumn.setData((Object)column);
            tableColumn.setText(column.getUserFacingName());
            tableColumn.setWidth(column.getWidth());
            ++n2;
        }
        this.envVariablesViewer.setColumnProperties(columnProperties);
        this.envVariablesViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID >= 0) {
                    e.result = e.result != null ? NLS.bind((String)Messages.EnvironmentVariablesPart_TEXT_TABLE_ACC_LABEL, (Object)e.result) : Messages.COMMONTXT_ENV_VAR;
                }
            }
        });
        this.addEditButtons(commonArea);
        return commonArea;
    }

    protected void setEnabledDisabled() {
        this.removeEnvVarButton.setEnabled(this.isDeleteEnabled());
        this.editEnvVarButton.setEnabled(this.isEditEnabled());
    }

    private void addEditButtons(Composite parent) {
        Composite buttonArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(-1, 4).applyTo(buttonArea);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonArea);
        Button newEnvVarButton = new Button(buttonArea, 0);
        newEnvVarButton.setText(Messages.EnvironmentVariablesPart_TEXT_NEW_ENV_VAR);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)newEnvVarButton);
        newEnvVarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariablesPart.this.handleAdd();
            }
        });
        this.editEnvVarButton = new Button(buttonArea, 0);
        this.editEnvVarButton.setText(Messages.COMMONTXT_EDIT);
        this.editEnvVarButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.editEnvVarButton);
        this.editEnvVarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariablesPart.this.handleEdit();
            }
        });
        this.removeEnvVarButton = new Button(buttonArea, 0);
        this.removeEnvVarButton.setText(Messages.COMMONTXT_REMOVE);
        this.removeEnvVarButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.removeEnvVarButton);
        this.removeEnvVarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariablesPart.this.handleDelete();
            }
        });
    }

    private boolean isEditEnabled() {
        List<EnvironmentVariable> vars = this.getViewerSelection();
        boolean isEnabled = vars != null && vars.size() == 1;
        return isEnabled;
    }

    private boolean isDeleteEnabled() {
        List<EnvironmentVariable> vars = this.getViewerSelection();
        boolean isEnabled = vars != null && vars.size() > 0;
        return isEnabled;
    }

    protected void handleAdd() {
        VariableDialogue dialogue;
        boolean variableChanged = false;
        Shell shell = CFUiUtil.getShell();
        if (shell != null && (dialogue = new VariableDialogue(shell, Messages.EnvironmentVariablesPart_ADD_TITLE, null, this.variables)).open() == 0) {
            variableChanged = this.updateVariables(dialogue.getEnvironmentVariable(), null);
        }
        if (variableChanged) {
            this.notifyStatusChange(Status.OK_STATUS);
        }
    }

    protected void handleEdit() {
        boolean variableChanged = false;
        Shell shell = CFUiUtil.getShell();
        List<EnvironmentVariable> selection = this.getViewerSelection();
        if (shell != null && selection != null && !selection.isEmpty()) {
            EnvironmentVariable toEdit = selection.get(0);
            ArrayList<EnvironmentVariable> envList = new ArrayList<EnvironmentVariable>();
            int i = 0;
            while (i < this.variables.size()) {
                if (!this.variables.get(i).getVariable().equals(toEdit.getVariable())) {
                    envList.add(this.variables.get(i));
                }
                ++i;
            }
            VariableDialogue dialogue = new VariableDialogue(shell, Messages.EnvironmentVariablesPart_EDIT_TITLE, toEdit, envList);
            if (dialogue.open() == 0) {
                variableChanged = this.updateVariables(dialogue.getEnvironmentVariable(), toEdit);
            }
        }
        if (variableChanged) {
            this.notifyStatusChange(Status.OK_STATUS);
            this.setEnabledDisabled();
        }
    }

    protected void handleDelete() {
        boolean variableChanged = false;
        List<EnvironmentVariable> selection = this.getViewerSelection();
        if (selection != null && !selection.isEmpty()) {
            for (EnvironmentVariable toDelete : selection) {
                boolean bl = variableChanged = variableChanged || this.updateVariables(null, toDelete);
            }
        }
        if (variableChanged) {
            this.notifyStatusChange(Status.OK_STATUS);
            this.setEnabledDisabled();
        }
    }

    protected boolean updateVariables(EnvironmentVariable add, EnvironmentVariable delete) {
        boolean variableChanged = false;
        if (this.variables == null) {
            this.variables = new ArrayList<EnvironmentVariable>();
        }
        if (delete != null) {
            ArrayList<EnvironmentVariable> updatedList = new ArrayList<EnvironmentVariable>();
            for (EnvironmentVariable var : this.variables) {
                if (var.equals(delete)) {
                    variableChanged = true;
                    continue;
                }
                updatedList.add(var);
            }
            this.variables = updatedList;
        }
        if (add != null) {
            this.variables.add(add);
            variableChanged = true;
        }
        this.setInput(this.variables);
        return variableChanged;
    }

    protected List<EnvironmentVariable> getViewerSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.envVariablesViewer.getSelection();
        ArrayList<EnvironmentVariable> selectedVars = new ArrayList<EnvironmentVariable>();
        if (!selection.isEmpty()) {
            Object[] servicesObjs;
            Object[] objectArray = servicesObjs = selection.toArray();
            int n = servicesObjs.length;
            int n2 = 0;
            while (n2 < n) {
                Object serviceObj = objectArray[n2];
                selectedVars.add((EnvironmentVariable)serviceObj);
                ++n2;
            }
        }
        return selectedVars;
    }

    protected void setViewerSelection(EnvironmentVariable var) {
        if (var != null) {
            this.envVariablesViewer.setSelection((ISelection)new StructuredSelection((Object)var));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        block3: {
            if (arg != null && arg instanceof List) {
                try {
                    List envList = (List)arg;
                    this.setInput(envList);
                }
                catch (Exception e) {
                    if (!Logger.ERROR) break block3;
                    Logger.println("/debug/error", this, "update", "Error updating Environment Variable", (Throwable)e);
                }
            }
        }
    }

    protected class EnvVarLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final TableViewer viewer;

        public EnvVarLabelProvider(TableViewer viewer) {
            this.viewer = viewer;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ViewColumn serviceColumn;
            String result = null;
            TableColumn column = this.viewer.getTable().getColumn(columnIndex);
            if (column != null && (serviceColumn = (ViewColumn)((Object)column.getData())) != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (serviceColumn) {
                    case Variable: {
                        result = var.getVariable();
                        break;
                    }
                    case Value: {
                        result = var.getValue();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class VariableDialogue
    extends StatusDialog {
        private EnvironmentVariable envVar;
        private String title;
        private Text name;
        private Text value;
        private List<EnvironmentVariable> variables;

        public VariableDialogue(Shell shell, String title, EnvironmentVariable envVar, List<EnvironmentVariable> variables) {
            super(shell);
            this.envVar = new EnvironmentVariable();
            this.title = title;
            this.variables = variables;
            if (envVar != null) {
                this.envVar.setValue(envVar.getValue());
                this.envVar.setVariable(envVar.getVariable());
            }
            this.setHelpAvailable(false);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public EnvironmentVariable getEnvironmentVariable() {
            return this.envVar;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.validate();
            return control;
        }

        protected void setValues(Control control) {
            if (control == null || control.isDisposed()) {
                return;
            }
            if (control == this.name) {
                this.envVar.setVariable(this.name.getText());
            } else if (control == this.value) {
                this.envVar.setValue(this.value.getText());
            }
            this.validate();
        }

        protected void validate() {
            Button okButton = this.getButton(0);
            if (okButton != null && !okButton.isDisposed()) {
                boolean isEmpty = ValueValidationUtil.isEmpty((String)this.envVar.getVariable());
                boolean isDuplicate = false;
                for (EnvironmentVariable env : this.variables) {
                    if (!env.getVariable().equals(this.envVar.getVariable())) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) {
                    this.updateStatus((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.EnvironmentVariablesPart_DUP_VARIABLE_ERROR));
                } else if (isEmpty) {
                    this.updateStatus((IStatus)new Status(4, "org.eclipse.cft.server.ui", Messages.EnvironmentVariablesPart_EMPTY_VARIABLE_ERROR));
                } else {
                    this.updateStatus(Status.OK_STATUS);
                }
                okButton.setEnabled(!isEmpty && !isDuplicate);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.COMMONTXT_ENV_VAR);
            this.setTitle(this.title);
            Composite control = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(control, 0);
            GridLayout layout = new GridLayout(2, false);
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = 500;
            composite.setLayoutData((Object)data);
            composite.setLayout((Layout)layout);
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(Messages.COMMONTXT_NAME_WITH_COLON);
            this.name = new Text(composite, 2048);
            this.name.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.envVar != null && this.envVar.getVariable() != null) {
                this.name.setText(this.envVar.getVariable());
            }
            this.name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    VariableDialogue.this.setValues((Control)VariableDialogue.this.name);
                }
            });
            Label valueLabel = new Label(composite, 0);
            valueLabel.setText(Messages.EnvironmentVariablesPart_TEXT_VALUE_LABEL);
            this.value = new Text(composite, 2048);
            this.value.setLayoutData((Object)new GridData(4, 4, true, false));
            if (this.envVar != null && this.envVar.getValue() != null) {
                this.value.setText(this.envVar.getValue());
            }
            this.value.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    VariableDialogue.this.setValues((Control)VariableDialogue.this.value);
                }
            });
            this.validate();
            return control;
        }
    }

    static enum ViewColumn {
        Variable(200, Messages.TableColumn_VARIABLE),
        Value(200, Messages.TableColumn_VALUE);

        private final int width;
        private final String userFacingName;

        private ViewColumn(int width, String userFacingName) {
            this.width = width;
            this.userFacingName = userFacingName;
        }

        public int getWidth() {
            return this.width;
        }

        public String getUserFacingName() {
            return this.userFacingName;
        }
    }
}

