/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryClientFactory;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class ConnectSsoServerDialog
extends Dialog {
    private Text passcodeText;
    private Text errorMessageText;
    private String errorMessage;
    private CloudFoundryServer cloudServer;
    private boolean connectionSuccess = false;

    public ConnectSsoServerDialog(Shell shell, CloudFoundryServer cloudServer) {
        super(shell);
        this.cloudServer = cloudServer;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            final ConnectThread ct = new ConnectThread(this.cloudServer, this.passcodeText.getText());
            this.getShell().setCursor(Display.getCurrent().getSystemCursor(1));
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IServerWorkingCopy server = ConnectSsoServerDialog.this.cloudServer.getServerWorkingCopy();
                    if (server == null) {
                        server = ConnectSsoServerDialog.this.cloudServer.getServer().createWorkingCopy();
                        ConnectSsoServerDialog.this.cloudServer.getBehaviour();
                    }
                    server.setAttribute("org.eclipse.cft.passcode", ConnectSsoServerDialog.this.passcodeText.getText());
                    server.save(true, (IProgressMonitor)new NullProgressMonitor());
                    ct.start();
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            while (!monitor.isCanceled() && !ct.isJobComplete()) {
                                Thread.sleep(100L);
                            }
                        }
                    });
                    CoreException exception = ct.getException();
                    if (exception != null) {
                        if (exception.getMessage() != null) {
                            ConnectSsoServerDialog.this.setErrorMessage(exception.getMessage());
                        }
                        CloudFoundryServerUiPlugin.logError(exception);
                    }
                }

                public void handleException(Throwable e) {
                    ConnectSsoServerDialog.this.setErrorMessage(e.getMessage());
                    CloudFoundryServerUiPlugin.logError(e);
                }
            });
            this.getShell().setCursor(null);
            if (ct.isConnected()) {
                this.connectionSuccess = true;
                super.buttonPressed(buttonId);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ConnectSsoServerDialog_CONNECT_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ConnectSsoServerDialog_CONNECT_BUTTON, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.passcodeText.setFocus();
        String value = this.cloudServer.getPasscode();
        if (value != null) {
            this.passcodeText.setText(value);
            this.passcodeText.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Link prompt = new Link(composite, 16448);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        prompt.setLayoutData((Object)gd);
        String ssoUrl = CloudUiUtil.getPromptText(this.cloudServer);
        prompt.setText(ssoUrl);
        prompt.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ConnectSsoServerDialog.this.cloudServer.getUrl() != null && !ConnectSsoServerDialog.this.cloudServer.getUrl().isEmpty()) {
                    try {
                        String url = CloudFoundryClientFactory.getSsoUrl((String)ConnectSsoServerDialog.this.cloudServer.getUrl(), (boolean)ConnectSsoServerDialog.this.cloudServer.getSelfSignedCertificate());
                        CloudUiUtil.openUrl(url, 1);
                    }
                    catch (Exception e) {
                        CloudFoundryServerUiPlugin.logError(e);
                    }
                }
            }
        });
        Label passcodeLabel = new Label(composite, 0);
        passcodeLabel.setText(Messages.LABEL_PASSCODE);
        gd = new GridData(4, 0x1000000, false, false);
        passcodeLabel.setLayoutData((Object)gd);
        this.passcodeText = new Text(composite, 0x400800);
        gd = new GridData(4, 4, true, false);
        this.passcodeText.setLayoutData((Object)gd);
        this.passcodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectSsoServerDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 72);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.errorMessageText.setLayoutData((Object)gd);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        ConnectSsoServerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.passcodeText.getText().isEmpty()) {
            errorMessage = Messages.ConnectSsoServerDialog_Passcode_is_required;
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    public boolean isConnectionSuccess() {
        return this.connectionSuccess;
    }

    private static class ConnectThread
    extends Thread {
        final CloudFoundryServer cloudServer;
        final String passcodeTxt;
        boolean connectResult = false;
        boolean jobComplete = false;
        CoreException exception;

        public ConnectThread(CloudFoundryServer cloudServer, String passcodeTxt) {
            this.cloudServer = cloudServer;
            this.passcodeTxt = passcodeTxt;
        }

        @Override
        public void run() {
            try {
                try {
                    boolean result = this.cloudServer.getBehaviour().regenerateSsoLogin(this.passcodeTxt, (IProgressMonitor)new NullProgressMonitor());
                    if (result) {
                        RefreshServerJob refreshJob = new RefreshServerJob(this.cloudServer);
                        refreshJob.setPriority(20);
                        refreshJob.schedule();
                        this.connectResult = true;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    this.exception = e;
                    this.jobComplete = true;
                    return;
                }
            }
            finally {
                this.jobComplete = true;
            }
        }

        public boolean isConnected() {
            return this.connectResult;
        }

        public boolean isJobComplete() {
            return this.jobComplete;
        }

        public CoreException getException() {
            return this.exception;
        }
    }

    private static class RefreshServerJob
    extends Job {
        final CloudFoundryServer cloudServer;

        public RefreshServerJob(CloudFoundryServer cloudServer) {
            super(Messages.ConnectCommand_JOB_CONN_SERVER);
            this.setSystem(false);
            this.setUser(true);
            this.cloudServer = cloudServer;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.cloudServer.getBehaviour().connect(monitor);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return e.getStatus();
            }
        }
    }
}

