/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=kk

/**
 * Localized names for the "kk" locale.
 */
public class LocalizedNamesImpl_kk extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AU",
        "AT",
        "AX",
        "AL",
        "DZ",
        "DE",
        "QO",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "US",
        "VI",
        "UM",
        "BS",
        "BD",
        "BB",
        "EH",
        "BH",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "AE",
        "VU",
        "VA",
        "HU",
        "VE",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "GG",
        "GI",
        "NL",
        "HN",
        "GR",
        "GD",
        "GL",
        "GE",
        "GU",
        "DK",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EU",
        "JP",
        "NZ",
        "NC",
        "ZM",
        "ZW",
        "IL",
        "IN",
        "ID",
        "JO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "CV",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CD",
        "CG",
        "XK",
        "CR",
        "CI",
        "CX",
        "CU",
        "KW",
        "CK",
        "CW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MQ",
        "MH",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MS",
        "MA",
        "MN",
        "EG",
        "MM",
        "IM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NF",
        "OM",
        "CF",
        "ZA",
        "GS",
        "KP",
        "SS",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "PK",
        "RU",
        "RE",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SC",
        "BL",
        "MF",
        "PM",
        "SN",
        "VC",
        "KN",
        "LC",
        "RS",
        "EA",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "KR",
        "MP",
        "SO",
        "SD",
        "SR",
        "SL",
        "TW",
        "TH",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TC",
        "TR",
        "TM",
        "TJ",
        "UG",
        "UA",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "HM",
        "HR",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "SJ",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "JM",
        "AC",
        "KZ",
        "KG",
        "CN",
        "HK",
        "MO",
        "IO",
        "GB",
        "AZ",
        "SH",
        "UZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Әлем");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Солтүстік Америка");
    namesMap.put("005", "Оңтүстік Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Батыс Африка");
    namesMap.put("013", "Орталық Америка");
    namesMap.put("014", "Шығыс Африка");
    namesMap.put("015", "Солтүстік Африка");
    namesMap.put("017", "Орталық Африка");
    namesMap.put("018", "Оңтүстік Африка");
    namesMap.put("019", "Америкалар");
    namesMap.put("021", "Американың солтүстігі");
    namesMap.put("029", "Кариб");
    namesMap.put("030", "Шығыс Азия");
    namesMap.put("034", "Оңтүстік Азия");
    namesMap.put("035", "Оңтүстік-шығыс Азия");
    namesMap.put("039", "Оңтүстік Еуропа");
    namesMap.put("053", "Австралазия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия регионы");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Орталық Азия");
    namesMap.put("145", "Батыс Азия");
    namesMap.put("150", "Еуропа");
    namesMap.put("151", "Шығыс Еуропа");
    namesMap.put("154", "Солтүстік Еуропа");
    namesMap.put("155", "Батыс Еуропа");
    namesMap.put("419", "Латын Америкасы");
    namesMap.put("AC", "Ғибадат аралы");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Біріккен Араб Эмираттары");
    namesMap.put("AF", "Ауғанстан");
    namesMap.put("AG", "Антигуа мен Барбуда");
    namesMap.put("AI", "Ангилья");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американ Самоасы");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аланд аралдары");
    namesMap.put("AZ", "Әзербайжан");
    namesMap.put("BA", "Босния және Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгия");
    namesMap.put("BF", "Буркина-Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сен-Бартелеми");
    namesMap.put("BM", "Бермуд аралдары");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Боливия");
    namesMap.put("BQ", "Кариб Нидерландысы");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багам аралдары");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буве аралы");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос аралдары");
    namesMap.put("CD", "Конго Демократиялық Республикасы");
    namesMap.put("CF", "Орталық Африка Республикасы");
    namesMap.put("CG", "Конго Республикасы");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот-д’Ивуар");
    namesMap.put("CK", "Кук аралдары");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Қытай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "Клиппертон аралы");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "Кристмас аралы");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чех Республикасы");
    namesMap.put("DE", "Алмания");
    namesMap.put("DG", "Диего-Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминикан Республикасы");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута мен Мелилья");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Мысыр");
    namesMap.put("EH", "Батыс Сахара");
    namesMap.put("ER", "Эритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("EU", "Еуропалық Одақ");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолкленд аралдары");
    namesMap.put("FM", "Микронезия");
    namesMap.put("FO", "Фарер аралдары");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Ұлыбритания");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Француз Гвианасы");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Экваторлық Гвинея");
    namesMap.put("GR", "Грекия");
    namesMap.put("GS", "Оңтүстік Георгия және Оңтүстік Сандвичев аралы");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "Қытай Халық Республикасының Гонг-Конг арнайы әкімшілік ауданы");
    namesMap.put("HM", "Херд аралы мен Макдональд аралы");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("IC", "Канар аралдары");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израиль");
    namesMap.put("IM", "Мэн аралы");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Үнді мұхитындағы Британ аймағы");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джерси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Иордания");
    namesMap.put("JP", "Жапония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Қырғызстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Комор");
    namesMap.put("KN", "Сент-Китс және Невис");
    namesMap.put("KP", "Оңтүстік Корея");
    namesMap.put("KR", "Солтүстік Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайман аралдары");
    namesMap.put("KZ", "Қазақстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Лебанон");
    namesMap.put("LC", "Сент-Люсия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Либия");
    namesMap.put("MA", "Морокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черногория");
    namesMap.put("MF", "Сен-Мартен");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалл аралдары");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мьянма (Бирма)");
    namesMap.put("MN", "Моңғолия");
    namesMap.put("MO", "Қытай Халық Республикасының Макао арнайы әкімшілік ауданы");
    namesMap.put("MP", "Солтүстік Мариан аралдары");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Мальдив Республикасы");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Жаңа Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк аралы");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Голландия");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуэ");
    namesMap.put("NZ", "Жаңа Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француз Полинезиясы");
    namesMap.put("PG", "Папуа — Жаңа Гвинея");
    namesMap.put("PH", "Филиппиндер");
    namesMap.put("PK", "Пәкістан");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Сен-Пьер және Микелон");
    namesMap.put("PN", "Питкэрн аралдары");
    namesMap.put("PR", "Пуэрто-Рико");
    namesMap.put("PS", "Палестина аймақтары");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Алыс Океания");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Румыния");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Ресей");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Сауд Арабиясы");
    namesMap.put("SB", "Соломон аралдары");
    namesMap.put("SC", "Сейшель аралдары");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Әулие Елена аралы");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Шпицберген мен Ян-Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Оңтүстік Судан");
    namesMap.put("ST", "Сан-Томе мен Принсипи");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SX", "Синт-Мартен");
    namesMap.put("SY", "Сирия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан-да-Кунья");
    namesMap.put("TC", "Туркс пен Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Францияның солтүстік аймағы");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Тәжікстан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Тимор-Лесте");
    namesMap.put("TM", "Түрікменстан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Түркия");
    namesMap.put("TT", "Тринидад пен Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АҚШ-тың ішкі кіші аралдары");
    namesMap.put("US", "АҚШ");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Өзбекстан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Винсент және Гренадиндер");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Британдық Виргин аралдары");
    namesMap.put("VI", "АҚШ-тың Виргин аралдары");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис пен Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "Оңтүстік Африка республикасы");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Белгісіз аймақ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Әлем",
        "002": "Африка",
        "003": "Солтүстік Америка",
        "005": "Оңтүстік Америка",
        "009": "Океания",
        "011": "Батыс Африка",
        "013": "Орталық Америка",
        "014": "Шығыс Африка",
        "015": "Солтүстік Африка",
        "017": "Орталық Африка",
        "018": "Оңтүстік Африка",
        "019": "Америкалар",
        "021": "Американың солтүстігі",
        "029": "Кариб",
        "030": "Шығыс Азия",
        "034": "Оңтүстік Азия",
        "035": "Оңтүстік-шығыс Азия",
        "039": "Оңтүстік Еуропа",
        "053": "Австралазия",
        "054": "Меланезия",
        "057": "Микронезия регионы",
        "061": "Полинезия",
        "142": "Азия",
        "143": "Орталық Азия",
        "145": "Батыс Азия",
        "150": "Еуропа",
        "151": "Шығыс Еуропа",
        "154": "Солтүстік Еуропа",
        "155": "Батыс Еуропа",
        "419": "Латын Америкасы",
        "AC": "Ғибадат аралы",
        "AD": "Андорра",
        "AE": "Біріккен Араб Эмираттары",
        "AF": "Ауғанстан",
        "AG": "Антигуа мен Барбуда",
        "AI": "Ангилья",
        "AL": "Албания",
        "AM": "Армения",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аргентина",
        "AS": "Американ Самоасы",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Аланд аралдары",
        "AZ": "Әзербайжан",
        "BA": "Босния және Герцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Бельгия",
        "BF": "Буркина-Фасо",
        "BG": "Болгария",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сен-Бартелеми",
        "BM": "Бермуд аралдары",
        "BN": "Бруней",
        "BO": "Боливия",
        "BQ": "Кариб Нидерландысы",
        "BR": "Бразилия",
        "BS": "Багам аралдары",
        "BT": "Бутан",
        "BV": "Буве аралы",
        "BW": "Ботсвана",
        "BY": "Беларусь",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокос аралдары",
        "CD": "Конго Демократиялық Республикасы",
        "CF": "Орталық Африка Республикасы",
        "CG": "Конго Республикасы",
        "CH": "Швейцария",
        "CI": "Кот-д’Ивуар",
        "CK": "Кук аралдары",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Қытай",
        "CO": "Колумбия",
        "CP": "Клиппертон аралы",
        "CR": "Коста-Рика",
        "CU": "Куба",
        "CV": "Кабо-Верде",
        "CW": "Кюрасао",
        "CX": "Кристмас аралы",
        "CY": "Кипр",
        "CZ": "Чех Республикасы",
        "DE": "Алмания",
        "DG": "Диего-Гарсия",
        "DJ": "Джибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминикан Республикасы",
        "DZ": "Алжир",
        "EA": "Сеута мен Мелилья",
        "EC": "Эквадор",
        "EE": "Эстония",
        "EG": "Мысыр",
        "EH": "Батыс Сахара",
        "ER": "Эритрея",
        "ES": "Испания",
        "ET": "Эфиопия",
        "EU": "Еуропалық Одақ",
        "FI": "Финляндия",
        "FJ": "Фиджи",
        "FK": "Фолкленд аралдары",
        "FM": "Микронезия",
        "FO": "Фарер аралдары",
        "FR": "Франция",
        "GA": "Габон",
        "GB": "Ұлыбритания",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Француз Гвианасы",
        "GG": "Гернси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гвинея",
        "GP": "Гваделупа",
        "GQ": "Экваторлық Гвинея",
        "GR": "Грекия",
        "GS": "Оңтүстік Георгия және Оңтүстік Сандвичев аралы",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинея-Бисау",
        "GY": "Гайана",
        "HK": "Қытай Халық Республикасының Гонг-Конг арнайы әкімшілік ауданы",
        "HM": "Херд аралы мен Макдональд аралы",
        "HN": "Гондурас",
        "HR": "Хорватия",
        "HT": "Гаити",
        "HU": "Венгрия",
        "IC": "Канар аралдары",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Израиль",
        "IM": "Мэн аралы",
        "IN": "Индия",
        "IO": "Үнді мұхитындағы Британ аймағы",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "Джерси",
        "JM": "Ямайка",
        "JO": "Иордания",
        "JP": "Жапония",
        "KE": "Кения",
        "KG": "Қырғызстан",
        "KH": "Камбоджа",
        "KI": "Кирибати",
        "KM": "Комор",
        "KN": "Сент-Китс және Невис",
        "KP": "Оңтүстік Корея",
        "KR": "Солтүстік Корея",
        "KW": "Кувейт",
        "KY": "Кайман аралдары",
        "KZ": "Қазақстан",
        "LA": "Лаос",
        "LB": "Лебанон",
        "LC": "Сент-Люсия",
        "LI": "Лихтенштейн",
        "LK": "Шри-Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Либия",
        "MA": "Морокко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Черногория",
        "MF": "Сен-Мартен",
        "MG": "Мадагаскар",
        "MH": "Маршалл аралдары",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мьянма (Бирма)",
        "MN": "Моңғолия",
        "MO": "Қытай Халық Республикасының Макао арнайы әкімшілік ауданы",
        "MP": "Солтүстік Мариан аралдары",
        "MQ": "Мартиника",
        "MR": "Мавритания",
        "MS": "Монтсеррат",
        "MT": "Мальта",
        "MU": "Маврикий",
        "MV": "Мальдив Республикасы",
        "MW": "Малави",
        "MX": "Мексика",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Жаңа Каледония",
        "NE": "Нигер",
        "NF": "Норфолк аралы",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Голландия",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуэ",
        "NZ": "Жаңа Зеландия",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Француз Полинезиясы",
        "PG": "Папуа — Жаңа Гвинея",
        "PH": "Филиппиндер",
        "PK": "Пәкістан",
        "PL": "Польша",
        "PM": "Сен-Пьер және Микелон",
        "PN": "Питкэрн аралдары",
        "PR": "Пуэрто-Рико",
        "PS": "Палестина аймақтары",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Алыс Океания",
        "RE": "Реюньон",
        "RO": "Румыния",
        "RS": "Сербия",
        "RU": "Ресей",
        "RW": "Руанда",
        "SA": "Сауд Арабиясы",
        "SB": "Соломон аралдары",
        "SC": "Сейшель аралдары",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Әулие Елена аралы",
        "SI": "Словения",
        "SJ": "Шпицберген мен Ян-Майен",
        "SK": "Словакия",
        "SL": "Сьерра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринам",
        "SS": "Оңтүстік Судан",
        "ST": "Сан-Томе мен Принсипи",
        "SV": "Сальвадор",
        "SX": "Синт-Мартен",
        "SY": "Сирия",
        "SZ": "Свазиленд",
        "TA": "Тристан-да-Кунья",
        "TC": "Туркс пен Кайкос",
        "TD": "Чад",
        "TF": "Францияның солтүстік аймағы",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Тәжікстан",
        "TK": "Токелау",
        "TL": "Тимор-Лесте",
        "TM": "Түрікменстан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Түркия",
        "TT": "Тринидад пен Тобаго",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзания",
        "UA": "Украина",
        "UG": "Уганда",
        "UM": "АҚШ-тың ішкі кіші аралдары",
        "US": "АҚШ",
        "UY": "Уругвай",
        "UZ": "Өзбекстан",
        "VA": "Ватикан",
        "VC": "Сент-Винсент және Гренадиндер",
        "VE": "Венесуэла",
        "VG": "Британдық Виргин аралдары",
        "VI": "АҚШ-тың Виргин аралдары",
        "VN": "Вьетнам",
        "VU": "Вануату",
        "WF": "Уоллис пен Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Йемен",
        "YT": "Майотта",
        "ZA": "Оңтүстік Африка республикасы",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "Белгісіз аймақ"
    };
  }-*/;
}
