/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=root

/**
 * Localized names for the "nl" locale.
 */
public class LocalizedNamesImpl_nl extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "NL",
        "BE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "VI",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CA",
        "IC",
        "BQ",
        "KY",
        "CF",
        "EA",
        "CL",
        "CN",
        "CX",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CK",
        "CR",
        "CU",
        "CW",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DE",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FO",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HU",
        "HK",
        "IE",
        "IS",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IM",
        "IL",
        "IT",
        "CI",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CV",
        "CM",
        "KZ",
        "KE",
        "KG",
        "KI",
        "UM",
        "KW",
        "XK",
        "HR",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NL",
        "AN",
        "NP",
        "NI",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NU",
        "MP",
        "KP",
        "NO",
        "NF",
        "UG",
        "UA",
        "UZ",
        "OM",
        "AT",
        "TL",
        "QO",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SB",
        "WS",
        "SM",
        "SA",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SH",
        "SX",
        "SI",
        "SK",
        "SD",
        "SO",
        "ES",
        "SJ",
        "LK",
        "SR",
        "SZ",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UY",
        "VU",
        "VA",
        "VE",
        "AE",
        "US",
        "GB",
        "VN",
        "WF",
        "EH",
        "BY",
        "ZM",
        "ZW",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SE",
        "CH",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Wereld");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Noord-Amerika");
    namesMap.put("005", "Zuid-Amerika");
    namesMap.put("009", "Oceanië");
    namesMap.put("011", "West-Afrika");
    namesMap.put("013", "Midden-Amerika");
    namesMap.put("014", "Oost-Afrika");
    namesMap.put("015", "Noord-Afrika");
    namesMap.put("017", "Centraal-Afrika");
    namesMap.put("018", "Zuidelijk Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Noordelijk Amerika");
    namesMap.put("029", "Caribisch gebied");
    namesMap.put("030", "Oost-Azië");
    namesMap.put("034", "Zuid-Azië");
    namesMap.put("035", "Zuidoost-Azië");
    namesMap.put("039", "Zuid-Europa");
    namesMap.put("053", "Australazië");
    namesMap.put("054", "Melanesië");
    namesMap.put("057", "Micronesische regio");
    namesMap.put("061", "Polynesië");
    namesMap.put("142", "Azië");
    namesMap.put("143", "Centraal-Azië");
    namesMap.put("145", "West-Azië");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Oost-Europa");
    namesMap.put("154", "Noord-Europa");
    namesMap.put("155", "West-Europa");
    namesMap.put("419", "Latijns-Amerika");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Verenigde Arabische Emiraten");
    namesMap.put("AG", "Antigua en Barbuda");
    namesMap.put("AL", "Albanië");
    namesMap.put("AM", "Armenië");
    namesMap.put("AN", "Nederlandse Antillen");
    namesMap.put("AR", "Argentinië");
    namesMap.put("AS", "Amerikaans Samoa");
    namesMap.put("AT", "Oostenrijk");
    namesMap.put("AU", "Australië");
    namesMap.put("AX", "Åland");
    namesMap.put("AZ", "Azerbeidzjan");
    namesMap.put("BA", "Bosnië en Herzegovina");
    namesMap.put("BE", "België");
    namesMap.put("BG", "Bulgarije");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BQ", "Caribisch Nederland");
    namesMap.put("BR", "Brazilië");
    namesMap.put("BS", "Bahama’s");
    namesMap.put("BV", "Bouveteiland");
    namesMap.put("BY", "Wit-Rusland");
    namesMap.put("CC", "Cocoseilanden");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "Centraal-Afrikaanse Republiek");
    namesMap.put("CG", "Congo-Brazzaville");
    namesMap.put("CH", "Zwitserland");
    namesMap.put("CI", "Ivoorkust");
    namesMap.put("CK", "Cookeilanden");
    namesMap.put("CL", "Chili");
    namesMap.put("CM", "Kameroen");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CV", "Kaapverdië");
    namesMap.put("CX", "Christmaseiland");
    namesMap.put("CZ", "Tsjechië");
    namesMap.put("DE", "Duitsland");
    namesMap.put("DK", "Denemarken");
    namesMap.put("DO", "Dominicaanse Republiek");
    namesMap.put("DZ", "Algerije");
    namesMap.put("EA", "Ceuta en Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Egypte");
    namesMap.put("EH", "Westelijke Sahara");
    namesMap.put("ES", "Spanje");
    namesMap.put("ET", "Ethiopië");
    namesMap.put("EU", "Europese Unie");
    namesMap.put("FK", "Falklandeilanden");
    namesMap.put("FM", "Micronesië");
    namesMap.put("FO", "Faeröer");
    namesMap.put("FR", "Frankrijk");
    namesMap.put("GB", "Verenigd Koninkrijk");
    namesMap.put("GE", "Georgië");
    namesMap.put("GF", "Frans-Guyana");
    namesMap.put("GL", "Groenland");
    namesMap.put("GN", "Guinee");
    namesMap.put("GQ", "Equatoriaal-Guinea");
    namesMap.put("GR", "Griekenland");
    namesMap.put("GS", "Zuid-Georgia en Zuidelijke Sandwicheilanden");
    namesMap.put("GW", "Guinee-Bissau");
    namesMap.put("HK", "Hongkong SAR van China");
    namesMap.put("HM", "Heard- en McDonaldeilanden");
    namesMap.put("HR", "Kroatië");
    namesMap.put("HT", "Haïti");
    namesMap.put("HU", "Hongarije");
    namesMap.put("IC", "Canarische Eilanden");
    namesMap.put("ID", "Indonesië");
    namesMap.put("IE", "Ierland");
    namesMap.put("IL", "Israël");
    namesMap.put("IO", "Britse Gebieden in de Indische Oceaan");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "IJsland");
    namesMap.put("IT", "Italië");
    namesMap.put("JO", "Jordanië");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgizië");
    namesMap.put("KH", "Cambodja");
    namesMap.put("KM", "Comoren");
    namesMap.put("KN", "Saint Kitts en Nevis");
    namesMap.put("KP", "Noord-Korea");
    namesMap.put("KR", "Zuid-Korea");
    namesMap.put("KW", "Koeweit");
    namesMap.put("KY", "Caymaneilanden");
    namesMap.put("KZ", "Kazachstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Litouwen");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Letland");
    namesMap.put("LY", "Libië");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Moldavië");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalleilanden");
    namesMap.put("MK", "Macedonië");
    namesMap.put("MM", "Myanmar (Birma)");
    namesMap.put("MN", "Mongolië");
    namesMap.put("MO", "Macao SAR van China");
    namesMap.put("MP", "Noordelijke Marianeneilanden");
    namesMap.put("MR", "Mauritanië");
    namesMap.put("MV", "Maldiven");
    namesMap.put("MY", "Maleisië");
    namesMap.put("NA", "Namibië");
    namesMap.put("NC", "Nieuw-Caledonië");
    namesMap.put("NF", "Norfolkeiland");
    namesMap.put("NL", "Nederland");
    namesMap.put("NO", "Noorwegen");
    namesMap.put("NZ", "Nieuw-Zeeland");
    namesMap.put("PF", "Frans-Polynesië");
    namesMap.put("PG", "Papoea-Nieuw-Guinea");
    namesMap.put("PH", "Filipijnen");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint-Pierre en Miquelon");
    namesMap.put("PN", "Pitcairneilanden");
    namesMap.put("PS", "Palestijnse gebieden");
    namesMap.put("QO", "Overig Oceanië");
    namesMap.put("RO", "Roemenië");
    namesMap.put("RS", "Servië");
    namesMap.put("RU", "Rusland");
    namesMap.put("SA", "Saoedi-Arabië");
    namesMap.put("SB", "Salomonseilanden");
    namesMap.put("SC", "Seychellen");
    namesMap.put("SD", "Soedan");
    namesMap.put("SE", "Zweden");
    namesMap.put("SH", "Sint-Helena");
    namesMap.put("SI", "Slovenië");
    namesMap.put("SJ", "Spitsbergen en Jan Mayen");
    namesMap.put("SK", "Slowakije");
    namesMap.put("SO", "Somalië");
    namesMap.put("SS", "Zuid-Soedan");
    namesMap.put("ST", "Sao Tomé en Principe");
    namesMap.put("SX", "Sint-Maarten");
    namesMap.put("SY", "Syrië");
    namesMap.put("TC", "Turks- en Caicoseilanden");
    namesMap.put("TD", "Tsjaad");
    namesMap.put("TF", "Franse Gebieden in de zuidelijke Indische Oceaan");
    namesMap.put("TJ", "Tadzjikistan");
    namesMap.put("TL", "Oost-Timor");
    namesMap.put("TN", "Tunesië");
    namesMap.put("TR", "Turkije");
    namesMap.put("TT", "Trinidad en Tobago");
    namesMap.put("UA", "Oekraïne");
    namesMap.put("UG", "Oeganda");
    namesMap.put("UM", "Kleine afgelegen eilanden van de Verenigde Staten");
    namesMap.put("US", "Verenigde Staten");
    namesMap.put("UZ", "Oezbekistan");
    namesMap.put("VA", "Vaticaanstad");
    namesMap.put("VC", "Saint Vincent en de Grenadines");
    namesMap.put("VG", "Britse Maagdeneilanden");
    namesMap.put("VI", "Amerikaanse Maagdeneilanden");
    namesMap.put("WF", "Wallis en Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Zuid-Afrika");
    namesMap.put("ZZ", "Onbekend gebied");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Wereld",
        "002": "Afrika",
        "003": "Noord-Amerika",
        "005": "Zuid-Amerika",
        "009": "Oceanië",
        "011": "West-Afrika",
        "013": "Midden-Amerika",
        "014": "Oost-Afrika",
        "015": "Noord-Afrika",
        "017": "Centraal-Afrika",
        "018": "Zuidelijk Afrika",
        "019": "Amerika",
        "021": "Noordelijk Amerika",
        "029": "Caribisch gebied",
        "030": "Oost-Azië",
        "034": "Zuid-Azië",
        "035": "Zuidoost-Azië",
        "039": "Zuid-Europa",
        "053": "Australazië",
        "054": "Melanesië",
        "057": "Micronesische regio",
        "061": "Polynesië",
        "142": "Azië",
        "143": "Centraal-Azië",
        "145": "West-Azië",
        "150": "Europa",
        "151": "Oost-Europa",
        "154": "Noord-Europa",
        "155": "West-Europa",
        "419": "Latijns-Amerika",
        "AC": "Ascension",
        "AE": "Verenigde Arabische Emiraten",
        "AG": "Antigua en Barbuda",
        "AL": "Albanië",
        "AM": "Armenië",
        "AN": "Nederlandse Antillen",
        "AR": "Argentinië",
        "AS": "Amerikaans Samoa",
        "AT": "Oostenrijk",
        "AU": "Australië",
        "AX": "Åland",
        "AZ": "Azerbeidzjan",
        "BA": "Bosnië en Herzegovina",
        "BE": "België",
        "BG": "Bulgarije",
        "BH": "Bahrein",
        "BQ": "Caribisch Nederland",
        "BR": "Brazilië",
        "BS": "Bahama’s",
        "BV": "Bouveteiland",
        "BY": "Wit-Rusland",
        "CC": "Cocoseilanden",
        "CD": "Congo-Kinshasa",
        "CF": "Centraal-Afrikaanse Republiek",
        "CG": "Congo-Brazzaville",
        "CH": "Zwitserland",
        "CI": "Ivoorkust",
        "CK": "Cookeilanden",
        "CL": "Chili",
        "CM": "Kameroen",
        "CP": "Clipperton",
        "CV": "Kaapverdië",
        "CX": "Christmaseiland",
        "CZ": "Tsjechië",
        "DE": "Duitsland",
        "DK": "Denemarken",
        "DO": "Dominicaanse Republiek",
        "DZ": "Algerije",
        "EA": "Ceuta en Melilla",
        "EE": "Estland",
        "EG": "Egypte",
        "EH": "Westelijke Sahara",
        "ES": "Spanje",
        "ET": "Ethiopië",
        "EU": "Europese Unie",
        "FK": "Falklandeilanden",
        "FM": "Micronesië",
        "FO": "Faeröer",
        "FR": "Frankrijk",
        "GB": "Verenigd Koninkrijk",
        "GE": "Georgië",
        "GF": "Frans-Guyana",
        "GL": "Groenland",
        "GN": "Guinee",
        "GQ": "Equatoriaal-Guinea",
        "GR": "Griekenland",
        "GS": "Zuid-Georgia en Zuidelijke Sandwicheilanden",
        "GW": "Guinee-Bissau",
        "HK": "Hongkong SAR van China",
        "HM": "Heard- en McDonaldeilanden",
        "HR": "Kroatië",
        "HT": "Haïti",
        "HU": "Hongarije",
        "IC": "Canarische Eilanden",
        "ID": "Indonesië",
        "IE": "Ierland",
        "IL": "Israël",
        "IO": "Britse Gebieden in de Indische Oceaan",
        "IQ": "Irak",
        "IS": "IJsland",
        "IT": "Italië",
        "JO": "Jordanië",
        "KE": "Kenia",
        "KG": "Kirgizië",
        "KH": "Cambodja",
        "KM": "Comoren",
        "KN": "Saint Kitts en Nevis",
        "KP": "Noord-Korea",
        "KR": "Zuid-Korea",
        "KW": "Koeweit",
        "KY": "Caymaneilanden",
        "KZ": "Kazachstan",
        "LB": "Libanon",
        "LT": "Litouwen",
        "LU": "Luxemburg",
        "LV": "Letland",
        "LY": "Libië",
        "MA": "Marokko",
        "MD": "Moldavië",
        "MF": "Saint-Martin",
        "MG": "Madagaskar",
        "MH": "Marshalleilanden",
        "MK": "Macedonië",
        "MM": "Myanmar (Birma)",
        "MN": "Mongolië",
        "MO": "Macao SAR van China",
        "MP": "Noordelijke Marianeneilanden",
        "MR": "Mauritanië",
        "MV": "Maldiven",
        "MY": "Maleisië",
        "NA": "Namibië",
        "NC": "Nieuw-Caledonië",
        "NF": "Norfolkeiland",
        "NL": "Nederland",
        "NO": "Noorwegen",
        "NZ": "Nieuw-Zeeland",
        "PF": "Frans-Polynesië",
        "PG": "Papoea-Nieuw-Guinea",
        "PH": "Filipijnen",
        "PL": "Polen",
        "PM": "Saint-Pierre en Miquelon",
        "PN": "Pitcairneilanden",
        "PS": "Palestijnse gebieden",
        "QO": "Overig Oceanië",
        "RO": "Roemenië",
        "RS": "Servië",
        "RU": "Rusland",
        "SA": "Saoedi-Arabië",
        "SB": "Salomonseilanden",
        "SC": "Seychellen",
        "SD": "Soedan",
        "SE": "Zweden",
        "SH": "Sint-Helena",
        "SI": "Slovenië",
        "SJ": "Spitsbergen en Jan Mayen",
        "SK": "Slowakije",
        "SO": "Somalië",
        "SS": "Zuid-Soedan",
        "ST": "Sao Tomé en Principe",
        "SX": "Sint-Maarten",
        "SY": "Syrië",
        "TC": "Turks- en Caicoseilanden",
        "TD": "Tsjaad",
        "TF": "Franse Gebieden in de zuidelijke Indische Oceaan",
        "TJ": "Tadzjikistan",
        "TL": "Oost-Timor",
        "TN": "Tunesië",
        "TR": "Turkije",
        "TT": "Trinidad en Tobago",
        "UA": "Oekraïne",
        "UG": "Oeganda",
        "UM": "Kleine afgelegen eilanden van de Verenigde Staten",
        "US": "Verenigde Staten",
        "UZ": "Oezbekistan",
        "VA": "Vaticaanstad",
        "VC": "Saint Vincent en de Grenadines",
        "VG": "Britse Maagdeneilanden",
        "VI": "Amerikaanse Maagdeneilanden",
        "WF": "Wallis en Futuna",
        "YE": "Jemen",
        "ZA": "Zuid-Afrika",
        "ZZ": "Onbekend gebied"
    };
  }-*/;
}
