/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.webresources.AbstractArchiveResource;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarResource
extends AbstractArchiveResource {
    private static final Log log = LogFactory.getLog(JarResource.class);

    public JarResource(AbstractArchiveResourceSet archiveResourceSet, String webAppPath, String baseUrl, JarEntry jarEntry) {
        super(archiveResourceSet, webAppPath, "jar:" + baseUrl, jarEntry, baseUrl);
    }

    @Override
    protected AbstractArchiveResource.JarInputStreamWrapper getJarInputStreamWrapper() {
        try {
            JarFile jarFile = this.getArchiveResourceSet().openJarFile();
            JarEntry jarEntry = jarFile.getJarEntry(this.getResource().getName());
            InputStream is = jarFile.getInputStream(jarEntry);
            return new AbstractArchiveResource.JarInputStreamWrapper(jarEntry, is);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("jarResource.getInputStreamFail", new Object[]{this.getResource().getName(), this.getBaseUrl()}), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

