/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.constraint;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.constraint.ConstraintList;
import org.polarsys.chess.core.constraint.IConstraint;
import org.polarsys.chess.core.constraint.SettableStatus;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.views.DiagramStatus;

public abstract class DynamicConstraint
implements IConstraint {
    private String name;
    private int severity;
    private String message;
    SettableStatus status;

    public DynamicConstraint() {
        ConstraintList.add(this);
    }

    public DynamicConstraint(String name, int severity, String messagePattern) {
        this.setName(name);
        this.setStatus(severity, messagePattern);
        ConstraintList.add(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public SettableStatus getStatus() {
        return this.status;
    }

    @Override
    public void showUserNotification() {
        switch (this.status.getSeverity()) {
            case 4: {
                ResourceNotification.showError(this.status.getMessage());
            }
        }
        ResourceNotification.showInfo(this.status.getMessage());
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatusMessage(String message) {
        this.status.setMessagePattern(message);
    }

    @Override
    public void setStatus(int severity, String messagePattern) {
        this.setSeverity(severity);
        this.setMessage(messagePattern);
        this.status = new SettableStatus(severity, "org.polarsys.chess.core", messagePattern);
    }

    public IStatus check(Notification notification, DiagramStatus.DesignView currentView, Domain theDomain) {
        this.status.setSuccess(this.checkConstraint(notification, currentView, theDomain));
        return this.status;
    }

    public IStatus check(Notification notification, Domain theDomain) {
        this.status.setSuccess(this.checkConstraint(notification, null, theDomain));
        return this.status;
    }

    @Override
    public IStatus check(Notification notification) {
        this.status.setSuccess(this.checkConstraint(notification, null, null));
        return this.status;
    }

    public abstract boolean checkConstraint(Notification var1, DiagramStatus.DesignView var2, Domain var3);
}

