/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views.permissions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class EntryId {
    public static String ANY = "*";
    public static String NONE = "-";
    public static EntryId anyEntry = new EntryId(ANY, ANY, ANY);
    String feature;
    String stereotype;
    String type;
    public static String FEATURE_ATR = "ft";
    public static String STEREOTYPE_ATR = "st";
    public static String TYPE_ATR = "el";
    private static String[] availableProfiles = new String[]{"org.polarsys.chess"};

    public EntryId(String type, String stereotype, String feature) {
        this.type = type == null ? NONE : type;
        this.stereotype = stereotype == null ? NONE : stereotype;
        this.feature = feature == null ? NONE : feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getStereotype() {
        return this.stereotype;
    }

    public String getType() {
        return this.type;
    }

    public boolean match(EntryId id) {
        return this.match(id.getType(), id.getStereotype(), id.getFeature());
    }

    public boolean match(String type, String stereotype, String feature) {
        return this.matcher(this.type, type) && this.matcher(this.stereotype, stereotype) && this.matcher(this.feature, feature);
    }

    private boolean matcher(String a, String b) {
        if (a.equals(ANY) || b.equals(ANY)) {
            return true;
        }
        return a.equalsIgnoreCase(b);
    }

    public String toString() {
        StringBuffer s = new StringBuffer(30);
        s.append('[');
        s.append(this.type == null ? NONE : this.type);
        s.append(',');
        s.append(this.stereotype == null ? NONE : this.stereotype);
        s.append(',');
        s.append(this.feature == null ? NONE : this.feature);
        s.append(']');
        return s.toString();
    }

    public static EntryId generateEntryId(Element el, Stereotype str, Feature feature) {
        String name = el == null ? null : el.eClass().getName();
        String strName = str == null ? null : str.getName();
        String ftName = feature == null ? null : feature.getName();
        return new EntryId(name, strName, ftName);
    }

    public static ArrayList<EntryId> computeStereotypeEntryIds(Object el, Object ft, Object st) {
        ArrayList<EntryId> ids = new ArrayList<EntryId>();
        String name = NONE;
        String strName = NONE;
        String ftName = NONE;
        if (st instanceof EObject) {
            strName = ((EObject)st).eClass().getName();
            ftName = EntryId.getFeatureName(ft);
            ids.add(new EntryId(name, strName, ftName));
        }
        return ids;
    }

    public static ArrayList<EntryId> computeEntryIds(Object el, Object ft) {
        ArrayList<EntryId> ids = new ArrayList<EntryId>();
        String name = NONE;
        String strName = NONE;
        String ftName = NONE;
        if (el instanceof DynamicEObjectImpl) {
            strName = UMLUtil.getStereotype((EObject)((DynamicEObjectImpl)el)).getName();
            Element baseEl = UMLUtil.getBaseElement((EObject)((DynamicEObjectImpl)el));
            String string = name = baseEl == null ? null : baseEl.eClass().getName();
            if (ft instanceof EAttribute) {
                ftName = ((EAttribute)ft).getName();
            }
            ids.add(new EntryId(name, strName, ftName));
        } else if (el instanceof Classifier) {
            name = ((Classifier)el).eClass().getName();
            ftName = EntryId.getFeatureName(ft);
            ids.add(new EntryId(name, NONE, ftName));
        } else if (el instanceof Package) {
            name = ((Package)el).eClass().getName();
            ids.add(new EntryId(name, NONE, EntryId.getFeatureName(ft)));
        } else if (el instanceof Feature) {
            EObject cont = ((Feature)el).eContainer();
            name = null;
            ftName = ((Feature)el).eClass().getName();
            if (cont != null && cont instanceof Element) {
                name = cont.eClass().getName();
            }
            ids.add(new EntryId(name, NONE, ftName));
        } else if (el instanceof Comment) {
            name = ((Comment)el).eClass().getName();
            ids.add(new EntryId(name, NONE, NONE));
        } else if (el instanceof Relationship) {
            name = ((Relationship)el).eClass().getName();
            ids.add(new EntryId(name, NONE, NONE));
        } else if (el instanceof InstanceSpecification) {
            name = ((InstanceSpecification)el).eClass().getName();
            ids.add(new EntryId(name, NONE, NONE));
        } else if (el instanceof Region) {
            name = ((Region)el).eClass().getName();
            ids.add(new EntryId(name, NONE, NONE));
        } else if (el instanceof Element) {
            name = ((Element)el).eClass().getName();
            ids.add(new EntryId(name, NONE, NONE));
        }
        return ids;
    }

    private static String getFeatureName(Object ft) {
        if (ft instanceof Element) {
            return ((Feature)ft).getName();
        }
        if (ft instanceof EStructuralFeature) {
            return ((EStructuralFeature)ft).getName();
        }
        return NONE;
    }

    public static ArrayList<EntryId> computeEntryIds_(Object el, Object ft) {
        ArrayList<EntryId> ids = new ArrayList<EntryId>();
        String name = NONE;
        String strName = NONE;
        String ftName = NONE;
        if (el instanceof DynamicEObjectImpl) {
            strName = UMLUtil.getStereotype((EObject)((DynamicEObjectImpl)el)).getName();
            Element baseEl = UMLUtil.getBaseElement((EObject)((DynamicEObjectImpl)el));
            String string = name = baseEl == null ? null : baseEl.eClass().getName();
            if (ft instanceof EAttribute) {
                ftName = ((EAttribute)ft).getName();
            }
            ids.add(new EntryId(name, strName, ftName));
        } else if (el instanceof Classifier) {
            name = ((Classifier)el).eClass().getName();
            ftName = EntryId.getFeatureName(ft);
            EList ss = ((Element)el).getAppliedStereotypes();
            if (ss.isEmpty()) {
                ids.add(new EntryId(name, NONE, ftName));
            } else {
                for (Stereotype str : ((Element)el).getAppliedStereotypes()) {
                    ids.add(new EntryId(name, str.getName(), ftName));
                }
            }
        } else if (el instanceof Element && !(el instanceof ProfileApplication)) {
            name = ((Element)el).eClass().getName();
            ftName = EntryId.getFeatureName(ft);
            EList ss = ((Element)el).getAppliedStereotypes();
            if (ss.isEmpty()) {
                ids.add(new EntryId(name, NONE, ftName));
            } else {
                for (Stereotype str : ((Element)el).getAppliedStereotypes()) {
                    ids.add(new EntryId(name, str.getName(), ftName));
                }
            }
        } else if (el instanceof EObject && EntryId.isInSupportedProfiles((EObject)el)) {
            EObject e = (EObject)el;
            ids.add(new EntryId(NONE, e.eClass().getName(), EntryId.getFeatureName(ft)));
        }
        return ids;
    }

    public boolean isANY() {
        return this.type.equals(ANY) && this.stereotype.equals(ANY) && this.feature.equals(ANY);
    }

    private static boolean isInSupportedProfiles(EObject el) {
        int i = 0;
        while (i < availableProfiles.length) {
            if (el.getClass().getPackage().getName().startsWith(availableProfiles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof EntryId) {
            EntryId ei = (EntryId)arg0;
            return ei.getType().equals(this.getType()) && ei.getFeature().equals(this.getFeature()) && ei.getStereotype().equals(this.getStereotype());
        }
        return false;
    }
}

