/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.CompositeComponent;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.Port;
import org.polarsys.chess.fla.flamm.PortFailureTuple;
import org.polarsys.chess.fla.flamm.Rule;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;

public class SimpleComponent
extends Component {
    protected EList<Rule> rules;
    List<Set<PortFailureTuple>> propagatedInputPortFailures = null;

    @Override
    protected EClass eStaticClass() {
        return FlammPackage.Literals.SIMPLE_COMPONENT;
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new BasicInternalEList(Rule.class);
        }
        return this.rules;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getInputPorts()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOutputPorts()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return this.basicSetParent(null, msgs);
            }
            case 5: {
                return ((InternalEList)this.getRules()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    private List<Set<PortFailureTuple>> getPropagatedInputPortFailures() {
        if (this.propagatedInputPortFailures == null) {
            this.propagatedInputPortFailures = new ArrayList<Set<PortFailureTuple>>();
            int i = 0;
            while (i < this.getInputPorts().size()) {
                this.propagatedInputPortFailures.add(new HashSet());
                ++i;
            }
        }
        return this.propagatedInputPortFailures;
    }

    @Override
    public void propagateFailures() {
        this.propagateInputFailures();
        this.propagateOutputFailures();
    }

    void propagateInputFailures() {
        int i = 0;
        while (i < this.inputPorts.size()) {
            Port port = (Port)((Object)this.inputPorts.get(i));
            Set<PortFailureTuple> newPortFailures = PortFailureTuple.fromCollection(port, port.getNewFailures());
            Set<PortFailureTuple> oldPortFailures = this.getPropagatedInputPortFailures().get(i);
            this.propagatedInputPortFailures.set(i, newPortFailures);
            Set<List<PortFailureTuple>> newFailureCombinations = this.getNewInputFailureCombinations(this.propagatedInputPortFailures);
            for (List<PortFailureTuple> portFailureCombination : newFailureCombinations) {
                this.propagateFailureCombination(portFailureCombination);
            }
            port.clearNewFailures();
            this.propagatedInputPortFailures.set(i, (Set<PortFailureTuple>)Sets.union(oldPortFailures, newPortFailures));
            ++i;
        }
    }

    protected void propagateOutputFailures() {
        for (Port port : this.outputPorts) {
            for (Failure failure : port.getNewFailures()) {
                for (Port connectedPort : port.getConnectedPorts()) {
                    if (!connectedPort.addFailure(failure, failure)) continue;
                    FlaSystem.addUpdatedComponent(connectedPort.getOwner());
                }
            }
            port.clearNewFailures();
        }
    }

    Set<List<PortFailureTuple>> getNewInputFailureCombinations(List<Set<PortFailureTuple>> failures) {
        Set failureCombinations = Sets.cartesianProduct(failures);
        return failureCombinations;
    }

    void propagateFailureCombination(List<PortFailureTuple> failuresetToMatch) {
        List<Rule> rules = this.getMostSpecificMatchingRules(failuresetToMatch);
        if (rules != null && !rules.isEmpty()) {
            List<Failure> previousFailures = this.portfailuresToFailureList(failuresetToMatch);
            for (Rule rule : rules) {
                rule.fire(previousFailures);
            }
        } else {
            this.HandleUnmatchedFailureCombination(failuresetToMatch);
        }
    }

    List<Failure> portfailuresToFailureList(List<PortFailureTuple> failureSet) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (PortFailureTuple portFailure : failureSet) {
            failures.add(portFailure.getFailure());
        }
        return failures;
    }

    protected void HandleUnmatchedFailureCombination(List<PortFailureTuple> failuresetToMatch) {
        if (FlaSystem.propagateUnmatchedFailures()) {
            for (Port port : this.outputPorts) {
                for (PortFailureTuple portFailure : failuresetToMatch) {
                    port.addFailure(portFailure.getFailure(), portFailure.getFailure());
                }
            }
        } else {
            this.log("Unmatched failure set: " + failuresetToMatch);
        }
    }

    List<Rule> getMostSpecificMatchingRules(List<PortFailureTuple> failuresetToMatch) {
        List<Rule> matchingRules = this.getAllMatchingRules(failuresetToMatch);
        if (matchingRules == null || matchingRules.isEmpty()) {
            return null;
        }
        int highestSpecificity = matchingRules.get(0).getSpecificity();
        for (Rule matchingRule : matchingRules) {
            if (matchingRule.getSpecificity() <= highestSpecificity) continue;
            highestSpecificity = matchingRule.getSpecificity();
        }
        ArrayList<Rule> mostSpecificRules = new ArrayList<Rule>();
        for (Rule matchingRule : matchingRules) {
            if (matchingRule.getSpecificity() != highestSpecificity) continue;
            mostSpecificRules.add(matchingRule);
        }
        return mostSpecificRules;
    }

    List<Rule> getAllMatchingRules(List<PortFailureTuple> failuresetToMatch) {
        ArrayList<Rule> matchingRules = new ArrayList<Rule>();
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                if (!rule.matchFailure(failuresetToMatch)) continue;
                matchingRules.add(rule);
            }
        }
        return matchingRules;
    }

    protected void log(String message) {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInputPorts();
            }
            case 3: {
                return this.getOutputPorts();
            }
            case 4: {
                return this.getParent();
            }
            case 5: {
                return this.getRules();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getInputPorts().clear();
                this.getInputPorts().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOutputPorts().clear();
                this.getOutputPorts().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setParent((CompositeComponent)newValue);
                return;
            }
            case 5: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getInputPorts().clear();
                return;
            }
            case 3: {
                this.getOutputPorts().clear();
                return;
            }
            case 4: {
                this.setParent(null);
                return;
            }
            case 5: {
                this.getRules().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.inputPorts != null && !this.inputPorts.isEmpty();
            }
            case 3: {
                return this.outputPorts != null && !this.outputPorts.isEmpty();
            }
            case 4: {
                return this.getParent() != null;
            }
            case 5: {
                return this.rules != null && !this.rules.isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }
}

