/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.util.uml;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.internal.impl.DependencyImpl;
import org.polarsys.chess.core.views.ViewUtils;

public class UMLUtils {
    public static String getElementID(Element el) {
        Resource resource = el.eResource();
        if (resource != null) {
            return resource.getURIFragment((EObject)el);
        }
        return null;
    }

    public static boolean hasPublicVisibility(Operation operation) {
        return operation.getVisibility().getValue() == 0;
    }

    public static boolean areParametersEqual(Parameter param, Parameter aux) {
        if (!param.getName().equals(aux.getName())) {
            return false;
        }
        if (param.getDirection().getValue() != aux.getDirection().getValue()) {
            return false;
        }
        if (param.getVisibility().getValue() != aux.getVisibility().getValue()) {
            return false;
        }
        if (param.isException() != aux.isException()) {
            return false;
        }
        if (param.isMultivalued() != aux.isMultivalued()) {
            return false;
        }
        if (param.isOrdered() != aux.isOrdered()) {
            return false;
        }
        if (param.isSetDefault() != aux.isSetDefault()) {
            return false;
        }
        if (param.isUnique() != aux.isUnique()) {
            return false;
        }
        if (param.isStream() != aux.isStream()) {
            return false;
        }
        if (param.getEffect().getValue() != aux.getEffect().getValue()) {
            return false;
        }
        if (param.lowerBound() != aux.lowerBound()) {
            return false;
        }
        return param.upperBound() == aux.upperBound();
    }

    public static void copyOperation(Operation source, Operation target) {
        for (Parameter param : source.getOwnedParameters()) {
            Parameter p = target.createOwnedParameter(param.getName(), param.getType());
            p.setDirection(param.getDirection());
            p.setEffect(param.getEffect());
            p.setDefaultValue(param.getDefaultValue());
            p.setDefault(param.getDefault());
            p.setIsException(param.isException());
            p.setIsOrdered(param.isOrdered());
            p.setIsStream(param.isStream());
            p.setIsUnique(param.isUnique());
            p.setLower(param.getLower());
            p.setLowerValue(param.getLowerValue());
            p.setTemplateParameter(param.getTemplateParameter());
            p.setUpper(param.getUpper());
            p.setUpperValue(param.getUpperValue());
            p.setVisibility(param.getVisibility());
        }
        target.setVisibility(source.getVisibility());
        target.setConcurrency(source.getConcurrency());
        target.setIsQuery(source.isQuery());
        target.setIsLeaf(source.isLeaf());
        target.setIsStatic(source.isStatic());
    }

    public static boolean areOperationsEqual(Operation source, Operation target, Parameter p) {
        if (!source.getName().equalsIgnoreCase(target.getName())) {
            return false;
        }
        EList targetList = target.getOwnedParameters();
        EList sourceList = source.getOwnedParameters();
        if (p == null ? targetList.size() != sourceList.size() : targetList.size() + 1 != sourceList.size()) {
            return false;
        }
        if (source.getVisibility().getValue() != target.getVisibility().getValue()) {
            return false;
        }
        if (source.isQuery() != target.isQuery()) {
            return false;
        }
        if (source.isLeaf() != target.isLeaf()) {
            return false;
        }
        if (source.isStatic() != target.isStatic()) {
            return false;
        }
        if (source.getConcurrency().getValue() != target.getConcurrency().getValue()) {
            return false;
        }
        int i = 0;
        while (i < targetList.size()) {
            Parameter param = (Parameter)targetList.get(i);
            Parameter aux = source.getOwnedParameter(param.getName(), param.getType());
            if (aux == null) {
                return false;
            }
            if (param != null && aux != null && !UMLUtils.areParametersEqual(param, aux)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areParametersEquals(Operation source, Operation target, Parameter p) {
        EList targetList = target.getOwnedParameters();
        if (targetList.size() != source.getOwnedParameters().size()) {
            return false;
        }
        for (Parameter param : targetList) {
            if (p != null && p.getName().equalsIgnoreCase(param.getName())) continue;
            Parameter aux = source.getOwnedParameter(param.getName(), param.getType());
            if (aux == null) {
                return false;
            }
            if (UMLUtils.areParametersEqual(param, aux)) continue;
            return false;
        }
        return true;
    }

    public static boolean areParametersEquals(Operation source, Operation target) {
        return UMLUtils.areParametersEquals(source, target, null);
    }

    public static boolean isOperationEquals(Operation source, Operation target) {
        return UMLUtils.areOperationsEqual(source, target, null);
    }

    public static boolean isOperationContained(Classifier component, Operation operation) {
        for (Operation op : component.getOperations()) {
            if (!op.getName().equals(operation.getName()) || !UMLUtils.isOperationEquals(op, operation)) continue;
            return true;
        }
        return false;
    }

    public static EList<NamedElement> getInterfaceClients(Interface interfce) {
        BasicEList relationships = new BasicEList();
        for (Relationship rel : interfce.getRelationships()) {
            if (!(rel instanceof InterfaceRealization)) continue;
            InterfaceRealization intRel = (InterfaceRealization)rel;
            relationships.addAll((Collection)intRel.getClients());
        }
        return relationships;
    }

    public static EList<Component> getComponentImplementations(Component comp) {
        BasicEList list = new BasicEList();
        EList<Component> compImpls = UMLUtils.retrieveComponentImplementations(ViewUtils.getView((EObject)comp));
        for (Component el : compImpls) {
            for (Dependency dep : el.getClientDependencies()) {
                if (!(dep instanceof Realization) || dep.getSupplier(comp.getName()) == null) continue;
                list.add((Object)el);
            }
        }
        return list;
    }

    private static EList<Component> retrieveComponentImplementations(Package pkg) {
        BasicEList comps = new BasicEList();
        for (Element el : pkg.getOwnedElements()) {
            EList<Component> list;
            if (el instanceof Component && UMLUtils.isComponentImplementation(el)) {
                comps.add((Object)((Component)el));
            }
            if (!(el instanceof Package) || (list = UMLUtils.retrieveComponentImplementations((Package)el)).isEmpty()) continue;
            comps.addAll(list);
        }
        return comps;
    }

    public static boolean isComponentType(Object el) {
        return el instanceof Component && ((Element)el).getAppliedStereotype("CHESS::ComponentModel::ComponentType") != null;
    }

    public static boolean isComponentImplementation(Object el) {
        return el instanceof Component && ((Element)el).getAppliedStereotype("CHESS::ComponentModel::ComponentImplementation") != null;
    }

    public static EList<ClientServerPort> getComponentClientServerPorts(Component component) {
        BasicEList ports = new BasicEList();
        for (Element e : component.getOwnedElements()) {
            if (!(e instanceof Port)) continue;
            Port p = (Port)e;
            for (EObject st : p.getStereotypeApplications()) {
                if (!(st instanceof ClientServerPort)) continue;
                ClientServerPort csp = (ClientServerPort)st;
                ports.add((Object)csp);
            }
        }
        return ports;
    }

    public static EList<Dependency> computeDependenciesToRemove(Component comp) {
        EList cDependencies = comp.getClientDependencies();
        BasicEList cDependentInterfaces = new BasicEList();
        HashMap<Interface, Dependency> cDependenciesToRemoveMap = new HashMap<Interface, Dependency>();
        for (Dependency dependency : cDependencies) {
            if (!dependency.getClass().equals(DependencyImpl.class)) continue;
            for (NamedElement el : dependency.getSuppliers()) {
                if (!(el instanceof Interface)) continue;
                cDependentInterfaces.add((Object)((Interface)el));
                cDependenciesToRemoveMap.put((Interface)el, dependency);
            }
        }
        EList<ClientServerPort> ports = UMLUtils.getComponentClientServerPorts(comp);
        BasicEList portInts = new BasicEList();
        for (ClientServerPort csp : ports) {
            if (csp.getKind() != ClientServerKind.REQUIRED && csp.getKind() != ClientServerKind.PROREQ) continue;
            portInts.addAll((Collection)csp.getReqInterface());
        }
        if (portInts != null) {
            cDependentInterfaces.removeAll((Collection)portInts);
        }
        BasicEList cDependenciesToRemove = new BasicEList();
        for (Interface el : cDependentInterfaces) {
            Dependency dep = (Dependency)cDependenciesToRemoveMap.get(el);
            if (dep == null) continue;
            cDependenciesToRemove.add((Object)dep);
        }
        return cDependenciesToRemove;
    }

    public static EList<InterfaceRealization> computeRealizationsToRemove(Component comp) {
        EList cRealizations = comp.getInterfaceRealizations();
        BasicEList cRealizedInterfaces = new BasicEList();
        HashMap<Interface, InterfaceRealization> cRealizationsToRemoveMap = new HashMap<Interface, InterfaceRealization>();
        for (InterfaceRealization ir : cRealizations) {
            cRealizedInterfaces.add((Object)ir.getContract());
            cRealizationsToRemoveMap.put(ir.getContract(), ir);
        }
        EList<ClientServerPort> ports = UMLUtils.getComponentClientServerPorts(comp);
        BasicEList portInts = new BasicEList();
        for (ClientServerPort csp : ports) {
            if (csp.getKind() != ClientServerKind.PROVIDED && csp.getKind() != ClientServerKind.PROREQ) continue;
            portInts.addAll((Collection)csp.getProvInterface());
        }
        if (portInts != null) {
            cRealizedInterfaces.removeAll((Collection)portInts);
        }
        BasicEList cRealizationsToRemove = new BasicEList();
        for (Interface el : cRealizedInterfaces) {
            InterfaceRealization dep = (InterfaceRealization)cRealizationsToRemoveMap.get(el);
            if (dep == null) continue;
            cRealizationsToRemove.add((Object)dep);
        }
        return cRealizationsToRemove;
    }

    public static boolean isClientServerPort(Object el) {
        return el instanceof Port && ((Element)el).getAppliedStereotype("MARTE::MARTE_DesignModel::GCM::ClientServerPort") != null;
    }

    public static Stereotype getCHRtSpecification(Object el) {
        if (el instanceof Comment) {
            return ((Element)el).getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification");
        }
        return null;
    }

    public static EList<Comment> getCHRtSpecificationComments(Package pkg, Port portFilter) {
        BasicEList chrtspecs = new BasicEList();
        for (Element el : pkg.getOwnedElements()) {
            if (!(el instanceof Component)) continue;
            for (Comment comm : el.getOwnedComments()) {
                Stereotype chrtspecification = UMLUtils.getCHRtSpecification(comm);
                if (chrtspecification == null) continue;
                if (portFilter != null) {
                    if (comm.getValue(chrtspecification, "partWithPort") == null || !comm.getValue(chrtspecification, "partWithPort").equals(portFilter)) continue;
                    chrtspecs.add((Object)comm);
                    continue;
                }
                chrtspecs.add((Object)comm);
            }
        }
        return chrtspecs;
    }

    public static <T extends EObject> T getStereotypeApplication(Element element, Class<T> stereotypeClass) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!stereotypeClass.isInstance(stereoApplication)) continue;
            return (T)stereoApplication;
        }
        return null;
    }

    public static EList<Component> getAllInterfaceComponents(Interface interfce) {
        BasicEList list = new BasicEList();
        for (NamedElement el : UMLUtils.getInterfaceClients(interfce)) {
            if (!(el instanceof Component) || !UMLUtils.isComponentType(el)) continue;
            list.add((Object)((Component)el));
            EList<Component> compList = UMLUtils.getComponentImplementations((Component)el);
            if (compList.isEmpty()) continue;
            list.addAll(compList);
        }
        return list;
    }

    public static Stereotype getStereotype(Element element, String qualifiedName) {
        Stereotype str = element.getApplicableStereotype(qualifiedName);
        return str;
    }

    public static Stereotype applyStereotype(Element element, String qualifiedName) {
        Stereotype str = UMLUtils.getStereotype(element, qualifiedName);
        if (str != null) {
            element.applyStereotype(str);
        }
        return str;
    }
}

