/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.GQAM.GaAnalysisContext;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinementAnalysisContext;

public class SelectOcraAnalysisCtxDialog
extends Dialog {
    private static final String REFANALYSIS = "CHESSContract::ContractRefinementAnalysisContext";
    private Combo chooseAnalysisCtxField;
    private StyledText rootSystemText;
    private Model model;
    private String system;
    private Boolean checkAllWeakContracts;
    private List<ContractRefinementAnalysisContext> contextList;
    private ModifyListener modAnalysisCtxListener;

    public SelectOcraAnalysisCtxDialog(Shell shell, Model model) {
        super(shell);
        this.model = model;
        this.modAnalysisCtxListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String selectedCtx = SelectOcraAnalysisCtxDialog.this.chooseAnalysisCtxField.getText();
                for (ContractRefinementAnalysisContext ctx : SelectOcraAnalysisCtxDialog.this.contextList) {
                    if (!ctx.getBase_NamedElement().getQualifiedName().equals(selectedCtx)) continue;
                    CHGaResourcePlatform plat = (CHGaResourcePlatform)ctx.getPlatform().get(0);
                    SelectOcraAnalysisCtxDialog.this.rootSystemText.setText(plat.getBase_Classifier().getQualifiedName());
                    SelectOcraAnalysisCtxDialog.this.checkAllWeakContracts = ctx.isCheckAllWeakContracts();
                }
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText("Analysis contexts found in model:");
        GridData gridData = new GridData(768);
        this.chooseAnalysisCtxField = new Combo(parent, 12);
        this.contextList = this.getAnalysisContexts(this.model);
        for (GaAnalysisContext gaAnalysisContext : this.contextList) {
            if (gaAnalysisContext.getPlatform().size() <= 0) continue;
            this.chooseAnalysisCtxField.add(gaAnalysisContext.getBase_NamedElement().getQualifiedName());
        }
        this.chooseAnalysisCtxField.addModifyListener(this.modAnalysisCtxListener);
        this.chooseAnalysisCtxField.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("Root element:");
        gridData = new GridData(768);
        this.rootSystemText = new StyledText(parent, 2060);
        this.rootSystemText.setText("");
        this.rootSystemText.setLayoutData((Object)gridData);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Analysis Context for Contracts Refinement Analysis");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSystem(this.rootSystemText.getText());
        super.okPressed();
    }

    public String getSystem() {
        return this.system;
    }

    public Boolean getCheckWeakContracts() {
        return this.checkAllWeakContracts;
    }

    private void setSystem(String system) {
        this.system = system;
    }

    private List<ContractRefinementAnalysisContext> getAnalysisContexts(Model model) {
        ArrayList<ContractRefinementAnalysisContext> result = new ArrayList<ContractRefinementAnalysisContext>();
        for (Element elem : model.allOwnedElements()) {
            Stereotype stereo = elem.getAppliedStereotype(REFANALYSIS);
            if (stereo == null) continue;
            result.add((ContractRefinementAnalysisContext)elem.getStereotypeApplication(stereo));
        }
        return result;
    }
}

