/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.verificationService.ui.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.core.utils.FileNamesUtil;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ContractRefinementCommand
extends AbstractJobCommand {
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private Class umlSelectedComponent;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private Resource umlSelectedResource;
    private int timeSpecification;
    private boolean isAsyncCommunication;
    private boolean showPopups;
    private boolean usexTextValidation;
    private String ossFilepath;
    private String resultFilePath;
    private boolean commandExecuted;

    public ContractRefinementCommand() {
        super("Contract Refinement");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        try {
            this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            this.umlSelectedComponent = this.analysisResultUtil.getSystemComponentFromEvent(event);
        }
        this.umlSelectedResource = this.umlSelectedComponent.eResource();
        this.timeSpecification = MessageTimeModelDialog.openQuestion((boolean)false);
        this.isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
        this.showPopups = false;
        this.usexTextValidation = true;
        this.ossFilepath = this.ocraDirectoryUtil.getOSSDirPath();
        this.resultFilePath = FileNamesUtil.getInstance().computeContractRefinementFileName(this.umlSelectedComponent);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
        if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
            SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
            dialog.open();
            if (dialog.goAhead()) {
                this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
                String configurationName = ChessSystemModel.getInstance().getInstantiatedArchitectureConfigurationName((Object)this.selectedInstantiatedArchitectureConfiguration);
                this.resultFilePath = this.ocraDirectoryUtil.getCommandCheckRefinementResultPath(configurationName);
            }
        }
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        this.commandExecuted = this.ocraExecService.executeCheckContractRefinement((Object)this.umlSelectedComponent, (Object)this.selectedInstantiatedArchitectureConfiguration, this.umlSelectedResource, this.timeSpecification, this.isAsyncCommunication, this.usexTextValidation, this.showPopups, this.ossFilepath, this.resultFilePath, monitor, true);
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        if (this.commandExecuted) {
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.CONTRACT_REFINEMENT_ANALYSIS, ECollections.emptyEList(), this.resultFilePath, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, null);
            this.analysisResultUtil.showResult("ocra_check_refinement", this.resultFilePath);
        }
    }
}

