/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.verificationService.ui.commands;

import eu.fbk.eclipse.standardTools.KratosExecService.ui.services.KratosExecService;
import eu.fbk.eclipse.standardTools.KratosExecService.ui.utils.KratosDirectoryUtil;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToSmv.ui.services.K2ExportServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.model.UMLStateMachineModel;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ModelCheckingKratosCommand
extends AbstractJobCommand {
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private K2ExportServiceUI k2ExportService = K2ExportServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance(), (AbstractStateMachineModel)UMLStateMachineModel.getInstance());
    private KratosDirectoryUtil kratosDirectoryUtil = KratosDirectoryUtil.getInstance();
    private KratosExecService kratosExecService = KratosExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private AnalysisResultUtil analysisResultUtil = AnalysisResultUtil.getInstance();
    private EList<String> conditions;
    private String k2Directory;
    private String fileWithPropertyPath;
    private String propertyFilePath;
    private String resultFilePath;
    private boolean showPopups;
    private Class umlSelectedComponent;
    private boolean commandExecuted;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private List<AnalysisContextElement> contextList;

    public ModelCheckingKratosCommand() {
        super("Check Software Model Command");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        this.k2Directory = this.kratosDirectoryUtil.getK2DirPath();
        this.showPopups = false;
        this.fileWithPropertyPath = this.kratosDirectoryUtil.getCommandInjectPropertyIntoModelResultPath(this.umlSelectedComponent.getName());
        this.resultFilePath = this.kratosDirectoryUtil.getCommandCheckModelCommandResultPath(this.umlSelectedComponent.getName());
        this.propertyFilePath = this.kratosDirectoryUtil.getCommandInjectPropertyIntoModelPropertyFile();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
        if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
            SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
            dialog.open();
            if (dialog.goAhead()) {
                this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
            }
        }
        PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
        Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
        Model model = ResourceUtils.getModel((Resource)res);
        this.contextList = AnalysisResultUtil.getInstance().getAnalysisContexts(this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, Analysis.MODEL_CHECKING_ANALYSIS, model);
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        String[] expression = new String[1];
        String filePath = this.k2ExportService.exportSingleBlock((Object)this.umlSelectedComponent, this.showPopups, this.umlSelectedComponent.getName(), this.k2Directory, monitor);
        this.commandExecuted = this.kratosExecService.executeModelChecking(filePath, this.fileWithPropertyPath, this.propertyFilePath, this.resultFilePath, false, true, expression, this.contextList);
        if (this.commandExecuted) {
            this.conditions = this.createConditions(expression[0].split("#"));
        }
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
        if (this.commandExecuted) {
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.MODEL_CHECKING_ANALYSIS, this.conditions, this.resultFilePath, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, null);
            this.analysisResultUtil.showResult("kratos_check_software_model", this.resultFilePath);
        }
    }

    private EList<String> createConditions(String[] expression) {
        BasicEList conditions = new BasicEList();
        StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"check_type", (String)"ltl_spec_kratos");
        if (expression != null) {
            StringArrayUtil.addConditionKeyValue((EList)conditions, (String)"property", (String)expression[0]);
        }
        return conditions;
    }
}

