/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.polarsys.chess.core.util.CHESSProjectSupport;

public class InternalConsoleUtil {
    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static MessageConsoleStream findCHESSconsole() {
        MessageConsole myConsole = InternalConsoleUtil.findConsole(CHESSProjectSupport.CHESS_CONSOLE_NAME);
        return myConsole.newMessageStream();
    }

    public static void writeLog(String message) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(String.valueOf(InternalConsoleUtil.getEclipseInstallLocation()) + "CHESSLOG");
        PrintStream p = new PrintStream(out);
        p.println(message);
        p.close();
    }

    public static String getEclipseInstallLocation() {
        if (System.getProperty("os.name").equals("Linux")) {
            return System.getProperties().get("osgi.install.area").toString().substring(5);
        }
        return System.getProperties().get("osgi.install.area").toString().substring(6);
    }
}

