/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagram.ui.commands;

import eu.fbk.eclipse.standardtools.diagram.ui.dialog.ModelToDocumentDialog;
import eu.fbk.eclipse.standardtools.diagram.ui.docGenerators.DocumentGeneratorService;
import eu.fbk.eclipse.standardtools.diagram.ui.model.AbstractInternalBlockDiagramModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractAsyncJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.polarsys.chess.diagram.ui.commands.ExportComponentToImageCommand;
import org.polarsys.chess.diagram.ui.docGenerators.CHESSInternalBlockDiagramModel;
import org.polarsys.chess.diagram.ui.utils.ExportDialogUtils;
import org.polarsys.chess.service.gui.utils.DialogUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ExportModelToDocumentCommand
extends AbstractAsyncJobCommand {
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private DirectoryUtil directoryUtils = DirectoryUtil.getInstance();
    private ExportDialogUtils exportDialogUtils = ExportDialogUtils.getInstance();
    private DialogUtils dialogUtils = DialogUtils.getInstance();
    private DocumentGeneratorService documentGeneratorService = DocumentGeneratorService.getInstance((AbstractInternalBlockDiagramModel)CHESSInternalBlockDiagramModel.getInstance());
    private static final Logger logger = Logger.getLogger(ExportComponentToImageCommand.class);

    public ExportModelToDocumentCommand() {
        super("Export Model To Document");
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        GraphicalEditPart selectedGraphicalComponent = this.selectionUtil.getSelectedGraphicalObject(event);
        if (selectedGraphicalComponent != null) {
            String outputDirectoryName;
            logger.debug((Object)("selectedGraphicalComponent: " + selectedGraphicalComponent));
            ModelToDocumentDialog parameterDialog = this.exportDialogUtils.getCompiledModelToDocumentDialog();
            if (!parameterDialog.goAhead()) {
                return;
            }
            String docFormat = parameterDialog.getDocumentFormat();
            String imageExtension = ".svg";
            if (docFormat.equals("tex")) {
                imageExtension = ".png";
            }
            if ((outputDirectoryName = this.dialogUtils.getDirectoryNameFromDialog()) == null || outputDirectoryName.isEmpty()) {
                return;
            }
            String currentProjectName = this.directoryUtils.getCurrentProjectName();
            this.documentGeneratorService.setParametersBeforeDocumentGeneration(parameterDialog.getShowPortLabels(), parameterDialog.getAutomaticPortLabelLayout(), outputDirectoryName, imageExtension, parameterDialog.getShowLeafComponents());
            this.documentGeneratorService.createDocumentFile(currentProjectName, docFormat, (Object)selectedGraphicalComponent, monitor);
            this.exportDialogUtils.showMessage_ExportDone(outputDirectoryName);
        }
    }
}

