/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.commands;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.diagramsCreator.actions.ShowIBDElementsAction;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class CreateIBDMultipleHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = "Multiple IBD creator";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        Object umlObject = SelectionUtil.getInstance().getUmlSelectedObject((Object)selection);
        ShowIBDElementsAction action = new ShowIBDElementsAction();
        EntityUtil entityUtil = EntityUtil.getInstance();
        ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
        if (entityUtil.isSystemViewPackage((Element)umlObject)) {
            Package pkg = (Package)umlObject;
            EList packageChildren = pkg.getOwnedElements();
            for (Element element : packageChildren) {
                if (!entityUtil.isBlock(element) || contractEntityUtil.isContract(element)) continue;
                try {
                    Diagram diagram = action.addIBD((Class)element);
                    action.populateDiagram(diagram, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            DialogUtil.getInstance().showMessage_GenericMessage(DIALOG_TITLE, "Please select a package from <<SystemView>>");
        }
        return null;
    }
}

