/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Operation;
import org.polarsys.chess.core.util.AnalysisResultData;
import org.polarsys.chess.core.util.HWAnalysisResultData;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class CompareSchedResultDialog
extends Dialog {
    private Shell shell;
    private String result;
    private String analysisContextName1;
    private String analysisContextName2;
    private List<AnalysisResultData> resultData1;
    private List<AnalysisResultData> resultData2;
    private List<HWAnalysisResultData> resultHWData1;
    private List<HWAnalysisResultData> resultHWData2;
    private String title;
    private Map<String, AnalysisResultData> resultMap1;
    private Map<String, AnalysisResultData> resultMap2;

    public CompareSchedResultDialog(Shell parentShell, String analysisContextName1, String analysisContextName2, List<AnalysisResultData> analysisResData1, List<AnalysisResultData> analysisResData2, List<HWAnalysisResultData> listHWData1, List<HWAnalysisResultData> listHWData2, String title) {
        super(parentShell);
        String theInstanceKey;
        this.shell = parentShell;
        this.analysisContextName1 = analysisContextName1;
        this.analysisContextName2 = analysisContextName2;
        this.resultData1 = analysisResData1;
        this.resultData2 = analysisResData2;
        this.resultHWData1 = listHWData1;
        this.resultHWData2 = listHWData2;
        this.title = title;
        HashMap<String, AnalysisResultData> resultMap1 = new HashMap<String, AnalysisResultData>();
        HashMap<String, AnalysisResultData> resultMap2 = new HashMap<String, AnalysisResultData>();
        for (AnalysisResultData theResult : analysisResData1) {
            theInstanceKey = theResult.instance;
            resultMap1.put(theInstanceKey, theResult);
        }
        this.resultMap1 = resultMap1;
        for (AnalysisResultData theResult : analysisResData2) {
            theInstanceKey = theResult.instance;
            resultMap2.put(theInstanceKey, theResult);
        }
        this.resultMap2 = resultMap2;
    }

    protected Control createDialogArea(Composite parent) {
        String theHwResult;
        String theHwInstance;
        int i;
        TableItem hwItem;
        String theHwUtilizationPerc;
        String theHwUtilization;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        Display display = this.shell.getDisplay();
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        Label resultLabel = new Label(parent, 0);
        resultLabel.setFont(new Font((Device)display, "Tahoma", 14, 1));
        if (this.result != null) {
            resultLabel.setText(this.result);
        }
        Table theTable = new Table(parent, 2064);
        theTable.setLinesVisible(true);
        theTable.setHeaderVisible(true);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        theTable.setLayoutData((Object)data);
        String[] hwTitles = new String[]{"HW Instance", "Utilization", "Result", "Analysis Context"};
        int i2 = 0;
        while (i2 < hwTitles.length) {
            TableColumn column = new TableColumn(theTable, 0);
            column.setText(hwTitles[i2]);
            ++i2;
        }
        for (HWAnalysisResultData hwResDataElem : this.resultHWData1) {
            theHwUtilization = hwResDataElem.hw_utilization;
            theHwUtilizationPerc = UMLUtils.getValue((String)theHwUtilization, (String)"value");
            if (theHwUtilizationPerc == null || theHwUtilizationPerc.length() <= 0) continue;
            hwItem = new TableItem(theTable, 0);
            i = 0;
            theHwInstance = hwResDataElem.hw_instance;
            hwItem.setText(i, theHwInstance);
            theHwUtilizationPerc = String.valueOf(theHwUtilizationPerc) + "%";
            hwItem.setText(++i, theHwUtilizationPerc);
            ++i;
            theHwResult = hwResDataElem.getResultString();
            if (theHwResult.equalsIgnoreCase("OK")) {
                hwItem.setForeground(i, green);
            } else {
                hwItem.setForeground(i, red);
            }
            hwItem.setText(i, theHwResult);
            hwItem.setText(++i, String.valueOf(this.analysisContextName1) + " (1)");
            ++i;
        }
        for (HWAnalysisResultData hwResDataElem : this.resultHWData2) {
            theHwUtilization = hwResDataElem.hw_utilization;
            theHwUtilizationPerc = UMLUtils.getValue((String)theHwUtilization, (String)"value");
            if (theHwUtilizationPerc == null || theHwUtilizationPerc.length() <= 0) continue;
            theHwUtilizationPerc = String.valueOf(theHwUtilizationPerc) + "%";
            hwItem = new TableItem(theTable, 0);
            i = 0;
            theHwInstance = hwResDataElem.hw_instance;
            hwItem.setText(i, theHwInstance);
            hwItem.setText(++i, theHwUtilizationPerc);
            ++i;
            theHwResult = hwResDataElem.getResultString();
            if (theHwResult.equalsIgnoreCase("OK")) {
                hwItem.setForeground(i, green);
            } else {
                hwItem.setForeground(i, red);
            }
            hwItem.setText(i, theHwResult);
            hwItem.setText(++i, String.valueOf(this.analysisContextName2) + " (2)");
            ++i;
        }
        i = 0;
        while (i < hwTitles.length) {
            theTable.getColumn(i).pack();
            ++i;
        }
        Table theSwTable = new Table(parent, 2818);
        theSwTable.setLinesVisible(true);
        theSwTable.setHeaderVisible(true);
        data = new GridData(4, 1, true, false, 1, 1);
        theSwTable.setLayoutData((Object)data);
        String[] swTitles = new String[]{"SW Instance", "Operation", "Resp. T. (1)", "Resp. T. (2)", "Block. T. (1) ", "Block. T. (2) ", "Sched. (1)", "Sched. (2)"};
        int i3 = 0;
        while (i3 < swTitles.length) {
            TableColumn column = new TableColumn(theSwTable, 0);
            if (i3 == 2 || i3 == 4 || i3 == 6) {
                column.setToolTipText(this.analysisContextName1);
            }
            if (i3 == 3 || i3 == 5 || i3 == 7) {
                column.setToolTipText(this.analysisContextName2);
            }
            column.setText(swTitles[i3]);
            ++i3;
        }
        for (AnalysisResultData resDataElem : this.resultData1) {
            int i4 = 0;
            String theSwInstance = resDataElem.instance;
            AnalysisResultData otherAnalysisResult = this.resultMap2.get(theSwInstance);
            TableItem item = new TableItem(theSwTable, 0);
            item.setText(i4, theSwInstance);
            Operation theOperation = resDataElem.ctxOP;
            String theOperationName = theOperation.getName();
            item.setText(++i4, theOperationName);
            String theRespTime = resDataElem.respT;
            item.setText(++i4, theRespTime);
            String otherRespTime = otherAnalysisResult.respT;
            item.setText(++i4, otherRespTime);
            String theBlockingTime = resDataElem.blockT;
            item.setText(++i4, theBlockingTime);
            String otherBlockingTime = otherAnalysisResult.blockT;
            item.setText(++i4, otherBlockingTime);
            ++i4;
            String theResult = this.convertToOkNok(resDataElem.isSched);
            if (theResult.equalsIgnoreCase("OK")) {
                item.setForeground(i4, green);
            } else {
                item.setForeground(i4, red);
            }
            item.setText(i4, theResult);
            ++i4;
            String otherResult = this.convertToOkNok(otherAnalysisResult.isSched);
            if (otherResult.equalsIgnoreCase("OK")) {
                item.setForeground(i4, green);
            } else {
                item.setForeground(i4, red);
            }
            item.setText(i4, otherResult);
            ++i4;
        }
        i = 0;
        while (i < swTitles.length) {
            theSwTable.getColumn(i).pack();
            ++i;
        }
        return super.createDialogArea(parent);
    }

    private String convertToOkNok(String isSched) {
        String result = "NOT OK";
        if (isSched.equalsIgnoreCase("YES")) {
            result = "OK";
        }
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        super.close();
    }
}

