/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.wizard.page;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.BasicWizardPage;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.page.LastPage;
import org.polarsys.chess.service.core.model.ChessSystemModel;

public class AssignValuesPage
extends BasicWizardPage {
    private OCRAExecService ocraExecService = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private DialogUtil dialogUtil = DialogUtil.getInstance();
    private static final Logger logger = Logger.getLogger(AssignValuesPage.class);
    private Composite container;
    private Composite compositeAssignParamsContent;
    Button selectExistingParamsButton;
    private Table table;
    private Label tableLabel;
    private TableColumn columnParNames;
    private TableColumn columnParValues;
    private ArrayList<Text> parameterValueTexts = new ArrayList();
    private ArrayList<TableEditor> parameterValueEditor = new ArrayList();
    private String originalOssFileName;
    private File ossFile;
    private Map<String, String> parametersHashMap;
    private Map<String, String> selectedExistingParametersList;
    private Integer selectedExistingArchitectureIndex;
    private Map<String, Map<String, String>> existingParametersLists;
    private EObject selectedElement;
    private boolean isFirstPage;
    private int timeSpecification;
    private int currNumInstatiation;
    private IProgressMonitor monitor;

    public AssignValuesPage(boolean isFirstPage, String originalOssFileName, EObject selectedElement, File ossFile, Integer selectedExistingArchitectureIndex, Map<String, String> selectedExistingParametersList, Map<String, Map<String, String>> existingParametersLists, Map<String, String> parametersHashMap, EList<EList<String>> prevParametersList, int currNumInstatiation, int timeSpecification, IProgressMonitor monitor, IWizard iWizard) throws FileNotFoundException {
        super("Assign values to parameters", prevParametersList);
        this.setTitle("Architecture Instantiation " + currNumInstatiation + ". Assign values to parameters");
        this.setDescription("Please assign a value to each parameter.");
        this.setWizard(iWizard);
        this.isFirstPage = isFirstPage;
        this.originalOssFileName = originalOssFileName;
        this.selectedElement = selectedElement;
        this.ossFile = ossFile;
        this.parametersHashMap = parametersHashMap;
        this.selectedExistingArchitectureIndex = selectedExistingArchitectureIndex;
        this.selectedExistingParametersList = selectedExistingParametersList;
        this.existingParametersLists = existingParametersLists;
        this.timeSpecification = timeSpecification;
        this.currNumInstatiation = currNumInstatiation;
        this.monitor = monitor;
        this.setPageComplete(false);
    }

    private void updateParametersHashMapWithExistingValues(Map<String, String> parametersHashMap, Map<String, String> selectedExistingParametersList) {
        logger.debug((Object)"updateParametersHashMapWithExistingValues");
        logger.debug((Object)("selectedExistingParametersList!=null: " + null != null ? 1 : 0));
        logger.debug((Object)("parametersHashMap!=null: " + parametersHashMap != null ? 1 : 0));
        logger.debug((Object)("(selectedExistingParametersList != null) && (parametersHashMap != null): " + (selectedExistingParametersList != null && parametersHashMap != null)));
        if (selectedExistingParametersList != null && parametersHashMap != null) {
            logger.debug((Object)"in cicle for");
            logger.debug((Object)("in cicle for: " + parametersHashMap.entrySet().size()));
            for (Map.Entry<String, String> par : parametersHashMap.entrySet()) {
                logger.debug((Object)("curr Param in the GUI: " + par));
            }
            for (Map.Entry<String, String> existingParam : selectedExistingParametersList.entrySet()) {
                logger.debug((Object)("currExistingParam: " + existingParam));
                if (!parametersHashMap.containsKey(existingParam.getKey())) continue;
                logger.debug((Object)("parametersHashMap.put: " + existingParam.getKey() + " - " + existingParam.getValue()));
                parametersHashMap.put(existingParam.getKey(), existingParam.getValue());
            }
        }
    }

    public IWizardPage getNextPage() {
        logger.debug((Object)"getNextPage");
        try {
            this.setParametersValues(this.parametersHashMap, this.parameterValueTexts);
            EList<String> parametersList = this.prepareParameterValuesAsArrayList(this.parametersHashMap);
            File parametersValuesFile = this.ocraExecService.prepareParameterValuesFile(parametersList, this.ossFile.getName());
            File newOssFile = this.ocraExecService.executeInstantiateArchitecture(this.originalOssFileName, this.ossFile, parametersValuesFile, this.currNumInstatiation, this.timeSpecification, this.monitor);
            logger.debug((Object)("newOssFile path: " + newOssFile.getPath()));
            BasicEList allParametersList = new BasicEList((Collection)this.prevParametersList);
            allParametersList.add(parametersList);
            Map newParametersList = this.ocraExecService.executeGetParameters(newOssFile, this.timeSpecification, this.monitor);
            if (this.selectExistingParamsButton.getSelection()) {
                this.updateParametersHashMapWithExistingValues(newParametersList, this.selectedExistingParametersList);
            }
            if (newParametersList != null && !newParametersList.isEmpty()) {
                logger.debug((Object)("newParametersList size: " + newParametersList.entrySet().size()));
                logger.debug((Object)("prevParametersList size: " + this.prevParametersList.size()));
                logger.debug((Object)("allParametersList size: " + allParametersList.size()));
                logger.debug((Object)("selectedExistingArchitectureIndex: " + this.selectedExistingArchitectureIndex));
                AssignValuesPage nextPage = new AssignValuesPage(false, this.originalOssFileName, this.selectedElement, newOssFile, this.selectExistingParamsButton.getSelection() ? this.selectedExistingArchitectureIndex : null, this.selectedExistingParametersList, this.existingParametersLists, newParametersList, (EList<EList<String>>)allParametersList, this.currNumInstatiation + 1, this.timeSpecification, this.monitor, this.getWizard());
                return nextPage;
            }
            LastPage lastPage = new LastPage(this.selectedElement, newOssFile, (EList<EList<String>>)allParametersList);
            lastPage.setWizard(this.getWizard());
            return lastPage;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dialogUtil.showMessage_ExceptionError(e);
            return null;
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.container = new Composite(parent, 2048);
        GridLayout containerLayout = new GridLayout(2, true);
        this.container.setLayout((Layout)containerLayout);
        this.createExistingParamsSelectionArea(this.container);
        this.createViewPrevParametersArea(this.container);
        this.createSetParametersArea(this.container);
        this.container.redraw();
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void createExistingParamsSelectionArea(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        Composite compositeContent = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(3, false);
        compositeContent.setEnabled(this.isFirstPage);
        compositeContent.setLayout((Layout)layout);
        compositeContent.setLayoutData((Object)gridData);
        this.selectExistingParamsButton = new Button(compositeContent, 32);
        if (!this.isFirstPage && this.selectedExistingArchitectureIndex != null) {
            this.selectExistingParamsButton.setSelection(true);
        } else {
            this.selectExistingParamsButton.setSelection(false);
        }
        Label labelCheck = new Label(compositeContent, 0);
        labelCheck.setText("Select parameters used to instantiate the following architecture:");
        this.createCombo(compositeContent, this.existingParametersLists);
    }

    private Combo createCombo(Composite parent, Map<String, Map<String, String>> existingParametersLists) {
        final Combo combo = new Combo(parent, 774);
        this.setComboContents(combo, existingParametersLists);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                logger.debug((Object)("selectedExistingParametersList: " + e));
                if (AssignValuesPage.this.selectExistingParamsButton.getSelection()) {
                    AssignValuesPage.this.selectedExistingParametersList = (Map)combo.getData(combo.getText());
                    AssignValuesPage.this.selectedExistingArchitectureIndex = combo.getSelectionIndex();
                    AssignValuesPage.this.updateParametersHashMapWithExistingValues(AssignValuesPage.this.parametersHashMap, AssignValuesPage.this.selectedExistingParametersList);
                    AssignValuesPage.this.populateColumnParValues();
                    AssignValuesPage.this.compositeAssignParamsContent.layout(true);
                }
                logger.debug((Object)("selectedExistingParametersList size: " + AssignValuesPage.this.selectedExistingParametersList.size()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return combo;
    }

    private void setComboContents(Combo combo, Map<String, Map<String, String>> existingParametersLists) {
        combo.removeAll();
        if (existingParametersLists != null) {
            for (Map.Entry<String, Map<String, String>> entry : existingParametersLists.entrySet()) {
                combo.add(entry.getKey());
                combo.setData(entry.getKey(), entry.getValue());
            }
            if (this.selectedExistingArchitectureIndex != null) {
                combo.select(this.selectedExistingArchitectureIndex.intValue());
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    protected Control createSetParametersArea(Composite parent) {
        logger.debug((Object)"createSetParametersArea");
        this.compositeAssignParamsContent = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(1, true);
        this.compositeAssignParamsContent.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = 500;
        this.compositeAssignParamsContent.setLayoutData((Object)gd);
        this.tableLabel = new Label(this.compositeAssignParamsContent, 0);
        this.tableLabel.setText("Set values:");
        this.tableLabel.setLayoutData((Object)new GridData());
        this.createAssignValueTable();
        this.compositeAssignParamsContent.redraw();
        return this.compositeAssignParamsContent;
    }

    private void createAssignValueTable() {
        this.table = new Table(this.compositeAssignParamsContent, 2816);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.columnParNames = new TableColumn(this.table, 0);
        this.columnParValues = new TableColumn(this.table, 0);
        this.populateColumnParValues();
        this.columnParNames.setText("Parameters Name");
        this.columnParNames.pack();
        this.columnParValues.setText("Parameters Value");
        this.columnParValues.pack();
        this.columnParValues.setWidth(Math.max(this.columnParValues.getWidth(), 60));
        GridData tableGridData = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)tableGridData);
        this.compositeAssignParamsContent.redraw();
    }

    private void populateColumnParValues() {
        logger.debug((Object)"populateColumnParValues");
        this.table.removeAll();
        this.parameterValueTexts.clear();
        this.clearTableEditors();
        for (Map.Entry<String, String> parameterEntry : this.parametersHashMap.entrySet()) {
            TableItem parameterNameItem = new TableItem(this.table, 0);
            parameterNameItem.setText(0, parameterEntry.getKey());
            Text parameterValueText = new Text((Composite)this.table, 16384);
            parameterValueText.setData((Object)parameterEntry.getKey());
            parameterValueText.setText(parameterEntry.getValue());
            this.parameterValueTexts.add(parameterValueText);
            TableEditor editor = new TableEditor(this.table);
            editor.minimumWidth = 100;
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)parameterValueText, parameterNameItem, 1);
            this.parameterValueEditor.add(editor);
        }
    }

    private void clearTableEditors() {
        if (this.parameterValueEditor != null) {
            for (TableEditor tableEditor : this.parameterValueEditor) {
                tableEditor.getEditor().dispose();
            }
            this.parameterValueEditor.clear();
        }
    }

    private void setParametersValues(Map<String, String> parametersList, ArrayList<Text> parameterValueTexts) {
        int i = 0;
        while (i < parameterValueTexts.size()) {
            logger.debug((Object)("setParametersValues. " + (String)parameterValueTexts.get(i).getData() + " , " + parameterValueTexts.get(i).getText()));
            parametersList.put((String)parameterValueTexts.get(i).getData(), parameterValueTexts.get(i).getText());
            ++i;
        }
    }

    private EList<String> prepareParameterValuesAsArrayList(Map<String, String> parametersList) throws Exception {
        BasicEList parList = new BasicEList();
        for (Map.Entry<String, String> parameterEntry : parametersList.entrySet()) {
            if (parameterEntry.getValue().equals("")) continue;
            logger.debug((Object)("prepareParameterValuesAsArrayList. " + parameterEntry.getKey() + " , " + parameterEntry.getValue()));
            parList.add((Object)(String.valueOf(parameterEntry.getKey()) + "=" + parameterEntry.getValue()));
        }
        if (parList.isEmpty()) {
            throw new Exception("No parameters are set.");
        }
        return parList;
    }
}

